<?php
if (function_exists('wp_register_script') && !class_exists('ScriptManager')) {

//**************************************************************************************
// script manager
//**************************************************************************************

class ScriptManager {
 
  /*
  * Constructor
  */
  function ScriptManager() {
   global $wp_scripts;
   if (!is_a($wp_scripts, 'WP_Scripts')) $wp_scripts = new WP_Scripts();

   add_action('wp_head', array($this, 'head_print_script'), 11);
   add_action('wp_footer', array($this, 'footer_print_script'), 11);
   add_filter('print_scripts_array', array($this, 'cs_handlejqueryconflict'));
  }

  // 指定されたスクリプトが登録されていないか、登録されているものよりバージョンが大きい場合、登録する
  function register_script( $handle, $src = '', $deps = false, $ver = false ) {
   global $wp_scripts, $wp_version;

   if (version_compare($wp_version, "2.6", ">=")) {
     if (isset($wp_scripts->registered[$handle])) {
      if (version_compare($wp_scripts->registered[$handle]->ver, $ver, '<')) {
       if ($src  != '')     $wp_scripts->registered[$handle]->src  = $src;
       if (is_array($deps)) $wp_scripts->registered[$handle]->deps = $deps;
       if ($ver  != false)  $wp_scripts->registered[$handle]->ver  = $ver;
      }
     } else {
      wp_register_script($handle, $src, $deps, $ver);
     }
   } else {
     if (isset($wp_scripts->scripts[$handle])) {
      if (version_compare($wp_scripts->scripts[$handle]->ver, $ver, '<')) {
       if ($src  != '')     $wp_scripts->scripts[$handle]->src  = $src;
       if (is_array($deps)) $wp_scripts->scripts[$handle]->deps = $deps;
       if ($ver  != false)  $wp_scripts->scripts[$handle]->ver  = $ver;
      }
     } else {
      wp_register_script($handle, $src, $deps, $ver);
     }
   }
  }

  // 指定されたスクリプトをキューから削除する
  function dequeue_script( $handle ) {
   global $wp_scripts, $wp_version;
   if (!is_a($wp_scripts, 'WP_Scripts')) $wp_scripts = new WP_Scripts();
   $wp_scripts->dequeue( $handle );
  }

  // インラインの JavaScript をヘッダに書き出す
  function head_print_script() {
   $js = apply_filters('head_script/ScriptManager', '');

   if ($js != '') {
    echo "<script type=\"text/javascript\">/*<![CDATA[ */\n";
    echo $js;
    echo "/* ]]>*/</script>\n";
   }
  }

  // インラインの JavaScript をフッタに書き出す
  function footer_print_script() {
   $js = apply_filters('footer_script/ScriptManager', '');

   if ($js != '') {
    echo "<script type=\"text/javascript\">/*<![CDATA[ */\n";
    echo $js;
    echo "/* ]]>*/</script>\n";
   }
  }

  //**************************************************************************************
  // jQuery noConflict
  //**************************************************************************************
  // prototype.js jQuery のコンフリクトを解消する
  function cs_handlejqueryconflict($args) {
    if(false !== $jquerypos = array_search('jquery', $args) && in_array('prototype', $args)) {
      // Need to add a no conflict call after the jquery.
      $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
      $filename = explode("/", __FILE__);
      if(count($filename) <= 1) $filename = explode("\\", __FILE__);
      $plugin_dir  = $filename[count($filename) - 3];
      $plugin_url  = trailingslashit(trailingslashit(defined('WP_PLUGIN_URL') ? WP_PLUGIN_URL : trailingslashit(get_bloginfo('wpurl')).$plugins_dir).$plugin_dir);
      unset($filename);
      wp_register_script('jquery.noconflict', $plugin_url.'js/jquery.noconflict.js' ,array('jquery'));
      array_splice( $args, $jquerypos+1, 0, 'jquery.noconflict' );
    }
    return $args;
  }
}

global $script_manager;
$script_manager = new ScriptManager();
}

?>
