<?php
/*
Plugin Name: Custom Quicktags
Plugin URI: http://082net.com/
Description: This plugin needs WP 2.1 or higher. Customize quicktag buttons. Based on <a href="http://roel.meurders.nl/wordpress-plugins/wp-addquicktag-plugin-for-adding-quicktags/">WP-AddQuicktag</a> by Roel Meurders
Version: 0.11
Author: Choen, Youngmin
Author URI: http://082net.com/
*//*
Change Logs ::

Lisense : GPL(http://www.gnu.org/copyleft/gpl.html)
/*  Copyright 2006  Cheon, Young-Min  (email : 082net@gmail.com, site : http://082net.com)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
class CustomQuickTags {
	var $defaults, $op, $error;
	var $temp_btn = array();

	function CustomQuickTags() {
		load_plugin_textdomain('custom-quicktags', 'wp-content/plugins/custom-quicktags/lang/');
		$this->get_defaults();
		$this->op = get_settings('custom_quicktags');
	}

	function admin_menu(){
		if (function_exists('add_options_page')) {
			add_options_page('Custom Quicktags', 'Quicktags', 8, 'custom-quicktags', array(&$this, 'options_page'));
		}
	}

	function get_defaults(){
		$this->defaults = array();
		$this->defaults['ed_strong'] = array('text'=>'b','start'=>'<strong>', 'end'=>'</strong>', 'key'=>'b','open'=>0);
		$this->defaults['ed_em'] = array('text'=>'i','start'=>'<em>', 'end'=>'</em>', 'key'=>'i','open'=>0);
		$this->defaults['ed_link'] = array('text'=>'link','start'=>'', 'end'=>'</a>', 'key'=>'a','open'=>0);
		$this->defaults['ed_block'] = array('text'=>'b-quote','start'=>'\n<blockquote>', 'end'=>'</blockquote>\n', 'key'=>'q','open'=>0);
		$this->defaults['ed_del'] = array('text'=>'del','start'=>'<del datetime="%datetime%">', 'end'=>'</del>', 'key'=>'d','open'=>0);
		$this->defaults['ed_ins'] = array('text'=>'ins','start'=>'<ins datetime="%datetime%">', 'end'=>'</ins>', 'key'=>'s','open'=>0);
		$this->defaults['ed_img'] = array('text'=>'img','start'=>'', 'end'=>'', 'key'=>'m','open'=>1);
		$this->defaults['ed_ul'] = array('text'=>'ul','start'=>'<ul>\n', 'end'=>'</ul>\n', 'key'=>'u','open'=>0);
		$this->defaults['ed_ol'] = array('text'=>'ol','start'=>'<ol>\n', 'end'=>'</ol>\n', 'key'=>'o','open'=>0);
		$this->defaults['ed_li'] = array('text'=>'li','start'=>'\t<li>', 'end'=>'</li>\n', 'key'=>'l','open'=>0);
		$this->defaults['ed_code'] = array('text'=>'code','start'=>'<code>', 'end'=>'</code>', 'key'=>'c','open'=>0);
		$this->defaults['ed_more'] = array('text'=>'more','start'=>'<!--more-->', '', 'key'=>'t','open'=>1);
		$this->defaults['ed_next'] = array('text'=>'page','start'=>'<!--nextpage-->', '', 'key'=>'p','open'=>1);
		$this->defaults['ed_spell'] = array('text'=>'lookup');
		$this->defaults['ed_close'] = array('text'=>'Close Tags');
//		$this->defaults['ed_smilies'] = array('text'=>'smilies');
	}

	function print_button($id, $b, $ob='edButtons'){
		$b['start'] = preg_replace('![\n\r]+!', "\\n", $b['start']);
		$b['start'] = str_replace(array("'", '%datetime%'), array("\'", "' + datetime + '"), $b['start']);
		$b['end'] = preg_replace('![\n\r]+!', "\\n", $b['end']);
		$b['end'] = str_replace("'", "\'", $b['end']);
		$b['open'] = ($b['open'])?'-1':'1';
		return $ob."[".$ob.".length] = new edButton('".$id."','".$b['text']."','".$b['start']."', '".$b['end']."','".$b['key']."', ".$b['open'].");\n";
	}

	function print_buttons(){
?>
// Reset edButtons
var edButtons = new Array();
<?php
		foreach($this->defaults as $k=>$v){
			if($k!='ed_spell' && $k!='ed_close' && $k!='ed_smilies' && $this->op['defaults'][$k])
				echo $this->print_button($k, $this->defaults[$k]);
		}
		for($i=0;$i<count($this->op['buttons']);$i++){
			echo $this->print_button('ed_custom'.$i, $this->op['buttons'][$i]);
		}
?>
function edToolbar() {
	document.write('<div id="ed_toolbar">');
	for (i = 0; i < edButtons.length; i++) {
		edShowButton(edButtons[i], i);
	}
<?php if($this->op['defaults']['ed_spell']) { ?>
	document.write('<input type="button" id="ed_spell" class="ed_button" onclick="edSpell(edCanvas);" title="Dictionary lookup" value="lookup" />');
<?php } if($this->op['defaults']['ed_close']) { ?>
	document.write('<input type="button" id="ed_close" class="ed_button" onclick="edCloseAllTags();" title="Close all open tags" value="Close Tags" />');
<?php } if($this->op['ed_smilies'] == 'popup') { ?>
	document.write('<input type="button" id="ed_smilies" class="ed_button" onclick="PopupSmilies();" title="Open a window displaying clickable smilies" value="smilies" />');
<?php } elseif($this->op['ed_smilies'] == 'dropdown') { ?>
	edSmilies();
<?php } ?>
//	edShowLinks(); // disabled by default
	document.write('</div>');
}
<?php if(!empty($this->op['link_class'])) { ?>
function edInsertLink(myField, i, defaultValue) {
	if (!defaultValue) {
		defaultValue = 'http://';
	}
	if (!edCheckOpenTags(i)) {
		var URL = prompt('Enter the URL' ,defaultValue);
		if (URL) {
			edButtons[i].tagStart = '<a class="<?php echo $this->op['link_class']; ?>" href="' + URL + '">';
			edInsertTag(myField, i);
		}
	}
	else {
		edInsertTag(myField, i);
	}
}
<?php } if($this->op['ed_smilies'] == 'popup') {
	$this_url = get_option('siteurl').'/wp-content/plugins/custom-quicktags/smilies-popup.php';
?>
function PopupSmilies(){
window.open("<?php echo $this_url; ?>", "Smilies", "width=390,height=90,scrollbars=yes");
}
<?php } elseif ($this->op['ed_smilies'] == 'dropdown') { ?>
function edSmilies() {
	var tempStr = '<select onchange="edInsertContent(document.post.content, this.options[this.selectedIndex].value);"><option value="" selected>smilies</option>';
<?php 
	global $wpsmiliestrans;
	$smiliestrans = array_map('trim',array_flip($wpsmiliestrans));
	$img_url = get_option('siteurl').'/wp-includes/images/smilies/';
	foreach($smiliestrans as $filename => $code) {
?>
		tempStr += '<option value="<?php echo $code; ?>"><?php echo $code; ?></option>'
<?php } ?>
	tempStr += '</select>';
	document.write(tempStr);
}
<?php } 
	}

	function delete_buttons() {
		if(!is_array($_POST['cq_delete']) || empty($_POST['cq_delete']))
			return __('Failed to delete buttons. You should select more than one.', 'custom-quicktags');
		$i=0;
		foreach($_POST['cq_delete'] as $k) {
			array_splice($this->op['buttons'], ($k-$i), 1);
			$i++;
		}
		if(empty($this->op['buttons']))
			unset($this->op['buttons']);
		$this->op['ver'] = time();
		update_option('custom_quicktags', $this->op);
		return __('Buttons deleted.', 'custom-quicktags');
	}

	function add_button() {
		$b = $_POST['add_button'];
		if ($b['text'] == '' || $b['start'] == '')
			return __('You should fill in all required(*) fields.', 'custom-quicktags');
		$b['text'] = htmlentities(trim($b['text']));
		$b['start'] = stripslashes(preg_replace('![\n\r]+!', "\\n", $b['start']));
		$b['end'] = stripslashes($b['end']);
		$b['key'] = substr(trim($b['key']), 0, 1);
		$b['open'] = (empty($b['end']))?1:0;
		foreach($this->defaults as $k=>$v){
			if($this->op['defaults'][$k] && $b['key'] == $v['key']) {
				$error_str = sprintf(__('Your accesskey \'%s\' is already used by Wordpress default quicktag(%s)', 'custom-quicktags'), $b['key'], $k);
				$b['key'] = '';
				$this->temp_btn = $b;
				return $error_str;
				break;
			}
		}
		$this->op['buttons'][] = $b;
		$this->op['ver'] = time();
		update_option('custom_quicktags', $this->op);
		return __('Button added.', 'custom-quicktags');
	}

	function update_option(){
		$this->temp_btn = array();
		$message = '';
		$temp_btn = array();
		if (isset($_POST['cq_update_options'])) {
			$this->op['defaults'] = $_POST['cq_defaults'];
			$this->op['link_class'] = str_replace(' ', '-', trim($_POST['link_class']));
			$this->op['ed_smilies'] = $_POST['ed_smilies'];
			$this->op['ver'] = time();
			update_option('custom_quicktags', $this->op);
			$message = __('Options saved.', 'custom-quicktags');
		} elseif (isset($_POST['cq_delete_buttons'])) {
			$message = $this->delete_buttons();
		} elseif (isset($_POST['cq_add_button'])) {
			$message = $this->add_button();
		} elseif (isset($_POST['reset_options'])) {
			$this->set_options(true);
			$message = __('Options reseted.', 'custom-quicktags');
		}
		if('' !== $message)
			echo '<div class="updated"><p><strong>'.$message.'</strong></p></div>';
	}

	function options_page(){
		$this->update_option();
?>
<div class="wrap">
	<h2><?php _e('Custom Quicktags', 'custom-quicktags'); ?></h2>
	<form name="form1" method="post" action="">
	<fieldset class="options">
		<legend><?php _e('Default buttons', 'custom-quicktags'); ?></legend>
		<table width="100%" cellspacing="2" cellpadding="5" class="widefat plugins">
		<tr valign="top">
<?php $j=1;
		foreach ($this->defaults as $k=>$v) {
			echo '<td><label for="'.$k.'">'.$k.'(<strong>'.$v['text'].'</strong>)</label> - <input type="checkbox" value="1" id="'.$k.'" name="cq_defaults['.$k.']"'.(($this->op['defaults'][$k])?' checked="checked"':'').' /></td>'."\n";
			if(!($j%3)) { $cq_class = (!($j%6))?'':'alternate';
				echo '</tr><tr valign="top" class="'.$cq_class.'">'."\n";
			}
			$j++;
		} 
?>
		</tr>
		<tr valign="top" class="alternate">
			<td colspan="2"><strong><?php _e('link css class', 'custom-quicktags'); ?></strong>: <input type="text" name="link_class" id="link_class" value="<?php echo $this->op['link_class']; ?>" /><br /> (<?php _e('CSS class for links in content. leave blank for no CSS class', 'custom-quicktags'); ?>)</td>
			<td><strong><?php _e('Smilies button', 'custom-quicktags'); ?></strong>: <select name="ed_smilies">
			<option value="0"<?php if(!$this->op['ed_smilies']) { ?> selected="selected"<?php } ?>><?php _e('None', 'custom-quicktags'); ?></option>
			<option value="dropdown"<?php if($this->op['ed_smilies']=='dropdown') { ?> selected="selected"<?php } ?>><?php _e('Drop-Down', 'custom-quicktags'); ?></option>
			<option value="popup"<?php if($this->op['ed_smilies']=='popup') { ?> selected="selected"<?php } ?>><?php _e('Popup Window', 'custom-quicktags'); ?></option>
			</select></td>
		</tr>
		</table>
	</fieldset>
	<p class="submit"><input type="submit" name="cq_update_options" value="<?php _e('Update Options &raquo;', 'custom-quicktags'); ?>" /></p>
	</form>
	<hr />			
	<form name="form2" method="post" action="">
	<fieldset class="options">
		<legend><?php _e('Current buttons', 'custom-quicktags'); ?></legend>
		<table width="100%" cellspacing="2" cellpadding="5" class="widefat plugins">
			<tr valign="top" style="text-align:center;">
			<thead>
				<th width="2%" style="text-align:center;">&nbsp;</th>
				<th width="8%" style="text-align:center;"><?php _e('Buttontext', 'custom-quicktags'); ?></th>
				<th width="50%" style="text-align:center;"><?php _e('Start tag(s)', 'custom-quicktags'); ?></th>
				<th width="34%" style="text-align:center;"><?php _e('End tag(s)', 'custom-quicktags'); ?></th>
				<th width="6%" style="text-align:center;"><?php _e('Key', 'custom-quicktags'); ?></th>
			</thead>
			</tr>
<?php
		for ($i = 0; $i < count($this->op['buttons']); $i++){
			$tr_class = ($i%2)?' class="alternate"':'';
			$b = $this->op['buttons'][$i];
			echo '
			<tr valign="top" style="text-align: center;"'.$tr_class.'>
				<td><input type="checkbox" name="cq_delete[]" value="'.$i.'" /></td>
				<td><strong>'.$b['text'].'</strong></td>
				<td>'.wp_specialchars($b['start']).'</td>
				<td>'.wp_specialchars($b['end']).'</td>
				<td>'.$b['key'].'</td>
			</tr>
			';
		}
?>
		</table>
		</fieldset>
	<p class="submit"><input type="submit" name="cq_delete_buttons" value="<?php _e('Delete Checked &raquo;', 'custom-quicktags'); ?>" /></p>
	</form>
	<hr />
	<form name="form3" method="post" action="">
	<fieldset class="options">
		<legend><?php _e('Add button', 'custom-quicktags'); ?></legend>
		<p><?php _e('Fill in the fields below to add the quicktags. Fields with * are compulsary.', 'custom-quicktags'); ?></p>
		<table width="100%" cellspacing="2" cellpadding="5" class="widefat plugins">
			<tr valign="top" style="text-align:center;">
			<thead>
				<th width="10%" style="text-align:center;"><?php _e('Buttontext', 'custom-quicktags'); ?>*</th>
				<th width="50%" style="text-align:center;"><?php _e('Start tag(s)', 'custom-quicktags'); ?>*</th>
				<th width="34%" style="text-align:center;"><?php _e('End tag(s)', 'custom-quicktags'); ?></th>
				<th width="6%" style="text-align:center;"><?php _e('Key', 'custom-quicktags'); ?></th>
			</thead>
			</tr>
			<tr valign="top" style="text-align:center;">
<?php
		echo '
				<td><input type="text" name="add_button[text]" style="width: 95%;" value="'.$this->temp_btn['text'].'" /></td>
				<td><input type="text" name="add_button[start]" style="width: 95%;" value="'.$this->temp_btn['start'].'" /></td>
				<td><input type="text" name="add_button[end]"  style="width: 95%;" value="'.$this->temp_btn['end'].'" /></td>
				<td><input type="text" name="add_button[key]" style="width: 95%;" value="'.$this->temp_btn['key'].'" /></td>';
?>
			</tr>
		</table>
	</fieldset>
	<p class="submit"><input type="submit" name="cq_add_button" value="<?php _e('Add Button &raquo;', 'custom-quicktags'); ?>" /></p>
	</form>
	<hr />
	<form name="form4" method="post" action="">
	<p class="submit" style="text-align:left;"><input type="submit" name="cq_reset_options" value="<?php _e('Reset Options &raquo;', 'custom-quicktags'); ?>" /></p>
	</form>
</div>
<?php
	}

	function set_options($reset = false) {
		$this->op = array();
		foreach ($this->defaults as $name=>$value) {
			$this->op['defaults'][$name] = 1;
		}
		$this->op['link_class'] = '';
		unset($this->op['buttons']);
		$this->op['ver'] = time();
		if($reset)
			update_option('custom_quicktags', $this->op);
		else
			add_option('custom_quicktags', $this->op);
	}

	function print_scripts() {
		global $wp_scripts;
		$req = $_SERVER['REQUEST_URI'];
		if( !( strstr($req, 'post.php') || strstr($req, 'page.php') || strstr($req, 'page-new.php') || strstr($req, 'post-new.php') ) )
		return;

		$quicktags_ver = $wp_scripts->scripts['quicktags']->ver ? $wp_scripts->scripts['quicktags']->ver:$this->op['ver'];
		wp_deregister_script('quicktags');
		wp_register_script( 'main_quicktags', '/wp-includes/js/quicktags.js', false, $quicktags_ver);
		wp_register_script( 'quicktags', '/wp-content/plugins/custom-quicktags/custom-quicktags.js.php', array('main_quicktags'), $this->op['ver'] );
		if(function_exists('wp_localize_script')) {
			wp_localize_script( 'quicktags', 'quicktagsL10n', array(
				'quickLinks' => __('(Quick Links)'),
				'wordLookup' => __('Enter a word to look up:'),
				'dictionaryLookup' => attribute_escape(__('Dictionary lookup')),
				'lookup' => attribute_escape(__('lookup')),
				'closeAllOpenTags' => attribute_escape(__('Close all open tags')),
				'closeTags' => attribute_escape(__('close tags')),
				'enterURL' => __('Enter the URL'),
				'enterImageURL' => __('Enter the URL of the image'),
				'enterImageDescription' => __('Enter a description of the image')
			) );
		}
	}

	function &get_instance() {
		static $instance = array();
		if ( empty( $instance ) ) {
			$instance[] =& new CustomQuickTags();
		}
		return $instance[0];
	}
}

if(is_admin()) {
	// instance of plugin for hooks
	$CustomQT =& CustomQuickTags::get_instance();
	if(!get_settings('custom_quicktags'))
		$CustomQT->set_options();
	add_action('wp_print_scripts', array(&$CustomQT, 'print_scripts'));
	add_action('admin_menu', array(&$CustomQT, 'admin_menu'));
	unset($CustomQT);
}
?>