<?php
/* これは文字化け防止のための日本語文字列です。
   Above is a Japanese strings to avoid charset mis-understanding. */

/* ==================================================
 *   comments-post.php
     version 0.82
     based on wp-comments-post.php of WP 2.2.3
   ================================================== */
   
if ($_SERVER["REQUEST_METHOD"] != "POST") {
    header('Allow: POST');
	header("HTTP/1.1 405 Method Not Allowed");
	header("Content-type: text/plain");
    exit;
}

require dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';

nocache_headers();

$comment_post_ID = (int) $_POST['comment_post_ID'];

$status = $wpdb->get_row("SELECT post_status, comment_status FROM $wpdb->posts WHERE ID = '$comment_post_ID'");

if ( empty($status->comment_status) ) {
	do_action('comment_id_not_found', $comment_post_ID);
	Ktai_Style::ks_die('コメント対象の投稿が見当りません。');
	exit;
} elseif ( 'closed' ==  $status->comment_status ) {
	do_action('comment_closed', $comment_post_ID);
	Ktai_Style::ks_die( __('Sorry, comments are closed for this item.') );
} elseif ( 'draft' == $status->post_status ) {
	do_action('comment_on_draft', $comment_post_ID);
	exit;
}

$comment_author       = trim(mb_convert_encoding(strip_tags($_POST['author']), get_bloginfo('charset'), 'auto'));
$comment_author_email = trim($_POST['email']);
$comment_author_url   = trim($_POST['url']);
$comment_content      = trim(mb_convert_encoding($_POST['comment'], get_bloginfo('charset'), 'auto'));

// If the user is logged in
$user = wp_get_current_user();
if ( $user->ID ) {
	$comment_author       = $wpdb->escape($user->display_name);
	$comment_author_email = $wpdb->escape($user->user_email);
	$comment_author_url   = $wpdb->escape($user->user_url);
	if ( current_user_can('unfiltered_html') ) {
		if ( wp_create_nonce('unfiltered-html-comment_' . $comment_post_ID) != $_POST['_wp_unfiltered_html_comment'] ) {
			kses_remove_filters(); // start with a clean slate
			kses_init_filters(); // set up the filters
		}
	}
} else {
	if ( get_option('comment_registration') )
		Ktai_Style::ks_die( __('Sorry, you must be logged in to post a comment.') );
}

$comment_type = '';

if ( get_option('require_name_email') && !$user->ID ) {
	if ( 6 > strlen($comment_author_email) || '' == $comment_author )
		Ktai_Style::ks_die( __('Error: please fill the required fields (name, email).') );
	elseif ( !is_email($comment_author_email))
		Ktai_Style::ks_die( __('Error: please enter a valid email address.') );
}

if ( '' == $comment_content )
	Ktai_Style::ks_die( __('Error: please type a comment.') );

$commentdata = compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_type', 'user_ID');

$comment_id = wp_new_comment( $commentdata );

$comment = get_comment($comment_id);

$location = ( empty($_POST['redirect_to']) ? get_permalink($comment_post_ID) : $_POST['redirect_to'] );
$location = apply_filters('comment_post_redirect', $location, $comment);

wp_redirect($location);

?>
