<?php
/*
Plugin Name: akismet-multibyteview
Plugin URI: http://wppluginsj.sourceforge.jp/akismet-multibyteview/
Description: Akismet のコメント管理にマルチバイト文字を含むコメントだけを表示する機能を追加します。
Author: hiromasa
Version: 1.00
Author URI: http://another.maple4ever.net/
*/

/*  Copyright 2007 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * AkismetMultibyteView - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;
if(!is_admin()) return;

/******************************************************************************
 * AkismetMultibyteView
 * 
 * @author		hiromasa
 * @version		1.00
 * 
 *****************************************************************************/
class AkismetMultibyteView {
	
	var $plugin_name;
	var $plugin_uri;
	
	/**
	 * the constructor
	 * 
	 * @param none
	 * @return none
	 */
	function AkismetMultibyteView() {
		
		$this->plugin_name = 'akismet-multibyteview';
		
		$this->plugin_uri  = get_settings('siteurl');
		$this->plugin_uri .= '/wp-content/plugins/akismet-multibyteview/';
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function echoAdminHead() {
		
		echo '<script type="text/javascript" src="';
		echo $this->plugin_uri . 'akismet-multibyteview.js">';
		echo '</script>'  . "\n";
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function echoAdminFooter() {
		
		$akismetAdmin  = preg_replace('|^.*/wp-admin/|i', '', $_SERVER['PHP_SELF']);
		$akismetAdmin  = preg_replace('|^.*/plugins/|i', '', $akismetAdmin);
		$akismetAdmin .= '?page=akismet-admin';
		$akismetAdmin  = htmlspecialchars($akismetAdmin);
		
		echo '<div id="AkismetMutibyteMenu" style="padding: 0 1em 0 1em; text-align: right;">' . "\n";
		echo "<p><a href=\"./$akismetAdmin\">Normal View</a> / ";
		echo "<a href=\"./{$akismetAdmin}&multibyte=true\">Mutibyte Only View</a></p>";
		echo '</div>' . "\n";
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function hookAkismetQuery($query) {
		
		global $wpdb;
		
		$addQuery
			= ' AND LENGTH(comment_content) <> CHAR_LENGTH(comment_content) ';
		$patch = '-';
		
		$matches = array();
		$pattern
			= "/(SELECT COUNT\(\*\) FROM $wpdb->comments WHERE comment_approved = 'spam')/";
		if(preg_match($pattern, $query, $matches)) {
			$query = $matches[1] . $addQuery;
			$patch = '+';
		}
		
		$matches = array();
		$pattern
			= "/(SELECT \* FROM $wpdb->comments WHERE comment_approved = 'spam')( ORDER BY comment_date DESC LIMIT \d+, \d+)/";
		if(preg_match($pattern, $query, $matches)) {
			$query = $matches[1] . $addQuery . $matches[2];
			$patch = '+';
		}
		
		//for debug..
		//echo $patch . $query . '<br />';
		
		return $query;
		
	}
	
}

/******************************************************************************
 * AkismetMultibyteView - WordPress Interface Define
 *****************************************************************************/

if(strpos($_GET['page'], 'akismet-admin') === false) return;

$akismetMultibyteView = new AkismetMultibyteView();

add_action('admin_head', array(&$akismetMultibyteView, 'echoAdminHead'));
add_action('admin_footer', array(&$akismetMultibyteView, 'echoAdminFooter'));

if(isset($_GET['multibyte'])) {
	add_filter('query',  array(&$akismetMultibyteView, 'hookAkismetQuery'));
}
?>
 