<?php
/**
 * index.php:
 * wp-AT user interface for insert goods information to your post.
 * 
 * @author Sa.Ga
 * @version 1.0 Beta 2
 */

/*  Copyright 2006 Sa.Ga

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('../../../wp-config.php');
include_once(ABSPATH . '/wp-includes/version.php');
require_once (ABSPATH . '/wp-includes/wp-l10n.php');
require_once (ABSPATH . '/wp-admin/admin-functions.php');

require_once('class/wp-AT-function.php');
$was = new WP_AT_Search();
$data = $was->data;
$result = $was->result;
$wac = new WP_AT_Contents();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>WordPress &rsaquo;&rsaquo; <?php _e('wp-AT', 'wp_AT'); ?></title>
<link rel="stylesheet" href="../../../wp-admin/wp-admin.css" type="text/css" />
<link rel="shortcut icon" href="../../../wp-images/wp-favicon.png" />
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo get_settings('blog_charset');?>" />
<meta http-equiv="Content-Style-Type" content="text/css; charset=<?php echo get_settings('blog_charset');?>" />
<meta http-equiv="Content-Script-Type" content="text/javascript; charset=<?php echo get_settings('blog_charset');?>" />
<script type="text/javascript">
<!--
window.focus();
var viewSettings = new Array();
// -->
</script>
<script type="text/javascript" src="../../../wp-includes/js/fat.js"></script>
<?php WP_AT_Contents::getCSS(); ?>
</head>
<body>
<div id="wphead">
<h1><?php _e('wp-AT', 'wp_AT'); ?> <span>(<a href="javascript:window.close()"><?php _e('閉じる', 'wp_AT'); ?> &raquo;</a>)</span></h1>
</div>
<div class="wrap">
<form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post">
<div>
<?php $was->parseCategory($data['category']); ?>
<input type="hidden" name="row" value="10" />
<input type="text" name="keyword" value="<?php echo $data['keyword'] ?>" size="32" maxlength="128" />
<input type="submit" name="search" value="<?php _e('商品検索', 'wp_AT'); ?>" />
</div>
</form>
<?php
if (isset($_REQUEST['search'])) {
	if ($result['errormsg'] != null) {
?>
<div class="error">
<?php echo $result['errorcode'] ?>&nbsp;
<?php echo $result['errormsg'] ?>
</div>
<?php
	} elseif (intval($result['totalcount']) == 0) {
?>
<div class="error">
<?php _e('商品が見つかりません。', 'wp_AT'); ?>
</div>
<?php
	} else {
		$was->createPager($result);
?>
<table>
<?php
		$resIDs = array();
		for ($i = 0; $i < count($result['goods']); $i++) {
			$item = $result['goods'][$i];
			$size = $was->calcImageSize($item['width'], $item['height']);
			$resID = ($result['currentpage'] - 1) * $data['row'] + $i + 1;
			$resIDs[] = $resID;
?>
<tr>
<th><?php echo $resID ?>.</th>
<td>
<div>
<span id="virtualToggle_id_<?php echo $resID ?>_setting"></span>
<?php echo $item['goodsname'] ?>
</div>
<div id="id_<?php echo $resID ?>_setting" class="wrap">
<p><?php _e('エントリー挿入時、画像と品名には自動でリンクが含まれます。', 'wp_AT') ?></p>
<form id="id_<?php echo $resID ?>_form" action="#" method="post">
<dl>
<dt><input type="checkbox" name="box" id="ImageUrl" value="&lt;img src=&quot;<?php echo $item['imageurl'] ?>&quot; alt=&quot;<?php _e('[Image]', 'wp_AT') ?>&quot; /&gt;"
onchange="generateHTMLCode(this.form);"
<?php echo !$item['imageurl'] ? 'disabled="disabled" class="disabled"' : '' ?> />
<label for="ImageUrl"><?php _e('画像', 'wp_AT') ?></label></dt>
<dd><a href="<?php echo $item['imageurl'] ?>" target="_blank"><img src="<?php echo $item['imageurl'] ?>" width="<?php echo $size['width'] ?>" height="<?php echo $size['height'] ?>" alt="<?php _e('[image] (full size)', 'wp_AT') ?>" /></a></dd>
<dt><input type="checkbox" name="box" id="Maker" value="<?php echo $item['maker'] ?>"
onchange="generateHTMLCode(this.form);"
<?php echo !$item['maker'] ? 'disabled="disabled" class="disabled"' : '' ?> />
<label for="Maker"><?php _e('メーカー', 'wp_AT') ?></label></dt>
<dd><?php echo $item['maker'] ?></dd>
<dt><input type="checkbox" name="box" id="GoodsName" value="&lt;a href=&quot;<?php echo $item['linkcode'] ?>&quot; target=&quot;_blank&quot;&gt;<?php echo $item['goodsname'] ?>&lt;/a&gt;"
onchange="generateHTMLCode(this.form);"
<?php echo !$item['goodsname'] ? 'disabled="disabled" class="disabled"' : '' ?> />
<label for="GoodsName"><?php _e('品名', 'wp_AT') ?></label></dt>
<dd><a href="<?php echo $item['linkcode'] ?>" target="_blank"><?php echo $item['goodsname'] ?></a></dd>
<dt><input type="checkbox" name="box" id="Price" value="<?php echo $item['price'] ?>"
onchange="generateHTMLCode(this.form);"
<?php echo !$item['price'] ? 'disabled="disabled" class="disabled"' : '' ?> />
<label for="Price"><?php _e('税込価格', 'wp_AT') ?></label></dt>
<dd>&yen;<?php echo $item['price'] ?></dd>
<dt><input type="checkbox" name="box" id="Explanation" value="<?php echo $item['explanation'] ?>"
onchange="generateHTMLCode(this.form);"
<?php echo !$item['explanation'] ? 'disabled="disabled" class="disabled"' : '' ?> />
<label for="Explanation"><?php _e('説明', 'wp_AT') ?></label></dt>
<dd><?php echo $item['explanation'] ?></dd>
<dt><input type="checkbox" name="box" id="GoodsCode" value="<?php echo $item['goodscode'] ?>"
onchange="generateHTMLCode(this.form);"
<?php echo !$item['goodscode'] ? 'disabled="disabled" class="disabled"' : '' ?> />
<label for="GoodsCode"><?php _e('型番', 'wp_AT') ?></label></dt>
<dd><?php echo $item['goodscode'] ?></dd>
<dt><input type="checkbox" name="box" id="JANCode" value="<?php echo $item['jancode'] ?>"
onchange="generateHTMLCode(this.form);"
<?php echo !$item['jancode'] ? 'disabled="disabled" class="disabled"' : '' ?> />
<label for="JANCode"><?php _e('JANコード', 'wp_AT') ?></label></dt>
<dd><?php echo $item['jancode'] ?></dd>
<dt><input type="checkbox" name="box" id="ShopName" value="<?php echo $item['shopname'] ?>"
onchange="generateHTMLCode(this.form);"
<?php echo !$item['shopname'] ? 'disabled="disabled" class="disabled"' : '' ?> />
<label for="ShopName"><?php _e('ショップ名', 'wp_AT') ?></label></dt>
<dd><?php echo $item['shopname'] ?></dd>
<dt><?php _e('成果報酬額（成果報酬率）', 'wp_AT') ?></dt>
<dd>&yen;<?php echo $item['reward'] ?> (<?php echo $item['rewardrate'] ?>%)</dd>
</dl>
<div>
<input type="button" name="insert" value="<?php _e('チェック項目をエントリーに挿入', 'wp_AT') ?> &raquo;"
onclick="insertAtCursor(window.opener.document.post.content, this.form.htmlcode.value)" />
</div>
<div>
<textarea class="htmlcode" id="htmlcode_<?php echo $resID ?>" name="htmlcode"></textarea>
</div>
</form>
</div>
</td>
</tr>
<?php
		}
?>
</table>
<script type="text/javascript">
<?php

?>
<!--
function insertAtCursor(myField, myValue) {
	// IE support
	if (document.selection) {
		// only insert text for IE (not at cursor)
		myField.value += myValue;
	}
	// Mozilla/Netscape support
	else if (myField.selectionStart || myField.selectionStart == '0') {
		var startPos = myField.selectionStart;
		var endPos = myField.selectionEnd;
		myField.value = myField.value.substring(0, startPos)
			+ myValue
			+ myField.value.substring(endPos, myField.value.length);
	} else {
		myField.value += myValue;
	}
}
function generateHTMLCode(formObj) {
	var box = formObj.box;
	var htmlCode = formObj.htmlcode;
	var html = "";
	var checkedElse = false;
	if (box.length) {
		for (var i = 0; i < box.length; i++) {
			if (box[i].checked) {
				if (checkedElse) {
					html += "\n\n";
				} else {
					checkedElse = true;
				}
				html += box[i].value;
			}
		}
	} else {
		if (box.checked) {
			html = box.value;
		}
	}
	htmlCode.value = html;
	htmlCode.select();
}
// -->
</script>

<?php
		$wac->getJS($resIDs);
		$was->createPager($result);
	}
?>

<?php
}
?>
</div>
</body>
</html>
