<?php
/**
 * wp-AT-function.php:
 * wp-AT library file
 * 
 * @author Sa.Ga
 * @version 1.0 Beta 2
 */

/*  Copyright 2006 Sa.Ga

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define('ATWS_URL', 'http://xml.accesstrade.net/at/ws.html');
define('IMAGE_MAXSIZE', 100);
define('GOODS_LIST_MAX_SIZE', 10);

/**
 * class for search goods
 */
class WP_AT_Search {

	var $data, $result;

	/**
	 * constructor
	 */
	function WP_AT_Search() {
		global $wsVer, $wsID, $wsType;
		// load i18n translations
		load_plugin_textdomain('wp_AT', 'wp-content/plugins/wp-AT');
		
		$wsVer = get_option('wpat_ws_ver');
		//$wsType = get_option('wpat_ws_type');
		$wsType = 'searchgoods';
		$wsID = get_option('wpat_ws_id');
		
		$charset = get_settings('blog_charset');
		
		if (isset($_REQUEST['search']) || isset($_REQUEST['doAction'])
		|| isset($_REQUEST['editTemplate'])) {
		    require_once 'wp-AT-parser.php';

		    $resource = ATWS_URL
		    	. '?ws_ver='. $wsVer. '&ws_id='. $wsID. '&ws_type='. $wsType;
		    $resource .= '&row='. $_REQUEST['row'];
		    $resource .= '&page='. $_REQUEST['goodsPage'];
		    $resource .= '&category1='. $_REQUEST['category'];
		    $resource .= '&search='
		    	. urlencode(mb_convert_encoding($_REQUEST['keyword'], 'UTF-8', $charset));

			$this->result = readXML($resource);

		    $this->data = $_REQUEST;
		} else {
		    $this->data['row'] = '10';
		    $this->data['category'] = '';
		}
	}

	/**
	 * get category list and create a select list.
	 * @param string $selected selected option
	 */
	function parseCategory($selected = '') {
		$categoryOptions = '';
	    $categories = get_option('wpat_category_list');
	    $lines = split("\n", $categories);
	    foreach ($lines as $line) {
	    	$pair = split(",", $line);
	    	$categoryOptions .= '<option value="'. $pair[0]. '" ';
	    	$categoryOptions .= ($pair[0] == $selected ? ' selected="selected"' : '');
	    	$categoryOptions .= '>'. $pair[1]. '</option>';
	    }
	    if ($categories) {
	        $categories = '<select name="category">'. $categoryOptions. '</select>';
	    } else {
	        $categories = __('カテゴリリストの読み込みに失敗しました。', 'wp_AT');
	    }
	    echo $categories;
	}

	/**
	 * display page informations...
	 * @param string $result search result
	 * @param string $optionalParam option parameters
	 */
	function createPager($result, $optionalParam = '') {
		global $wsVer, $wsID, $wsType;
	
	    $showpages = 15;
	    $showpagerows = 7;
	
	    $query  = $_SERVER['PHP_SELF']. '?';
	    if ($optionalParam != '') {
	    	$query .= $optionalParam. '&';
	    }
//	    $query .= 'ws_ver='. $wsVer. '&ws_id='. $wsID. '&ws_type='. $wsType;
	    $query .= 'search=1';
	    $query .= '&row='.$result['request']['row'];
	    $query .= '&category='.$result['request']['category1'];
	    $query .= '&keyword='.urlencode($result['request']['search']);
	
	    //出力部分
	    $hyojiKensuLabel = __('表示件数：', 'wp_AT');
	    $kensakuKensuLabel = __('検索件数：', 'wp_AT');
	    $kenLabel = __('件：', 'wp_AT');
	    $pageLabel = __('ページ：', 'wp_AT');
	    $pager .= <<<___TAG___
<div class="result">
    {$hyojiKensuLabel}{$result['request']['row']}{$kenLabel}<br />
    {$kensakuKensuLabel}{$result['totalcount']}{$kenLabel}&nbsp;&nbsp;&nbsp;
    {$result['currentpage']}&nbsp;/&nbsp;{$result['totalpage']}{$pageLabel}
</div>
<div class="pager">
___TAG___;
	
	    //最小ページ数とか
	    $minpage = intval($result['currentpage']) - $showpagerows;
	    $maxpage = intval($result['currentpage']) + $showpagerows;
	
	    if ($minpage < 1) {
	        $minpage = 1;
	        $maxpage = $showpages;
	    }
	
	    if ($maxpage > intval($result['totalpage'])) {
	        $minpage = intval($result['totalpage']) - $showpages + 1;
	        $maxpage = intval($result['totalpage']);
	    }
	
	    if ($showpages > intval($result['totalpage'])) {
	        $minpage = 1;
	        $maxpage = intval($result['totalpage']);
	    }
	
	    // << < と > >>
	    $previous_tag  = $minpage == 1  ?
	                         '&nbsp;&lt;&lt;&nbsp;' :
	                         "&nbsp;<a href=\"$query&goodsPage=1\">&lt;&lt;</a>&nbsp;";
	
	    $previous_tag .= intval($result['currentpage']) == 1 ?
	                         "&nbsp;&lt;&nbsp;" :
	                         "&nbsp;<a href=\"$query&goodsPage=".(intval($result['currentpage']) - 1)."\">&lt;</a>&nbsp;";
	
	    $next_tag  = intval($result['currentpage']) == intval($result['totalpage']) ?
	                    "&nbsp;&gt;&nbsp;" :
	                    "&nbsp;<a href=\"$query&goodsPage=".(intval($result['currentpage']) + 1)."\">&gt;</a>&nbsp;";
	
	    $next_tag .= $maxpage == intval($result['totalpage']) ?
	                    "&nbsp;&gt;&gt;&nbsp;" :
	                    "&nbsp;<a href=\"$query&goodsPage=".intval($result['totalpage'])."\">&gt;&gt;</a>&nbsp;";
	
	    $pager .= $previous_tag;
	
	    //表示ページ数分繰り返し処理
	   for ($i = $minpage; $i <= $maxpage; $i++) {
	        $page_link = "&nbsp;<a href=\"$query&goodsPage=$i\">";
	        if ($i == intval($result['currentpage'])) {
	            $page_link .= "<span class=\"currentpage\">$i</span>";
	        } else {
	            $page_link .= $i;
	        }
	        $page_link .= '</a>&nbsp;';
	        $pager .= $page_link;
	    }
	    $pager .= "$next_tag</div>";
	
	    echo $pager;
	}

	/**
	 * resize image
	 * @param int $width image width
	 * @param int $height image height
	 * @return array resized width and height
	 */
	function calcImageSize($width, $height) {
	    $array = array();
	    if ($width > IMAGE_MAXSIZE || $height > IMAGE_MAXSIZE) {
	        if ($width >= $height) {
	            $array['height'] = intval($height * IMAGE_MAXSIZE / $width);
	            $array['width']  = IMAGE_MAXSIZE;
	        }
	        else {
	            $array['width']  = intval($width * IMAGE_MAXSIZE / $height);
	            $array['height'] = IMAGE_MAXSIZE;
	        }
	    }
	    return $array;
	}
}

/**
 * class for goods list
 */
class WP_AT_GoodsList {
	/** goods list */
	var $wpAtGoodsList;
	/** template of wp-AT goods list */
	var $wpAtGoodsTemplate;
	/**
	 * constructor
	 */
	function WP_AT_GoodsList() {
		global $wpAtGoodsList, $wpAtGoodsTemplate;
		// load i18n translations
		load_plugin_textdomain('wp_AT', 'wp-content/plugins/wp-AT');
		$wpAtGoodsList = get_option('wpat_goods_list');
		if (!$wpAtGoodsList) {
			$wpAtGoodsList = array();
		}
		$wpAtGoodsTemplate = get_option('wpat_goods_template');
	}
	/**
	 * add an item to goodslist
	 * @param array $data item data
	 * @return string message (if exists...)
	 */
	function add($data) {
		global $wpAtGoodsList;

		if (count($wpAtGoodsList) >= GOODS_LIST_MAX_SIZE) {
			$msg = __('商品リストに、既に', 'wp_AT')
			. GOODS_LIST_MAX_SIZE
			. __('件登録されています。', 'wp_AT');
			return $msg;
		}

		$line = array();

		$line['imageurl'] = $data['imageurl']. "\t";
		$line['maker'] = $data['maker']. "\t";
		$line['linkcode'] = $data['linkcode']. "\t";
		$line['goodsname'] = $data['goodsname']. "\t";
		$line['price'] = $data['price']. "\t";
		$line['explanation'] = $data['explanation']. "\t";
		$line['goodscode'] = $data['goodscode']. "\t";
		$line['jancode'] = $data['jancode']. "\t";
		$line['shopname'] = $data['shopname']. "\t";
		$line['userComment'] = $data['userComment']. "\n";
		$line['width'] = $data['width']. "\n";
		$line['height'] = $data['height']. "\n";

		$wpAtGoodsList[] = $line;

		update_option('wpat_goods_list', $wpAtGoodsList);
		return '';
	}
	/**
	 * edit goods list
	 * @param array $data item data
	 * @return boolean if list is updated, return true.
	 */
	function editList($data) {
		global $wpAtGoodsList;
		$goodsAction = intval($data['goodsAction']);
		$goodsListNumber = intval($data['goodsList']);
		if ($goodsAction < 0) {
			array_splice($wpAtGoodsList, $goodsListNumber, 1);
		} else {
			$movingLine = $wpAtGoodsList[$goodsListNumber];
			if (($goodsAction == $goodsListNumber)
			|| ($goodsAction == $goodsListNumber + 1)) {
				// Not need to move
				return false;
			}
			if ($goodsAction > $goodsListNumber + 1) {
				array_splice($wpAtGoodsList, $goodsAction, 0, array($movingLine));
			}
			array_splice($wpAtGoodsList, $goodsListNumber, 1);
			if ($goodsAction < $goodsListNumber) {
				array_splice($wpAtGoodsList, $goodsAction, 0, array($movingLine));
			}
			
		}
		update_option('wpat_goods_list', $wpAtGoodsList);
		return true;
	}
	/**
	 * edit template
	 * @param array $data template strings
	 * @return boolean result of "update_option()" function
	 */
	function editTemplate($data) {
		global $wpAtGoodsTemplate;
		$wpAtGoodsTemplate = array();
		$wpAtGoodsTemplate[] = $data['beforeTemplate'];
		$wpAtGoodsTemplate[] = $data['goodsTemplate'];
		$wpAtGoodsTemplate[] = $data['afterTemplate'];
		return update_option('wpat_goods_template', $wpAtGoodsTemplate);
	}
	/**
	 * reset template
	 */
	function resetTemplate() {
		global $wpAtGoodsTemplate;
		$wpAtGoodsTemplate = array();
		$wpAtGoodsTemplate[] = '<ul>';
		$wpAtGoodsTemplate[] = '<li><a href="%linkcode">%goodsname</a><br /><image src="%imageurl" alt="[image]" width="%customWidth" height="%customHeight" /></li>';
		$wpAtGoodsTemplate[] = '</ul>';
		update_option('wpat_goods_template', $wpAtGoodsTemplate);
	}
}

/**
 * class of wp-AT contents
 */
class WP_AT_Contents {
	/**
	 * get style sheet for wp-AT
	 * @return string css
	 */
	function getCSS() {
?>
<style type="text/css">
<!--
th, td {
	vertical-align: top;
}
.result, .pager {
	text-align: center;
}
.htmlcode {
	width:95%;
	height:150px;
	margin:5px;
}
#beforeTemplate {
	width:95%;
	height:70px;
	margin:5px;
}
#goodsTemplate {
	width:95%;
	height:150px;
	margin:5px;
}
#afterTemplate {
	width:95%;
	height:70px;
	margin:5px;
}

#wpATSubMenu li {
	display: inline; list-style-position: outside; text-align: center;
	margin: 0 1px 0 1px;
	line-height: 170%;
}
#wpATSubMenu {
	border-bottom: medium none;
	margin: 0 0 -16px;
	padding: 0pt 3% 0pt 3%; 
}
#wpATSubMenu .current {
	font-weight: bold;
	background-color: #fff;
	color: #000;
	padding: 5px;
	border-bottom: 0px;
}
#wpATSubMenu a {
	background-color: #eee;
	border: 1px solid #ccc;
	border-bottom: 1px solid #ccc;
	color: #69c;
	padding: 4px;
	font-size: 12px; 
}
#wpATSubMenu a:hover {
	background: #69c;
	color: #fff;
}
#wpATGoodsManager .wrap {
}
#wpATGoodsListSetting {
	width: 70%;
}
#wpATGoodsListSetting * {
	clear: none;
}
#wpATGoodsList {
	float:right;
	width: 28%;
}
-->
</style>
<?php
	}
	/**
	 * get JavaScript for wp-AT
	 * @param array $resIDs result ID array
	 * @return string JavaScript code
	 */
	function getJS($resIDs) {
?>
<script type="text/javascript">
<!--
function changeView(divID, toShow) {

	var virtualToggle = '&nbsp;[<a href="javascript:changeView(\'' + divID + '\', !viewSettings[\'' + divID + '\'])">';

	viewSettings[divID] = toShow;
	if (toShow) {
		virtualToggle += '-';
		document.getElementById(divID).style.display = 'block';
	} else {
		virtualToggle += '+';
		document.getElementById(divID).style.display = 'none';
	}
	virtualToggle += '</a>]';
	document.getElementById("virtualToggle_" + divID).innerHTML = virtualToggle;
}

// Initializing
<?php
		for ($i = 0; $i < count($resIDs); $i++) {
?>
changeView("id_<?php echo $resIDs[$i] ?>_setting", false);
<?php
		}
?>
// -->
</script>
<?php
	}
}
?>
