package hiro.yoshioka.sql.resource.notes;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.notes.ddl.Form;
import hiro.yoshioka.sql.notes.ddl.NotesDXLParser2;
import hiro.yoshioka.sql.resource.DBDictionaryRoot;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;

import java.io.Serializable;

public class NotesDBTable extends DBTable implements Serializable {
	private static final long serialVersionUID = 2609783121262289704L;
	private Form form;

	public NotesDBTable(IDBSchema schema) {
		super(schema);
	}

	public NotesDBTable(DBDictionaryRoot droot) {
		super(droot);
	}

	public void setForm(Form form) {
		this.form = form;
	}

	public Form getForm() {
		return form;
	}

	public String toString() {
		if (hasAlias()) {
			StringBuilder buf = new StringBuilder();
			buf.append(getName());
			buf.append(" [");
			buf.append(getAlias());
			buf.append("]");
			return buf.toString();
		} else {
			return getName();
		}
	}

	public boolean canMakeHtmlString() {
		return getForm() != null;
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row) {
		return NotesDXLParser2.toHtmlString(rdh, row,
				((NotesDBSchema) getParent()).getDatabase(), form, null);
	}

	@Override
	public void setValueFromOld(IDBResource tbl) {
		System.out.println("old form=" + form);
		this.form = ((NotesDBTable) tbl).form;
	}

}