package hiro.yoshioka.sql.resource.evernote;

public enum EvernoteTableType {
	/**
	 * NoteBook.
	 */
	NoteBook("NoteBook"),
	/**
	 * SharedNoteBook.
	 */
	SharedNoteBook("SharedNoteBook"),
	/**
	 * LinkedNoteBook.
	 */
	LinkedNoteBook("LinkedNoteBook"),
	/**
	 * Tags.
	 */
	Tags("Tags"), ;

	private String tableName;

	private EvernoteTableType(String tableName) {
		this.tableName = tableName;
	}

	public String getTableName() {
		return tableName;
	}

	public boolean isNoteBook() {
		return NoteBook.equals(this);
	}

	public boolean isTags() {
		return Tags.equals(this);
	}

	public boolean isLinkedNotebook() {
		return LinkedNoteBook.equals(this);
	}

	public boolean isSharedNoteBook() {
		return SharedNoteBook.equals(this);
	}

	// public static List<EvernoteTableType> getTableTypeListOf(
	// TwitterSchemaType schemaType) {
	// return SCHEMA_MAPPINGS.get(schemaType);
	// }
}
