package hiro.yoshioka.sql.resource;

import hiro.yoshioka.util.StringUtil;

import java.util.Properties;

public class DBSequence extends DBResource implements IDBSequence {
	private static final long serialVersionUID = 99992544846456L;
	protected String fText;
	private int min;
	private int max;
	private int increment;
	private int start;
	private int cashe;
	private boolean cycle;

	@Override
	public void setProperties(Properties p) {
		super.setProperties(p);
		try {
			increment = Integer.parseInt(p.getProperty("INCREMENT"));
		} catch (Exception e) {
		}
		try {
			start = Integer.parseInt(p.getProperty("START"));
		} catch (Exception e) {
		}
		try {
			cashe = Integer.parseInt(p.getProperty("CACHE"));
		} catch (Exception e) {
		}
		try {
			min = Integer.parseInt(p.getProperty("MIN"));
		} catch (Exception e) {
		}
		try {
			max = Integer.parseInt(p.getProperty("MAX"));
		} catch (Exception e) {
		}
		try {
			String cyc = p.getProperty("CYCLE");
			if ("true".equalsIgnoreCase(cyc) || "t".equalsIgnoreCase(cyc) || "y".equalsIgnoreCase(cyc)
					|| "yes".equalsIgnoreCase(cyc)) {
				cycle = true;

			}
		} catch (Exception e) {
		}
	}

	public int getMin() {
		return min;
	}

	public void setMin(int min) {
		this.min = min;
	}

	public int getMax() {
		return max;
	}

	public void setMax(int max) {
		this.max = max;
	}

	public int getIncrement() {
		return increment;
	}

	public void setIncrement(int increment) {
		this.increment = increment;
	}

	public int getStart() {
		return start;
	}

	public void setStart(int start) {
		this.start = start;
	}

	public int getCashe() {
		return cashe;
	}

	public void setCashe(int cashe) {
		this.cashe = cashe;
	}

	public DBSequence(IDBSchema schema) {
		super(schema);
	}

	public void setComment(String remarks) {
		this.comment = remarks;
	}

	public boolean hasText() {
		if (fText == null || fText.length() == 0) {
			return false;
		}
		return true;
	}

	public String getText() {
		return fText;
	}

	public void setText(String text) {
		fText = StringUtil.nvl(text).replaceAll("(SEQUENCE)\\s+\"(\\w+)\"[.]\"(\\w+)\"", "$1 $2.$3");
	}

	public boolean contain(String pattern) {
		return containKeyInNameOrComment(pattern.toUpperCase());
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(getName());
		if (getComment().length() > 0) {
			buf.append(" 【" + getComment() + "】");
		}
		return buf.toString();
	}

	public boolean isCycle() {
		return cycle;
	}

	public void setCycle(boolean cycle) {
		this.cycle = cycle;
	}
}