package hiro.yoshioka.sql.resource;

import hiro.yoshioka.util.StringUtil;

import java.util.Set;
import java.util.TreeSet;

public enum DBResourceType {
	DATABASE(5), SCHEMA(10), LOGIN_ROLE(12), TABLE(20), VIEW(25), PROCEDURE(30), FUNCTION(
			35), SYNONYM(40), SEQUENCE(50), TRIGGER(60), COLUMN(100), UNDEFINED(
			9999);

	private int code;

	public static Set<DBResourceType> COMPARE_SUPPORT_SET = new TreeSet<DBResourceType>();
	static {
		COMPARE_SUPPORT_SET.add(TABLE);
		COMPARE_SUPPORT_SET.add(VIEW);
		COMPARE_SUPPORT_SET.add(FUNCTION);
		// COMPARE_SUPPORT_SET.add(SYNONYM);
		COMPARE_SUPPORT_SET.add(SEQUENCE);
		// COMPARE_SUPPORT_SET.add(TRIGGER);
	}

	public static DBResourceType parse(int code) {
		for (DBResourceType resource : values()) {
			if (resource.getCode() == code) {
				return resource;
			}
		}
		return UNDEFINED;
	}

	public static DBResourceType parse(String code_or_name) {
		int ci = StringUtil.parseIntNoneException(code_or_name, -1);
		for (DBResourceType resource : values()) {
			if (resource.name().equalsIgnoreCase(code_or_name)) {
				return resource;
			}
			if (ci >= 0 && resource.getCode() == ci) {
				return resource;
			}
		}
		return UNDEFINED;
	}

	private DBResourceType(int code) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}
}
