package hiro.yoshioka.sql.params;

import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.HSQL;
import hiro.yoshioka.util.StringUtil;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionSettingBean implements Serializable {
	private static final long serialVersionUID = 5792695663300493365L;
	private Set<String> jdbcDriverFilePathSet = new LinkedHashSet<String>();
	private List<ConnectionProperties> connectionList = new ArrayList<ConnectionProperties>();
	private Map<String, SSHProperties> sshMap = new LinkedHashMap<String, SSHProperties>();
	private static final String LOCAL_HSQL_SERVER_DISP = "LocalHsqlServer";
	protected transient Log log = LogFactory.getLog(getClass());

	public ConnectionSettingBean() {
	}

	public ConnectionProperties getLocalHsqlServerConnection() {
		ConnectionProperties hsqlConnection = getConnectionPropertiesByDisplay(LOCAL_HSQL_SERVER_DISP);
		if (hsqlConnection == null) {
			createLocalHsqlServerConnetionDefinition();
			return getConnectionPropertiesByDisplay(LOCAL_HSQL_SERVER_DISP);
		}
		DBUserPass du = hsqlConnection.getAuthenticate();
		if (du == null || StringUtil.isEmpty(du.getUser())) {
			removeLocalHsqlServerConnectionDefinition();
			createLocalHsqlServerConnetionDefinition();
			return getConnectionPropertiesByDisplay(LOCAL_HSQL_SERVER_DISP);
		}
		return hsqlConnection;
	}

	public void createLocalHsqlServerConnetionDefinition() {
		ConnectionProperties hsql = new ConnectionProperties();
		hsql.setURLString(HSQL.getSuggestURL());
		hsql.setAuthenticate(null, "sa", null);
		hsql.setHost("127.0.0.1:9003");
		hsql.setDisplayString(LOCAL_HSQL_SERVER_DISP);
		hsql.setSerializableDBRoot(true);
		hsql.setDriverName(DatabaseType.HSQL.getDriverName());
		hsql.setCaptureResourceAfterTheConnectProcess(true);
		System.err.println("createLocalHsqlServerConnetionDefinition " + hsql);
		if (this.connectionList == null) {
			this.connectionList = new ArrayList<ConnectionProperties>();
		}
		connectionList.add(hsql);
	}

	private void removeLocalHsqlServerConnectionDefinition() {
		if (this.connectionList == null) {
			this.connectionList = new ArrayList<ConnectionProperties>();
			return;
		}
		Long removeKey = null;
		for (int i = 0; i < connectionList.size(); i++) {
			ConnectionProperties p = connectionList.get(i);
			if (p.getDisplayString().equals(LOCAL_HSQL_SERVER_DISP)) {
				connectionList.remove(i);
				break;
			}
		}
	}

	public ConnectionProperties getConnectionPropertiesByDisplay(
			String displayString) {
		if (connectionList == null) {
			return null;
		}
		for (ConnectionProperties p : connectionList) {
			if (p.getDisplayString().equals(displayString)) {
				return p;
			}
		}
		return null;
	}

	public List<ConnectionProperties> getConnectionList() {
		return connectionList;
	}

	public void setConnectionMap(List<ConnectionProperties> connectionList) {
		this.connectionList = connectionList;
	}

	public void addConnectionProperties(ConnectionProperties properties) {
		connectionList.add(properties);
	}

	public void addSSHProperties(SSHProperties ssh_properties) {
		this.sshMap.put(ssh_properties.getDefinition_name(), ssh_properties);
	}

	public SSHProperties getSSHProperties(String ssh_define_name) {
		return this.sshMap.get(ssh_define_name);
	}

	public SSHProperties getSSHProperties(ConnectionProperties properties) {
		return this.getSSHProperties(properties.getSSHTunnelingDefine());
	}

	public void initConnectionStatus() {
		for (ConnectionProperties p : getConnectedConnectionSet()) {
			p.setConnected(false);
		}
	}

	public boolean changeConnectionProperties(
			Collection<ConnectionProperties> newProperties) throws IOException {
		if (this.connectionList == null) {
			this.connectionList = new ArrayList<ConnectionProperties>();
		}
		boolean ret = false;
		connectionList.clear();

		for (ConnectionProperties target : newProperties) {
			addConnectionProperties(target);
		}
		return ret;
	}

	public List<ConnectionProperties> getConnectedConnectionSet() {
		if (this.connectionList == null) {
			this.connectionList = new ArrayList<ConnectionProperties>();
		}
		if (connectionList.size() == 0) {
			return Collections.EMPTY_LIST;
		}
		List<ConnectionProperties> ret = new ArrayList<ConnectionProperties>();
		for (ConnectionProperties p : connectionList) {
			if (p.isConnected()) {
				ret.add(p);
			}
		}
		return ret;
	}

	public List<ConnectionProperties> getDisConnectedConnectionSet() {
		if (this.connectionList == null) {
			this.connectionList = new ArrayList<ConnectionProperties>();
		}
		if (connectionList.size() == 0) {
			return Collections.EMPTY_LIST;
		}
		List<ConnectionProperties> ret = new ArrayList<ConnectionProperties>();
		for (ConnectionProperties p : connectionList) {
			if (!p.isConnected()) {
				ret.add(p);
			}
		}
		return ret;
	}

	public String[] getDisplayStrings() {
		if (this.connectionList == null) {
			this.connectionList = new ArrayList<ConnectionProperties>();
		}
		List<String> retList = new ArrayList<String>();
		for (ConnectionProperties p : getConnectionList()) {
			retList.add(p.getDisplayString());
		}
		return retList.toArray(new String[retList.size()]);
	}

	public Set<String> getJdbcDriverFilePathSet() {
		return jdbcDriverFilePathSet;
	}

	public void setJdbcDriverFilePathSet(Set<String> jdbcDriverFilePathSet) {
		this.jdbcDriverFilePathSet = jdbcDriverFilePathSet;
	}

	public void setJdbcDriverFilePathSet(String[] listFiles) {
		this.jdbcDriverFilePathSet.clear();
		if (listFiles == null) {
			return;
		}
		for (String file : listFiles) {
			this.jdbcDriverFilePathSet.add(file);
		}
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		if (connectionList == null) {
			buf.append(String.format(
					"JAR_FILE[%s] ConnectionProperties is nothing...",
					jdbcDriverFilePathSet));
		} else {
			buf.append(String.format(
					"JAR_FILE[%s] ConnectionProperties size [%d]%n",
					jdbcDriverFilePathSet, connectionList.size()));
			for (ConnectionProperties con : connectionList) {
				buf.append(String.format("  %s%n", con));
			}
		}
		return buf.toString();
	}

	public List<ConnectionProperties> getCloneConnectionList() {
		if (this.connectionList == null) {
			this.connectionList = new ArrayList<ConnectionProperties>();
		}
		log.debug("conMap=" + connectionList);
		List<ConnectionProperties> ret = new ArrayList<ConnectionProperties>();
		for (ConnectionProperties set : connectionList) {
			ConnectionProperties clone = (ConnectionProperties) set.clone();
			log.debug("add:" + clone + "/ " + clone.getCreated());
			ret.add(clone);
		}
		log.debug("ret size=" + ret.size());
		return ret;
	}

	public Collection<SSHProperties> getCloneSSHSet()
			throws CloneNotSupportedException {
		log.debug("conMap=" + connectionList);
		Set<SSHProperties> ret = new LinkedHashSet<SSHProperties>();
		for (SSHProperties set : sshMap.values()) {
			SSHProperties clone = (SSHProperties) set.clone();
			ret.add(clone);
		}
		log.debug("ret size=" + ret.size());
		return ret;
	}

	// --------------------------------------------------------------
	// DeSerialize
	// --------------------------------------------------------------
	private void readObject(ObjectInputStream in) throws IOException,
			ClassNotFoundException {
		log = LogFactory.getLog(getClass());
		in.defaultReadObject();
	}

	public boolean isDefinedDisplayOf(String displayName) {
		return getConnectionPropertiesByDisplay(displayName) != null;
	}

	public boolean isDefinedDisplayOf(String displayName,
			ConnectionProperties fConnectionProperties) {
		ConnectionProperties p = getConnectionPropertiesByDisplay(displayName);
		if (p == null || fConnectionProperties == null) {
			return false;
		}
		return p.getCreated() != fConnectionProperties.getCreated();
	}

	public void chageSSHProperties(Collection<SSHProperties> newSSHProperties) {
		this.sshMap.clear();
		for (SSHProperties p : newSSHProperties) {
			addSSHProperties(p);
		}
	}

}
