package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfRichTextStyle extends AbsWolfDominoReflection {
	private boolean bold;
	private boolean italic;
	private boolean underline;
	private boolean strikeThrough;
	private int fontSize;
	private int font;
	private int color;
	private String colorName;

	public static final int YES = 0x1;
	/* FONT-COLOR */
	public static final int COLOR_BLACK = 0x0;
	public static final int COLOR_BLUE = 0x4;
	public static final int COLOR_CYAN = 0x7;
	public static final int COLOR_DARK_BLUE = 0xa;
	public static final int COLOR_DARK_CYAN = 0xd;
	public static final int COLOR_DARK_GREEN = 0x9;
	public static final int COLOR_DARK_MAGENTA = 0xb;
	public static final int COLOR_DARK_RED = 0x8;
	public static final int COLOR_DARK_YELLOW = 0xc;
	public static final int COLOR_GRAY = 0xe;
	public static final int COLOR_GREEN = 0x3;
	public static final int COLOR_LIGHT_GRAY = 0xf;
	public static final int COLOR_MAGENTA = 0x5;
	public static final int COLOR_RED = 0x2;
	public static final int COLOR_WHITE = 0x1;
	public static final int COLOR_YELLOW = 0x6;
	/* FONT-NAME */
	public static final int FONT_COURIER = 0x4;
	public static final int FONT_HELV = 0x1;
	public static final int FONT_ROMAN = 0x0;

	public WolfRichTextStyle(ClassManager classManager, Object instance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException, IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		super(classManager, instance);

		Method method = targetInstance.getClass().getMethod("getBold");
		this.bold = (YES == (Integer) method.invoke(targetInstance));
		method = targetInstance.getClass().getMethod("getItalic");
		this.italic = (YES == (Integer) method.invoke(targetInstance));
		method = targetInstance.getClass().getMethod("getUnderline");
		this.underline = (YES == (Integer) method.invoke(targetInstance));
		method = targetInstance.getClass().getMethod("getStrikeThrough");
		this.strikeThrough = (YES == (Integer) method.invoke(targetInstance));
		method = targetInstance.getClass().getMethod("getFontSize");
		this.fontSize = (Integer) method.invoke(targetInstance);

		method = targetInstance.getClass().getMethod("getFont");
		this.font = (Integer) method.invoke(targetInstance);
		method = targetInstance.getClass().getMethod("getColor");
		this.color = (Integer) method.invoke(targetInstance);
		if (COLOR_BLACK == color) {
			this.colorName = "black";
		} else if (COLOR_BLUE == color) {
			this.colorName = "blue";
		} else if (COLOR_CYAN == color) {
			this.colorName = "cyan";
		} else if (COLOR_DARK_BLUE == color) {
			this.colorName = "#00008B";
		} else if (COLOR_DARK_CYAN == color) {
			this.colorName = "#00FFFF";
		} else if (COLOR_DARK_GREEN == color) {
			this.colorName = "#006400";
		} else if (COLOR_DARK_MAGENTA == color) {
			this.colorName = "#8B008B";
		} else if (COLOR_DARK_RED == color) {
			this.colorName = "#8B0000";
		} else if (COLOR_DARK_YELLOW == color) {
			this.colorName = "#B49436";
		} else if (COLOR_GRAY == color) {
			this.colorName = "gray";
		} else if (COLOR_GREEN == color) {
			this.colorName = "green";
		} else if (COLOR_LIGHT_GRAY == color) {
			this.colorName = "#D3D3D3";
		} else if (COLOR_MAGENTA == color) {
			this.colorName = "magenta";
		} else if (COLOR_RED == color) {
			this.colorName = "red";
		} else if (COLOR_WHITE == color) {
			this.colorName = "white";
		} else if (COLOR_YELLOW == color) {
			this.colorName = "yellow";
		}
	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.RichTextStyle";
	}

	public String getRichText2HtmlString(String textParagraph) {
		StringBuilder buf = new StringBuilder();
		if (bold) {
			buf.append("<b>");
		}
		if (italic) {
			buf.append("<i>");
		}
		if (underline) {
			buf.append("<u>");
		}
		if (strikeThrough) {
			buf.append("<strike>");
		}

		buf.append(String.format(
				"<span style='font-size:%dpt; color=%s'>%s</span>", fontSize,
				colorName, textParagraph));

		if (strikeThrough) {
			buf.append("</strike>");
		}
		if (underline) {
			buf.append("</u>");
		}
		if (italic) {
			buf.append("</i>");
		}
		if (bold) {
			buf.append("</b>");
		}

		return buf.toString();
	}
}