package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfNoteCollection extends AbsWolfDominoReflection {

	Method add_form;
	Method add_string;
	Method selectAllDesignElements;
	Method setSelectHelpAbout;
	Method buildCollection;

	public WolfNoteCollection(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);
		Class form = classManager.getClassForName("lotus.domino.Form");
		add_form = targetInstance.getClass().getMethod("add", form);
		add_string = targetInstance.getClass().getMethod("add", String.class);
		selectAllDesignElements = targetInstance.getClass().getMethod(
				"selectAllDesignElements", boolean.class);
		setSelectHelpAbout = targetInstance.getClass().getMethod(
				"setSelectHelpAbout", boolean.class);
		buildCollection = targetInstance.getClass()
				.getMethod("buildCollection");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.NoteCollection";
	}

	public void add_string(String str) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		add_string.invoke(targetInstance, str);
	}

	public void add_form(Object form) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		add_form.invoke(targetInstance, form);
	}

	public void selectAllDesignElements(boolean b)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		selectAllDesignElements.invoke(targetInstance, b);
	}

	public void setSelectHelpAbout(boolean b) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		setSelectHelpAbout.invoke(targetInstance, b);
	}

	public void buildCollection() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		buildCollection.invoke(targetInstance);
	}
}
