package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Vector;

public class WolfACL extends AbsWolfDominoReflection {
	Method isUniformAccess;
	Method getFirstEntry;
	Method getNextEntry;
	Method getRoles;
	WolfACLEntry wolf_acl_entry;

	public WolfACL(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);
		// lotus.domino.ACLEntry
		isUniformAccess = targetInstance.getClass()
				.getMethod("isUniformAccess"); //$NON-NLS-1$
		getRoles = targetInstance.getClass().getMethod("getRoles"); //$NON-NLS-1$
		getFirstEntry = targetInstance.getClass().getMethod("getFirstEntry"); //$NON-NLS-1$

		for (Method method : targetInstance.getClass().getDeclaredMethods()) {
			if (method.getName().equals("getNextEntry") //$NON-NLS-1$
					&& method.toString().contains("ACLEntry")) { //$NON-NLS-1$
				getNextEntry = method;
			}
		}
	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.ACL"; //$NON-NLS-1$
	}

	public WolfACLEntry getFirstEntry() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object o = getFirstEntry.invoke(targetInstance);
		if (o == null) {
			return null;
		}
		wolf_acl_entry = new WolfACLEntry(classManager, o);
		return wolf_acl_entry;
	}

	public WolfACLEntry getNextEntry(WolfACLEntry aclEntry)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		Object o = getNextEntry.invoke(targetInstance,
				aclEntry.getTargetInstance());
		if (o == null) {
			return null;
		}
		wolf_acl_entry.setTargetInstance(o);
		return wolf_acl_entry;
	}

	public Vector<String> getRoles() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Vector<String>) getRoles.invoke(targetInstance);
	}

	public boolean isUniformAccess() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isUniformAccess.invoke(targetInstance);
	}

	public String toHtmlString() {
		StringBuilder buf = new StringBuilder();
		try {
			Vector<String> roles = getRoles();
			buf.append(String.format("<html>%n")); //$NON-NLS-1$
			buf.append(String.format("<table cellspacing=1 cellpadding=5 border=0 bgcolor=#A0E0E0 >%n")); //$NON-NLS-1$
			buf.append(String.format("<thead>%n")); //$NON-NLS-1$
			buf.append(String
					.format(Messages.getString("WolfACL.THEAD0"), //$NON-NLS-1$
							roles.size()));
			buf.append(String
					.format(Messages.getString("WolfACL.THEAD1"))); //$NON-NLS-1$
			for (String role : roles) {
				buf.append(String.format("<th rowspan=2>%s</th>", role)); //$NON-NLS-1$
			}
			buf.append(String.format("</tr>%n")); //$NON-NLS-1$
			buf.append(String
					.format(Messages.getString("WolfACL.THEAD2"))); //$NON-NLS-1$

			buf.append(String.format("</thead>%n")); //$NON-NLS-1$
			buf.append(String.format("<tbody>%n")); //$NON-NLS-1$
			WolfACLEntry entry = getFirstEntry();
			while (entry != null) {
				buf.append("  <tr style=font-size:12px; bgcolor=#F3F3F3>"); //$NON-NLS-1$
				buf.append(String.format("<td>%s</td>", entry.getName())); //$NON-NLS-1$
				buf.append(String.format("<td>%s</td>", entry.getUserType() //$NON-NLS-1$
						.getName()));
				buf.append(String.format("<td>%s</td>", entry.getLevel() //$NON-NLS-1$
						.getName()));
				buf.append(String.format("<td>%b</td>", //$NON-NLS-1$
						entry.isCanCreateDocuments()));
				buf.append(String.format("<td>%b</td>", //$NON-NLS-1$
						entry.isCanDeleteDocuments()));
				buf.append(String.format("<td>%b</td>", //$NON-NLS-1$
						entry.isCanCreatePersonalAgent()));
				buf.append(String.format("<td>%b</td>", //$NON-NLS-1$
						entry.isCanCreatePersonalFolder()));
				buf.append(String.format("<td>%b</td>", //$NON-NLS-1$
						entry.isCanCreateSharedFolder()));
				buf.append(String.format("<td>%b</td>", //$NON-NLS-1$
						entry.isCanCreateLSOrJavaAgent()));
				buf.append(String.format("<td>%b</td>", entry.isPublicReader())); //$NON-NLS-1$

				buf.append(String.format("<td>%b</td>", entry.isPublicWriter())); //$NON-NLS-1$
				buf.append(String.format("<td>%b</td>", true)); //$NON-NLS-1$

				for (String role : roles) {
					if (entry.getRoles().contains(role)) {
						buf.append(String.format("<td>%b</td>", //$NON-NLS-1$
								entry.isRoleEnabled(role)));
					} else {
						buf.append("<td>-</td>"); //$NON-NLS-1$
					}
				}

				buf.append(String.format("</tr>%n")); //$NON-NLS-1$
				entry.recycle();
				entry = getNextEntry(entry);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		buf.append(String.format("</tbody>%n")); //$NON-NLS-1$
		buf.append(String.format("</table>%n")); //$NON-NLS-1$
		buf.append(String.format("</html>%n")); //$NON-NLS-1$
		return buf.toString();
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		try {
			buf.append(String.format("ACL isUniformAccess[%b]%n", //$NON-NLS-1$
					isUniformAccess()));

			WolfACLEntry entry = getFirstEntry();
			while (entry != null) {
				buf.append(entry);
				entry.recycle();
				entry = getNextEntry(entry);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buf.toString();
	}
}
