package hiro.yoshioka.sql.engine;

import java.util.Collection;
import java.util.LinkedList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestQueue {
	protected Log fLogger = LogFactory.getLog(getClass());
	private final LinkedList<Request> queue = new LinkedList<Request>();

	public synchronized Request getRequest() {
		while (queue.size() <= 0) {
			try {
				wait();
			} catch (InterruptedException e) {
				fLogger.fatal("lock interrupted...", e);
			}
		}

		return (Request) queue.removeFirst();
	}

	public Collection<Request> list() {
		fLogger.trace(" return list." + queue);
		return queue;
	}

	public synchronized void putRequest(Request request) {
		fLogger.trace(" queue.addLast." + request);
		queue.addLast(request);
		notifyAll();
		fLogger.trace(" called notifyAll.");
	}

	public int getSize() {
		return queue.size();
	}
}