/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.UnsupportedEncodingException;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class TextObjectRecord
extends Record {
    public static final short sid = 438;
    private static final int FORMAT_RUN_ENCODED_SIZE = 8;
    private static final BitField HorizontalTextAlignment = BitFieldFactory.getInstance(14);
    private static final BitField VerticalTextAlignment = BitFieldFactory.getInstance(112);
    private static final BitField textLocked = BitFieldFactory.getInstance(512);
    public static final short HORIZONTAL_TEXT_ALIGNMENT_LEFT_ALIGNED = 1;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_CENTERED = 2;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_RIGHT_ALIGNED = 3;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_JUSTIFIED = 4;
    public static final short VERTICAL_TEXT_ALIGNMENT_TOP = 1;
    public static final short VERTICAL_TEXT_ALIGNMENT_CENTER = 2;
    public static final short VERTICAL_TEXT_ALIGNMENT_BOTTOM = 3;
    public static final short VERTICAL_TEXT_ALIGNMENT_JUSTIFY = 4;
    public static final short TEXT_ORIENTATION_NONE = 0;
    public static final short TEXT_ORIENTATION_TOP_TO_BOTTOM = 1;
    public static final short TEXT_ORIENTATION_ROT_RIGHT = 2;
    public static final short TEXT_ORIENTATION_ROT_LEFT = 3;
    private int field_1_options;
    private int field_2_textOrientation;
    private int field_3_reserved4;
    private int field_4_reserved5;
    private int field_5_reserved6;
    private int field_8_reserved7;
    private HSSFRichTextString _text;
    private int _unknownPreFormulaInt;
    private Ptg _linkRefPtg;
    private Byte _unknownPostFormulaByte;

    public TextObjectRecord() {
    }

    public TextObjectRecord(RecordInputStream in) {
        this.field_1_options = in.readUShort();
        this.field_2_textOrientation = in.readUShort();
        this.field_3_reserved4 = in.readUShort();
        this.field_4_reserved5 = in.readUShort();
        this.field_5_reserved6 = in.readUShort();
        int field_6_textLength = in.readUShort();
        int field_7_formattingDataLength = in.readUShort();
        this.field_8_reserved7 = in.readInt();
        if (in.remaining() > 0) {
            if (in.remaining() < 11) {
                throw new RecordFormatException("Not enough remaining data for a link formula");
            }
            int formulaSize = in.readUShort();
            this._unknownPreFormulaInt = in.readInt();
            Ptg[] ptgs = Ptg.readTokens(formulaSize, in);
            if (ptgs.length != 1) {
                throw new RecordFormatException("Read " + ptgs.length + " tokens but expected exactly 1");
            }
            this._linkRefPtg = ptgs[0];
            this._unknownPostFormulaByte = in.remaining() > 0 ? new Byte(in.readByte()) : null;
        } else {
            this._linkRefPtg = null;
        }
        if (in.remaining() > 0) {
            throw new RecordFormatException("Unused " + in.remaining() + " bytes at end of record");
        }
        String text = field_6_textLength > 0 ? TextObjectRecord.readRawString(in, field_6_textLength) : "";
        this._text = new HSSFRichTextString(text);
        if (field_7_formattingDataLength > 0) {
            if (in.isContinueNext() && in.remaining() == 0) {
                in.nextRecord();
                TextObjectRecord.processFontRuns(in, this._text, field_7_formattingDataLength);
            } else {
                throw new RecordFormatException("Expected Continue Record to hold font runs for TextObjectRecord");
            }
        }
    }

    private static String readRawString(RecordInputStream in, int textLength) {
        boolean isCompressed;
        byte compressByte = in.readByte();
        boolean bl = isCompressed = (compressByte & 1) == 0;
        if (isCompressed) {
            return in.readCompressedUnicode(textLength);
        }
        return in.readUnicodeLEString(textLength);
    }

    private static void processFontRuns(RecordInputStream in, HSSFRichTextString str, int formattingRunDataLength) {
        if (formattingRunDataLength % 8 != 0) {
            throw new RecordFormatException("Bad format run data length " + formattingRunDataLength + ")");
        }
        if (in.remaining() != formattingRunDataLength) {
            throw new RecordFormatException("Expected " + formattingRunDataLength + " bytes but got " + in.remaining());
        }
        int nRuns = formattingRunDataLength / 8;
        for (int i = 0; i < nRuns; ++i) {
            short index = in.readShort();
            short iFont = in.readShort();
            in.readInt();
            str.applyFont((int)index, str.length(), iFont);
        }
    }

    public short getSid() {
        return 438;
    }

    private int getDataSize() {
        int result = 18;
        if (this._linkRefPtg != null) {
            result += 6 + this._linkRefPtg.getSize();
            if (this._unknownPostFormulaByte != null) {
                ++result;
            }
        }
        return result;
    }

    private int serializeTXORecord(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        LittleEndian.putUShort(data, 0 + offset, 438);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putUShort(data, 4 + offset, this.field_1_options);
        LittleEndian.putUShort(data, 6 + offset, this.field_2_textOrientation);
        LittleEndian.putUShort(data, 8 + offset, this.field_3_reserved4);
        LittleEndian.putUShort(data, 10 + offset, this.field_4_reserved5);
        LittleEndian.putUShort(data, 12 + offset, this.field_5_reserved6);
        LittleEndian.putUShort(data, 14 + offset, this._text.length());
        LittleEndian.putUShort(data, 16 + offset, this.getFormattingDataLength());
        LittleEndian.putInt(data, 18 + offset, this.field_8_reserved7);
        if (this._linkRefPtg != null) {
            int pos = offset + 22;
            int formulaSize = this._linkRefPtg.getSize();
            LittleEndian.putUShort(data, pos, formulaSize);
            LittleEndian.putInt(data, pos += 2, this._unknownPreFormulaInt);
            this._linkRefPtg.writeBytes(data, pos += 4);
            pos += formulaSize;
            if (this._unknownPostFormulaByte != null) {
                LittleEndian.putByte(data, pos, this._unknownPostFormulaByte.byteValue());
                ++pos;
            }
        }
        return 4 + dataSize;
    }

    private int serializeTrailingRecords(int offset, byte[] data) {
        byte[] textBytes;
        try {
            textBytes = this._text.getString().getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        int remainingLength = textBytes.length;
        int countTextBytesWritten = 0;
        int pos = offset;
        Byte unicodeFlag = new Byte(1);
        while (remainingLength > 0) {
            int chunkSize = Math.min(8222, remainingLength);
            remainingLength -= chunkSize;
            pos += ContinueRecord.write(data, pos, unicodeFlag, textBytes, countTextBytesWritten, chunkSize);
            countTextBytesWritten += chunkSize;
        }
        byte[] formatData = TextObjectRecord.createFormatData(this._text);
        pos += ContinueRecord.write(data, pos, null, formatData);
        return pos - offset;
    }

    private int getTrailingRecordsSize() {
        if (this._text.length() < 1) {
            return 0;
        }
        int encodedTextSize = 0;
        int textBytesLength = this._text.length() * 2;
        while (textBytesLength > 0) {
            int chunkSize = Math.min(8222, textBytesLength);
            textBytesLength -= chunkSize;
            encodedTextSize += 4;
            encodedTextSize += 1 + chunkSize;
        }
        int encodedFormatSize = (this._text.numFormattingRuns() + 1) * 8 + 4;
        return encodedTextSize + encodedFormatSize;
    }

    public int serialize(int offset, byte[] data) {
        int expectedTotalSize = this.getRecordSize();
        int totalSize = this.serializeTXORecord(offset, data);
        if (this._text.getString().length() > 0) {
            totalSize += this.serializeTrailingRecords(offset + totalSize, data);
        }
        if (totalSize != expectedTotalSize) {
            throw new RecordFormatException(totalSize + " bytes written but getRecordSize() reports " + expectedTotalSize);
        }
        return totalSize;
    }

    public int getRecordSize() {
        int baseSize = 4 + this.getDataSize();
        return baseSize + this.getTrailingRecordsSize();
    }

    private int getFormattingDataLength() {
        if (this._text.length() < 1) {
            return 0;
        }
        return (this._text.numFormattingRuns() + 1) * 8;
    }

    private static byte[] createFormatData(HSSFRichTextString str) {
        int nRuns = str.numFormattingRuns();
        byte[] result = new byte[(nRuns + 1) * 8];
        int pos = 0;
        for (int i = 0; i < nRuns; ++i) {
            LittleEndian.putUShort(result, pos, str.getIndexOfFormattingRun(i));
            short fontIndex = str.getFontOfFormattingRun(i);
            LittleEndian.putUShort(result, pos += 2, fontIndex == 0 ? (short)0 : fontIndex);
            pos += 2;
            pos += 4;
        }
        LittleEndian.putUShort(result, pos, str.length());
        LittleEndian.putUShort(result, pos += 2, 0);
        pos += 2;
        pos += 4;
        return result;
    }

    public void setHorizontalTextAlignment(int value) {
        this.field_1_options = HorizontalTextAlignment.setValue(this.field_1_options, value);
    }

    public int getHorizontalTextAlignment() {
        return HorizontalTextAlignment.getValue(this.field_1_options);
    }

    public void setVerticalTextAlignment(int value) {
        this.field_1_options = VerticalTextAlignment.setValue(this.field_1_options, value);
    }

    public int getVerticalTextAlignment() {
        return VerticalTextAlignment.getValue(this.field_1_options);
    }

    public void setTextLocked(boolean value) {
        this.field_1_options = textLocked.setBoolean(this.field_1_options, value);
    }

    public boolean isTextLocked() {
        return textLocked.isSet(this.field_1_options);
    }

    public int getTextOrientation() {
        return this.field_2_textOrientation;
    }

    public void setTextOrientation(int textOrientation) {
        this.field_2_textOrientation = textOrientation;
    }

    public HSSFRichTextString getStr() {
        return this._text;
    }

    public void setStr(HSSFRichTextString str) {
        this._text = str;
    }

    public Ptg getLinkRefPtg() {
        return this._linkRefPtg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[TXO]\n");
        sb.append("    .options        = ").append(HexDump.shortToHex(this.field_1_options)).append("\n");
        sb.append("         .isHorizontal = ").append(this.getHorizontalTextAlignment()).append('\n');
        sb.append("         .isVertical   = ").append(this.getVerticalTextAlignment()).append('\n');
        sb.append("         .textLocked   = ").append(this.isTextLocked()).append('\n');
        sb.append("    .textOrientation= ").append(HexDump.shortToHex(this.getTextOrientation())).append("\n");
        sb.append("    .reserved4      = ").append(HexDump.shortToHex(this.field_3_reserved4)).append("\n");
        sb.append("    .reserved5      = ").append(HexDump.shortToHex(this.field_4_reserved5)).append("\n");
        sb.append("    .reserved6      = ").append(HexDump.shortToHex(this.field_5_reserved6)).append("\n");
        sb.append("    .textLength     = ").append(HexDump.shortToHex(this._text.length())).append("\n");
        sb.append("    .reserved7      = ").append(HexDump.intToHex(this.field_8_reserved7)).append("\n");
        sb.append("    .string = ").append(this._text).append('\n');
        for (int i = 0; i < this._text.numFormattingRuns(); ++i) {
            sb.append("    .textrun = ").append(this._text.getFontOfFormattingRun(i)).append('\n');
        }
        sb.append("[/TXO]\n");
        return sb.toString();
    }

    public Object clone() {
        TextObjectRecord rec = new TextObjectRecord();
        rec._text = this._text;
        rec.field_1_options = this.field_1_options;
        rec.field_2_textOrientation = this.field_2_textOrientation;
        rec.field_3_reserved4 = this.field_3_reserved4;
        rec.field_4_reserved5 = this.field_4_reserved5;
        rec.field_5_reserved6 = this.field_5_reserved6;
        rec.field_8_reserved7 = this.field_8_reserved7;
        rec._text = this._text;
        if (this._linkRefPtg != null) {
            rec._unknownPreFormulaInt = this._unknownPreFormulaInt;
            rec._linkRefPtg = this._linkRefPtg.copy();
            rec._unknownPostFormulaByte = rec._unknownPostFormulaByte;
        }
        return rec;
    }
}

