/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class FormulaRecord
extends Record
implements CellValueRecordInterface {
    public static final short sid = 6;
    private static int FIXED_SIZE = 22;
    private static final BitField alwaysCalc = BitFieldFactory.getInstance(1);
    private static final BitField calcOnLoad = BitFieldFactory.getInstance(2);
    private static final BitField sharedFormula = BitFieldFactory.getInstance(8);
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf;
    private double field_4_value;
    private short field_5_options;
    private int field_6_zero;
    private Ptg[] field_8_parsed_expr;
    private SpecialCachedValue specialCachedValue;

    public FormulaRecord() {
        this.field_8_parsed_expr = Ptg.EMPTY_PTG_ARRAY;
    }

    public FormulaRecord(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_column = in.readShort();
        this.field_3_xf = in.readShort();
        long valueLongBits = in.readLong();
        this.field_5_options = in.readShort();
        this.specialCachedValue = SpecialCachedValue.create(valueLongBits);
        if (this.specialCachedValue == null) {
            this.field_4_value = Double.longBitsToDouble(valueLongBits);
        }
        this.field_6_zero = in.readInt();
        short field_7_expression_len = in.readShort();
        this.field_8_parsed_expr = Ptg.readTokens(field_7_expression_len, in);
        if (in.remaining() == 10) {
            // empty if block
        }
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public void setColumn(short column) {
        this.field_2_column = column;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public void setValue(double value) {
        this.field_4_value = value;
        this.specialCachedValue = null;
    }

    public void setCachedResultTypeEmptyString() {
        this.specialCachedValue = SpecialCachedValue.createCachedEmptyValue();
    }

    public void setCachedResultTypeString() {
        this.specialCachedValue = SpecialCachedValue.createForString();
    }

    public void setCachedResultErrorCode(int errorCode) {
        this.specialCachedValue = SpecialCachedValue.createCachedErrorCode(errorCode);
    }

    public void setCachedResultBoolean(boolean value) {
        this.specialCachedValue = SpecialCachedValue.createCachedBoolean(value);
    }

    public boolean hasCachedResultString() {
        if (this.specialCachedValue == null) {
            return false;
        }
        return this.specialCachedValue.getTypeCode() == 0;
    }

    public int getCachedResultType() {
        if (this.specialCachedValue == null) {
            return 0;
        }
        return this.specialCachedValue.getValueType();
    }

    public boolean getCachedBooleanValue() {
        return this.specialCachedValue.getBooleanValue();
    }

    public int getCachedErrorValue() {
        return this.specialCachedValue.getErrorValue();
    }

    public void setOptions(short options) {
        this.field_5_options = options;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean isSharedFormula() {
        return sharedFormula.isSet(this.field_5_options);
    }

    public void setSharedFormula(boolean flag) {
        this.field_5_options = sharedFormula.setShortBoolean(this.field_5_options, flag);
    }

    public boolean isAlwaysCalc() {
        return alwaysCalc.isSet(this.field_5_options);
    }

    public void setAlwaysCalc(boolean flag) {
        this.field_5_options = alwaysCalc.setShortBoolean(this.field_5_options, flag);
    }

    public boolean isCalcOnLoad() {
        return calcOnLoad.isSet(this.field_5_options);
    }

    public void setCalcOnLoad(boolean flag) {
        this.field_5_options = calcOnLoad.setShortBoolean(this.field_5_options, flag);
    }

    public Ptg[] getParsedExpression() {
        return (Ptg[])this.field_8_parsed_expr.clone();
    }

    public void setParsedExpression(Ptg[] ptgs) {
        this.field_8_parsed_expr = ptgs;
    }

    public short getSid() {
        return 6;
    }

    private int getDataSize() {
        return FIXED_SIZE + Ptg.getEncodedSize(this.field_8_parsed_expr);
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = this.getDataSize();
        LittleEndian.putShort(data, 0 + offset, (short)6);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putUShort(data, 4 + offset, this.getRow());
        LittleEndian.putShort(data, 6 + offset, this.getColumn());
        LittleEndian.putShort(data, 8 + offset, this.getXFIndex());
        if (this.specialCachedValue == null) {
            LittleEndian.putDouble(data, 10 + offset, this.field_4_value);
        } else {
            this.specialCachedValue.serialize(data, 10 + offset);
        }
        LittleEndian.putShort(data, 18 + offset, this.getOptions());
        LittleEndian.putInt(data, 20 + offset, 0);
        int formulaTokensSize = Ptg.getEncodedSizeWithoutArrayData(this.field_8_parsed_expr);
        LittleEndian.putUShort(data, 24 + offset, formulaTokensSize);
        Ptg.serializePtgs(this.field_8_parsed_expr, data, 26 + offset);
        return 4 + dataSize;
    }

    public int getRecordSize() {
        return 4 + this.getDataSize();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[FORMULA]\n");
        sb.append("\t.row\t   = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        sb.append("\t.column\t= ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        sb.append("\t.xf\t\t= ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        sb.append("\t.value\t = ");
        if (this.specialCachedValue == null) {
            sb.append(this.field_4_value).append("\n");
        } else {
            sb.append(this.specialCachedValue.formatDebugString()).append("\n");
        }
        sb.append("\t.options   = ").append(HexDump.shortToHex(this.getOptions())).append("\n");
        sb.append("\t.alwaysCalc= ").append(alwaysCalc.isSet(this.getOptions())).append("\n");
        sb.append("\t.calcOnLoad= ").append(calcOnLoad.isSet(this.getOptions())).append("\n");
        sb.append("\t.shared\t= ").append(sharedFormula.isSet(this.getOptions())).append("\n");
        sb.append("\t.zero\t  = ").append(HexDump.intToHex(this.field_6_zero)).append("\n");
        for (int k = 0; k < this.field_8_parsed_expr.length; ++k) {
            sb.append("\t Ptg[").append(k).append("]=");
            Ptg ptg = this.field_8_parsed_expr[k];
            sb.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        sb.append("[/FORMULA]\n");
        return sb.toString();
    }

    public Object clone() {
        FormulaRecord rec = new FormulaRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_column = this.field_2_column;
        rec.field_3_xf = this.field_3_xf;
        rec.field_4_value = this.field_4_value;
        rec.field_5_options = this.field_5_options;
        rec.field_6_zero = this.field_6_zero;
        int nTokens = this.field_8_parsed_expr.length;
        Ptg[] ptgs = new Ptg[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            ptgs[i] = this.field_8_parsed_expr[i].copy();
        }
        rec.field_8_parsed_expr = ptgs;
        rec.specialCachedValue = this.specialCachedValue;
        return rec;
    }

    private static final class SpecialCachedValue {
        private static final long BIT_MARKER = -281474976710656L;
        private static final int VARIABLE_DATA_LENGTH = 6;
        private static final int DATA_INDEX = 2;
        public static final int STRING = 0;
        public static final int BOOLEAN = 1;
        public static final int ERROR_CODE = 2;
        public static final int EMPTY = 3;
        private final byte[] _variableData;

        private SpecialCachedValue(byte[] data) {
            this._variableData = data;
        }

        public int getTypeCode() {
            return this._variableData[0];
        }

        public static SpecialCachedValue create(long valueLongBits) {
            if ((0xFFFF000000000000L & valueLongBits) != -281474976710656L) {
                return null;
            }
            byte[] result = new byte[6];
            long x = valueLongBits;
            for (int i = 0; i < 6; ++i) {
                result[i] = (byte)x;
                x >>= 8;
            }
            switch (result[0]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new RecordFormatException("Bad special value code (" + result[0] + ")");
                }
            }
            return new SpecialCachedValue(result);
        }

        public void serialize(byte[] data, int offset) {
            System.arraycopy(this._variableData, 0, data, offset, 6);
            LittleEndian.putUShort(data, offset + 6, 65535);
        }

        public String formatDebugString() {
            return this.formatValue() + ' ' + HexDump.toHex(this._variableData);
        }

        private String formatValue() {
            int typeCode = this.getTypeCode();
            switch (typeCode) {
                case 0: {
                    return "<string>";
                }
                case 1: {
                    return this.getDataValue() == 0 ? "FALSE" : "TRUE";
                }
                case 2: {
                    return ErrorEval.getText(this.getDataValue());
                }
                case 3: {
                    return "<empty>";
                }
            }
            return "#error(type=" + typeCode + ")#";
        }

        private int getDataValue() {
            return this._variableData[2];
        }

        public static SpecialCachedValue createCachedEmptyValue() {
            return SpecialCachedValue.create(3, 0);
        }

        public static SpecialCachedValue createForString() {
            return SpecialCachedValue.create(0, 0);
        }

        public static SpecialCachedValue createCachedBoolean(boolean b) {
            return SpecialCachedValue.create(1, b ? 0 : 1);
        }

        public static SpecialCachedValue createCachedErrorCode(int errorCode) {
            return SpecialCachedValue.create(2, errorCode);
        }

        private static SpecialCachedValue create(int code, int data) {
            byte[] vd = new byte[]{(byte)code, 0, (byte)data, 0, 0, 0};
            return new SpecialCachedValue(vd);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName());
            sb.append('[').append(this.formatValue()).append(']');
            return sb.toString();
        }

        public int getValueType() {
            int typeCode = this.getTypeCode();
            switch (typeCode) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 1;
                }
            }
            throw new IllegalStateException("Unexpected type id (" + typeCode + ")");
        }

        public boolean getBooleanValue() {
            if (this.getTypeCode() != 1) {
                throw new IllegalStateException("Not a boolean cached value - " + this.formatValue());
            }
            return this.getDataValue() != 0;
        }

        public int getErrorValue() {
            if (this.getTypeCode() != 2) {
                throw new IllegalStateException("Not an error cached value - " + this.formatValue());
            }
            return this.getDataValue();
        }
    }
}

