/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.util.ColumnBindingUtil;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;

public class LibraryElementsToolHandleExtends
extends AbstractToolHandleExtends {
    private DesignElementHandle elementHandle;

    public LibraryElementsToolHandleExtends(DesignElementHandle elementHandle) {
        Assert.isLegal((boolean)(elementHandle.getRoot() instanceof LibraryHandle));
        this.elementHandle = elementHandle;
    }

    public boolean preHandleMouseUp() {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        LibraryHandle library = (LibraryHandle)this.elementHandle.getRoot();
        try {
            if (UIUtil.includeLibrary(moduleHandle, library)) {
                if (this.elementHandle instanceof ThemeHandle) {
                    ThemeHandle model = UIUtil.applyTheme((ThemeHandle)this.elementHandle, moduleHandle, library);
                    if (model != null) {
                        this.setModel(this.elementHandle);
                    }
                } else {
                    DesignElementHandle newHandle = moduleHandle.getElementFactory().newElementFrom(this.elementHandle, this.elementHandle.getName());
                    this.setModel(newHandle);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InvalidParentException || e instanceof WrongTypeException) {
                GUIException exception = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e, (String)"Library.DND.messages.outofsync");
                ExceptionHandler.handle((Throwable)exception);
            }
            ExceptionHandler.handle(e);
        }
        this.getRequest().getExtendedData().put("newObject from library", Boolean.TRUE);
        return super.preHandleMouseUp();
    }

    public boolean preHandleMouseDown() {
        return false;
    }

    public boolean postHandleCreation() {
        Object model = this.getModel();
        boolean isMove = false;
        if (this.needProcessDataItem(model)) {
            MessageDialogWithToggle dialog;
            String prompt = ReportPlugin.getDefault().getPreferenceStore().getString("designer.library.preference.libraries.move.bindings.preferencestore");
            if ("always".equals(prompt)) {
                this.moveBindToHost((DataItemHandle)model);
                isMove = true;
            } else if ((prompt == null || "prompt".equals(prompt)) && (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"LibraryElementsToolHandleExtends_question"), (String)Messages.getString((String)"LibraryElementsToolHandleExtends_message"), (String)Messages.getString((String)"LibraryElementsToolHandleExtends_toggle"), (boolean)false, (IPreferenceStore)ReportPlugin.getDefault().getPreferenceStore(), (String)"designer.library.preference.libraries.move.bindings.preferencestore")) != null) {
                if (dialog.getReturnCode() == 2) {
                    this.moveBindToHost((DataItemHandle)model);
                    isMove = true;
                }
                if (dialog.getToggleState()) {
                    if (dialog.getReturnCode() == 2) {
                        ReportPlugin.getDefault().getPreferenceStore().setValue("designer.library.preference.libraries.move.bindings.preferencestore", "always");
                    } else if (dialog.getReturnCode() == 3) {
                        ReportPlugin.getDefault().getPreferenceStore().setValue("designer.library.preference.libraries.move.bindings.preferencestore", "never");
                    }
                }
            }
        }
        if (!isMove && model instanceof DataItemHandle) {
            DataItemHandle dataHandle = (DataItemHandle)model;
            Iterator iter = dataHandle.columnBindingsIterator();
            String resultColumnName = dataHandle.getResultSetColumn();
            ComputedColumnHandle activeBinding = null;
            while (iter.hasNext()) {
                ComputedColumnHandle computedColumnHandle = (ComputedColumnHandle)iter.next();
                if (!computedColumnHandle.getName().equals(resultColumnName)) continue;
                Expression newExpression = (Expression)computedColumnHandle.getExpressionProperty("expression").getValue();
                if (newExpression == null || newExpression.getExpression() == null) {
                    activeBinding = computedColumnHandle;
                    break;
                }
                if (!(newExpression.getExpression() instanceof String) || ((String)newExpression.getExpression()).length() != 0) break;
                activeBinding = computedColumnHandle;
                break;
            }
            if (activeBinding != null) {
                DataColumnBindingDialog dialog = new DataColumnBindingDialog(false);
                dialog.setNeedPrompt(false);
                dialog.setInput((ReportItemHandle)dataHandle, activeBinding);
                dialog.open();
            }
        }
        return super.postHandleCreation();
    }

    private boolean needProcessDataItem(Object handle) {
        DataItemHandle dataHandle;
        if (handle instanceof DataItemHandle && (dataHandle = (DataItemHandle)handle).getExtends() != null && dataHandle.getExtends().getContainer() instanceof LibraryHandle) {
            if (dataHandle.getDataSet() != null) {
                return false;
            }
            if (DEUtil.getBindingHolder((DesignElementHandle)dataHandle, (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)dataHandle, (boolean)true) == dataHandle) {
                return false;
            }
            Iterator iter = dataHandle.columnBindingsIterator();
            return iter.hasNext();
        }
        return false;
    }

    private void moveBindToHost(DataItemHandle dataHandle) {
        ReportItemHandle hostHnadle = DEUtil.getBindingHolder((DesignElementHandle)dataHandle, (boolean)true);
        Iterator iter = dataHandle.columnBindingsIterator();
        String resultColumnName = dataHandle.getResultSetColumn();
        ArrayList<String> list = new ArrayList<String>();
        ComputedColumnHandle activeBinding = null;
        while (iter.hasNext()) {
            ComputedColumnHandle computedColumnHandle = (ComputedColumnHandle)iter.next();
            String name = computedColumnHandle.getName();
            boolean isDataBinding = false;
            if (name.equals(resultColumnName)) {
                isDataBinding = true;
            }
            ComputedColumn bindingColumn = (ComputedColumn)computedColumnHandle.getStructure().copy();
            try {
                ComputedColumnHandle newComputedColumnHandle = ColumnBindingUtil.addColumnBinding((ReportItemHandle)hostHnadle, (ComputedColumn)bindingColumn);
                if (isDataBinding && !newComputedColumnHandle.getName().equals(name)) {
                    dataHandle.setResultSetColumn(newComputedColumnHandle.getName());
                }
                if (isDataBinding) {
                    Expression newExpression = (Expression)newComputedColumnHandle.getExpressionProperty("expression").getValue();
                    if (newExpression == null || newExpression.getExpression() == null) {
                        activeBinding = newComputedColumnHandle;
                    } else if (newExpression.getExpression() instanceof String && ((String)newExpression.getExpression()).length() == 0) {
                        activeBinding = newComputedColumnHandle;
                    }
                }
            }
            catch (SemanticException semanticException) {}
            list.add(computedColumnHandle.getName());
        }
        try {
            dataHandle.removedColumnBindings(list);
            dataHandle.setProperty("boundDataColumns", new ArrayList());
        }
        catch (SemanticException semanticException) {}
        if (activeBinding != null) {
            DataColumnBindingDialog dialog = new DataColumnBindingDialog(false);
            dialog.setNeedPrompt(false);
            dialog.setInput(hostHnadle, activeBinding);
            dialog.open();
        }
    }
}

