/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.format.CSSFormatable;
import com.steadystate.css.util.LangUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSRuleListImpl
implements CSSRuleList,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = -1269068897476453290L;
    private List<CSSRule> rules_;

    public List<CSSRule> getRules() {
        if (this.rules_ == null) {
            this.rules_ = new ArrayList<CSSRule>();
        }
        return this.rules_;
    }

    public void setRules(List<CSSRule> rules) {
        this.rules_ = rules;
    }

    @Override
    public int getLength() {
        return this.getRules().size();
    }

    @Override
    public CSSRule item(int index) {
        if (index < 0 || null == this.rules_ || index >= this.rules_.size()) {
            return null;
        }
        return this.rules_.get(index);
    }

    public void add(CSSRule rule) {
        this.getRules().add(rule);
    }

    public void insert(CSSRule rule, int index) {
        this.getRules().add(index, rule);
    }

    public void delete(int index) {
        this.getRules().remove(index);
    }

    public String getCssText() {
        return this.getCssText(null);
    }

    @Override
    public String getCssText(CSSFormat format) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getLength(); ++i) {
            CSSRule rule;
            if (i > 0) {
                sb.append("\r\n");
            }
            if ((rule = this.item(i)) instanceof CSSFormatable) {
                sb.append(((CSSFormatable)((Object)rule)).getCssText(format));
                continue;
            }
            sb.append(rule.toString());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCssText(null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSRuleList)) {
            return false;
        }
        CSSRuleList crl = (CSSRuleList)obj;
        return this.equalsRules(crl);
    }

    private boolean equalsRules(CSSRuleList crl) {
        if (crl == null || this.getLength() != crl.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            CSSRule cssRule2;
            CSSRule cssRule1 = this.item(i);
            if (LangUtils.equals(cssRule1, cssRule2 = crl.item(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.rules_);
        return hash;
    }
}

