/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.CodecProvider;
import com.healthmarketscience.jackcess.Database;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.TimeZone;

public class DatabaseBuilder {
    private File _mdbFile;
    private boolean _readOnly;
    private boolean _autoSync = true;
    private Charset _charset;
    private TimeZone _timeZone;
    private CodecProvider _codecProvider;
    private Database.FileFormat _fileFormat;
    private FileChannel _channel;

    public DatabaseBuilder() {
        this(null);
    }

    public DatabaseBuilder(File mdbFile) {
        this._mdbFile = mdbFile;
    }

    public DatabaseBuilder setFile(File mdbFile) {
        this._mdbFile = mdbFile;
        return this;
    }

    public DatabaseBuilder setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
        return this;
    }

    public DatabaseBuilder setAutoSync(boolean autoSync) {
        this._autoSync = autoSync;
        return this;
    }

    public DatabaseBuilder setCharset(Charset charset) {
        this._charset = charset;
        return this;
    }

    public DatabaseBuilder setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
        return this;
    }

    public DatabaseBuilder setCodecProvider(CodecProvider codecProvider) {
        this._codecProvider = codecProvider;
        return this;
    }

    public DatabaseBuilder setFileFormat(Database.FileFormat fileFormat) {
        this._fileFormat = fileFormat;
        return this;
    }

    public DatabaseBuilder setChannel(FileChannel channel) {
        this._channel = channel;
        return this;
    }

    public Database open() throws IOException {
        return Database.open(this._mdbFile, this._readOnly, this._channel, this._autoSync, this._charset, this._timeZone, this._codecProvider);
    }

    public Database create() throws IOException {
        return Database.create(this._fileFormat, this._mdbFile, this._channel, this._autoSync, this._charset, this._timeZone);
    }
}

