/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel.socket.nio;

import com.datastax.shaded.netty.channel.AbstractServerChannel;
import com.datastax.shaded.netty.channel.ChannelException;
import com.datastax.shaded.netty.channel.ChannelFactory;
import com.datastax.shaded.netty.channel.ChannelPipeline;
import com.datastax.shaded.netty.channel.ChannelSink;
import com.datastax.shaded.netty.channel.Channels;
import com.datastax.shaded.netty.channel.socket.DefaultServerSocketChannelConfig;
import com.datastax.shaded.netty.channel.socket.ServerSocketChannel;
import com.datastax.shaded.netty.channel.socket.ServerSocketChannelConfig;
import com.datastax.shaded.netty.channel.socket.nio.Boss;
import com.datastax.shaded.netty.channel.socket.nio.NioWorker;
import com.datastax.shaded.netty.channel.socket.nio.WorkerPool;
import com.datastax.shaded.netty.logging.InternalLogger;
import com.datastax.shaded.netty.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioServerSocketChannel
extends AbstractServerChannel
implements ServerSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketChannel.class);
    final java.nio.channels.ServerSocketChannel socket;
    final Boss boss;
    final WorkerPool<NioWorker> workerPool;
    private final ServerSocketChannelConfig config;

    NioServerSocketChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Boss boss, WorkerPool<NioWorker> workerPool) {
        super(factory, pipeline, sink);
        this.boss = boss;
        this.workerPool = workerPool;
        try {
            this.socket = java.nio.channels.ServerSocketChannel.open();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a server socket.", e);
        }
        try {
            this.socket.configureBlocking(false);
        }
        catch (IOException e) {
            block6: {
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    if (!logger.isWarnEnabled()) break block6;
                    logger.warn("Failed to close a partially initialized socket.", e2);
                }
            }
            throw new ChannelException("Failed to enter non-blocking mode.", e);
        }
        this.config = new DefaultServerSocketChannelConfig(this.socket.socket());
        Channels.fireChannelOpen(this);
    }

    @Override
    public ServerSocketChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.socket().getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    @Override
    public boolean isBound() {
        return this.isOpen() && this.socket.socket().isBound();
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }
}

