/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel;

import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelFuture;
import com.datastax.shaded.netty.channel.ChannelFutureListener;
import com.datastax.shaded.netty.util.internal.ConcurrentIdentityWeakKeyHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelLocal<T>
implements Iterable<Map.Entry<Channel, T>> {
    private final ConcurrentMap<Channel, T> map = new ConcurrentIdentityWeakKeyHashMap<Channel, T>();
    private final ChannelFutureListener remover = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            ChannelLocal.this.remove(future.getChannel());
        }
    };
    private final boolean removeOnClose;

    public ChannelLocal() {
        this(false);
    }

    public ChannelLocal(boolean removeOnClose) {
        this.removeOnClose = removeOnClose;
    }

    protected T initialValue(Channel channel) {
        return null;
    }

    public T get(Channel channel) {
        Object oldValue;
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        Object value = this.map.get(channel);
        if (value == null && (value = this.initialValue(channel)) != null && (oldValue = this.setIfAbsent(channel, value)) != null) {
            value = oldValue;
        }
        return (T)value;
    }

    public T set(Channel channel, T value) {
        if (value == null) {
            return this.remove(channel);
        }
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        T old = this.map.put(channel, value);
        if (this.removeOnClose) {
            channel.getCloseFuture().addListener(this.remover);
        }
        return old;
    }

    public T setIfAbsent(Channel channel, T value) {
        if (value == null) {
            return this.get(channel);
        }
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        T mapping = this.map.putIfAbsent(channel, value);
        if (this.removeOnClose && mapping == null) {
            channel.getCloseFuture().addListener(this.remover);
        }
        return mapping;
    }

    public T remove(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        Object removed = this.map.remove(channel);
        if (removed == null) {
            return this.initialValue(channel);
        }
        if (this.removeOnClose) {
            channel.getCloseFuture().removeListener(this.remover);
        }
        return (T)removed;
    }

    @Override
    public Iterator<Map.Entry<Channel, T>> iterator() {
        return Collections.unmodifiableSet(this.map.entrySet()).iterator();
    }
}

