/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInfo
implements Comparable<PropertyInfo> {
    private Class<?> beanClass;
    private String name;
    private boolean isStatic;
    private Field field;
    Method readMethod;
    Method writeMethod;

    public PropertyInfo(Class<?> beanClass, String name, Field field, Method readMethod, Method writeMethod, boolean isStatic) {
        this.beanClass = beanClass;
        this.name = name;
        this.isStatic = isStatic;
        this.field = field;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public Field getField() {
        return this.field;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public boolean isReadable() {
        return this.readMethod != null || this.field != null;
    }

    public Member getReadMember() {
        if (this.readMethod != null) {
            return this.readMethod;
        }
        if (this.field != null) {
            return this.field;
        }
        throw new IllegalStateException(this.name + " property is not readable.");
    }

    public Class<?> getReadType() {
        if (this.readMethod != null) {
            return this.readMethod.getReturnType();
        }
        if (this.field != null) {
            return this.field.getType();
        }
        throw new IllegalStateException(this.name + " property is not readable.");
    }

    public Type getReadGenericType() {
        if (this.readMethod != null) {
            return this.readMethod.getGenericReturnType();
        }
        if (this.field != null) {
            return this.field.getGenericType();
        }
        throw new IllegalStateException(this.name + " property is not readable.");
    }

    public <T extends Annotation> T getReadAnnotation(Class<T> annotationClass) {
        if (this.readMethod != null) {
            return this.readMethod.getAnnotation(annotationClass);
        }
        if (this.field != null) {
            return this.field.getAnnotation(annotationClass);
        }
        throw new IllegalStateException(this.name + " property is not readable.");
    }

    public Object get(Object target) {
        try {
            if (this.readMethod != null) {
                try {
                    return this.readMethod.invoke(target, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Error) {
                        throw (Error)e.getCause();
                    }
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new IllegalStateException(e.getCause());
                }
            }
            if (this.field != null) {
                return this.field.get(target);
            }
            throw new IllegalStateException(this.name + " property is not readable.");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isWritable() {
        return this.writeMethod != null || this.field != null && !Modifier.isFinal(this.field.getModifiers());
    }

    public Member getWriteMember() {
        if (this.writeMethod != null) {
            return this.writeMethod;
        }
        if (this.field != null && !Modifier.isFinal(this.field.getModifiers())) {
            return this.field;
        }
        throw new IllegalStateException(this.name + " property is not writable.");
    }

    public Class<?> getWriteType() {
        if (this.writeMethod != null) {
            return this.writeMethod.getParameterTypes()[0];
        }
        if (this.field != null && !Modifier.isFinal(this.field.getModifiers())) {
            return this.field.getType();
        }
        throw new IllegalStateException(this.name + " property is not writable.");
    }

    public Type getWriteGenericType() {
        if (this.writeMethod != null) {
            return this.writeMethod.getGenericParameterTypes()[0];
        }
        if (this.field != null && !Modifier.isFinal(this.field.getModifiers())) {
            return this.field.getGenericType();
        }
        throw new IllegalStateException(this.name + " property is not writable.");
    }

    public <T extends Annotation> T getWriteAnnotation(Class<T> annotationClass) {
        if (this.writeMethod != null) {
            return this.writeMethod.getAnnotation(annotationClass);
        }
        if (this.field != null && !Modifier.isFinal(this.field.getModifiers())) {
            return this.field.getAnnotation(annotationClass);
        }
        throw new IllegalStateException(this.name + " property is not writable.");
    }

    public void set(Object target, Object value) {
        block9: {
            try {
                if (this.writeMethod != null) {
                    try {
                        this.writeMethod.invoke(target, value);
                        break block9;
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof Error) {
                            throw (Error)e.getCause();
                        }
                        if (e.getCause() instanceof RuntimeException) {
                            throw (RuntimeException)e.getCause();
                        }
                        throw new IllegalStateException(e.getCause());
                    }
                }
                if (this.field != null && !Modifier.isFinal(this.field.getModifiers())) {
                    this.field.set(target, value);
                    break block9;
                }
                throw new IllegalStateException(this.name + " property is not writable.");
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public int compareTo(PropertyInfo property) {
        if (!this.beanClass.equals(property.beanClass)) {
            return this.beanClass.getName().compareTo(property.beanClass.getName());
        }
        return this.name.compareTo(property.name);
    }

    public String toString() {
        return "Property [beanClass=" + this.beanClass + ", name=" + this.name + ", field=" + this.field + ", readMethod=" + this.readMethod + ", writeMethod=" + this.writeMethod + "]";
    }
}

