/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.core.element.AbstractBlock;
import org.seasar.fisshplate.core.element.IfBlock;
import org.seasar.fisshplate.core.parser.FPParser;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.RowWrapper;

public abstract class AbstractElseParser
implements RowParser {
    public boolean process(CellWrapper cell, FPParser parser) throws FPParseException {
        String value = cell.getStringValue();
        Matcher mat = this.getPattern().matcher(value);
        if (!mat.find()) {
            return false;
        }
        this.checkBlockStack(parser, cell);
        this.processElse(this.getCondition(mat), cell, parser);
        return true;
    }

    private void checkBlockStack(FPParser parser, CellWrapper cell) throws FPParseException {
        if (parser.isBlockStackBlank()) {
            throw new FPParseException("EFP00002", cell.getRow());
        }
    }

    private String getCondition(Matcher mat) {
        String condition = null;
        if (mat.groupCount() > 0) {
            condition = mat.group(1);
        }
        return condition;
    }

    private void processElse(String condition, CellWrapper cell, FPParser parser) throws FPParseException {
        RowWrapper row = cell.getRow();
        AbstractBlock parent = this.getParentIfBlock(row, parser);
        AbstractBlock block = this.createElement(condition);
        ((IfBlock)parent).setNextBlock(block);
        parser.pushBlockToStack(block);
    }

    private AbstractBlock getParentIfBlock(RowWrapper row, FPParser parser) throws FPParseException {
        AbstractBlock parent = parser.getLastElementFromStack();
        if (!(parent instanceof IfBlock)) {
            throw new FPParseException("EFP00002", row);
        }
        return parent;
    }

    protected abstract AbstractBlock createElement(String var1);

    protected abstract Pattern getPattern();
}

