/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.AbstractCell;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.util.FileInputStreamUtil;
import org.seasar.fisshplate.util.ImageIOUtil;
import org.seasar.fisshplate.util.StringUtil;
import org.seasar.fisshplate.wrapper.CellWrapper;

public class Picture
extends AbstractCell {
    public Picture(CellWrapper cell) {
        super(cell);
    }

    protected void mergeImpl(FPContext context, HSSFCell out) throws FPMergeException {
        String cellValue = this.getCellValue().toString();
        Pattern pat = Pattern.compile("^\\s*\\#picture\\((.*)\\s+cell=(.+)\\s*\\s+row=(.+)\\)");
        Matcher mat = pat.matcher(cellValue);
        if (!mat.find()) {
            throw new FPMergeException("EFP00014", new Object[]{cellValue}, this.cell.getRow());
        }
        String picturePath = mat.group(1);
        String cellRange = mat.group(2);
        String rowRange = mat.group(3);
        int cellRangeIntVal = Integer.parseInt(cellRange);
        int rowRangeIntVal = Integer.parseInt(rowRange);
        if (this.isWritePicture(picturePath)) {
            this.writePicture(picturePath, cellRangeIntVal, rowRangeIntVal, context);
        }
    }

    private boolean isWritePicture(String picturePath) {
        if (picturePath.equals("")) {
            return false;
        }
        return picturePath.length() > 0;
    }

    private HSSFClientAnchor createAnchor(int width, int height, int cellNo, int rowNo, int cellRangeIntVal, int rowRangeIntVal) {
        HSSFClientAnchor anchor = new HSSFClientAnchor();
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(255);
        int fromCellNo = cellNo;
        int toCellNo = cellNo + cellRangeIntVal;
        int fromRowNo = rowNo;
        int toRowNo = rowNo + rowRangeIntVal;
        anchor.setCol1((short)fromCellNo);
        anchor.setCol2((short)toCellNo);
        anchor.setRow1(fromRowNo);
        anchor.setRow2(toRowNo);
        anchor.setAnchorType(2);
        return anchor;
    }

    private int setupPictureType(String suffix) throws FPMergeException {
        if (suffix.toLowerCase().equals("jpg")) {
            return 5;
        }
        if (suffix.toLowerCase().equals("png")) {
            return 6;
        }
        throw new FPMergeException("EFP00007");
    }

    private void writePicture(String picturepath, int cellRangeIntVal, int rowRangeIntVal, FPContext context) throws FPMergeException {
        FileInputStream imgFis = FileInputStreamUtil.createFileInputStream(picturepath);
        BufferedImage img = ImageIOUtil.read(imgFis);
        FileInputStreamUtil.close(imgFis);
        HSSFWorkbook workbook = this.cell.getRow().getSheet().getWorkbook().getHSSFWorkbook();
        HSSFPatriarch patriarch = context.getPartriarch();
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        int cellNo = context.getCurrentCellNum();
        int rowNo = context.getCurrentRowNum();
        HSSFClientAnchor anchor = this.createAnchor(imgWidth, imgHeight, cellNo, rowNo, cellRangeIntVal, rowRangeIntVal);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String suffix = StringUtil.parseSuffix(picturepath);
        ImageIOUtil.write(img, suffix, baos);
        byte[] pictureData = baos.toByteArray();
        int pictureType = this.setupPictureType(suffix);
        int pictureIndex = workbook.addPicture(pictureData, pictureType);
        patriarch.createPicture(anchor, pictureIndex);
        ImageIOUtil.close(baos);
    }
}

