/* FluidSynth - A Software Synthesizer
 *
 * Copyright (C) 2003  Peter Hanappe and others.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *  
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307, USA
 */


#ifndef __TIMIDITY_SYNTH_H
#define __TIMIDITY_SYNTH_H


/***************************************************************
 *
 *                         INCLUDES
 */

#if HAVE_CONFIG_H
#include "config.h"
#endif
#include "timiditysynth_priv.h"
//#include "tmdy_list.h"
//#include "tmdy_rev.h"
//#include "tmdy_voice.h"
//#include "tmdy_chorus.h"
//#include "tmdy_ladspa.h"
//#include "tmdy_midi_router.h"  guha
//#include "tmdy_sys.h"

/*
#include "rtsyn_export.h" //guha
#include "instrum_export.h"
#include "playmidi_export.h"
#include "readmidi_export.h"
#include "resample_export.h"
#include "timidity_export.h"
#include "output_export.h"
#include "aq_export.h"
#include "controls_export.h"
*/
/***************************************************************
 *
 *                         DEFINES
 *
#define TIMIDITY_NUM_PROGRAMS      129
#define DRUM_INST_MASK         ((unsigned int)0x80000000)

#if defined(WITH_FLOAT)
#define TIMIDITY_SAMPLE_FORMAT     TIMIDITY_SAMPLE_FLOAT
#else
#define TIMIDITY_SAMPLE_FORMAT     TIMIDITY_SAMPLE_DOUBLE
#endif


***************************************************************
 *
 *                         ENUM
 */
enum tmdy_loop {
  TIMIDITY_UNLOOPED,
  TIMIDITY_LOOP_DURING_RELEASE,
  TIMIDITY_NOTUSED,
  TIMIDITY_LOOP
};

enum tmdy_synth_status
{
  TIMIDITY_SYNTH_CLEAN,
  TIMIDITY_SYNTH_PLAYING,
  TIMIDITY_SYNTH_QUIET,
  TIMIDITY_SYNTH_STOPPED
};

/*
 * tmdy_synth_t
 */

struct _tmdy_synth_t
{
  rtsyn_ex_t * rtsyn;  //guha
  instrum_ex_t *instrum; 
  playmidi_ex_t *playmidi;
  readmidi_ex_t *readmidi;
  resample_ex_t *resample;
  timidity_ex_t *timidity;
  output_ex_t *output;
  aq_ex_t *aq;
  controls_ex_t *controls;
  int state;	
  rtsyn_mutex_t busy;                   
					/* Indicates, whether the audio thread is currently running. 
					 * Note: This simple scheme does -not- provide 100 % protection against
					 * thread problems, for example from MIDI thread and shell thread
					 */
};

#endif  /* __TIMIDITY_SYNTH_H */

/*
 * ladcca stuff
 */
#ifdef HAVE_LADCCA
#include <ladcca/ladcca.h>
extern cca_client_t * cca_client;
#endif
