/* FluidSynth - A Software Synthesiz
 *
 * Copyright (C) 2003  Peter Hanappe and others.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *  
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307, USA
 */

/*for timidity guha */
#include "timidity.h"
#include "common.h"
#include "controls.h"
#include "instrum.h"
#include "playmidi.h"
#include "rtsyn.h"

HANDLE hThread=NULL;
static DWORD dwThreadId;

#include "timidity_dll.h"
#include "timidity_synth.h"
//#include "tmdy_sys.h"
//#include "tmdy_chan.h"
//#include "tmdy_tuning.h"
//#include "tmdy_settings.h"
//#include "tmdy_sfont.h"


//tmdy_sfloader_t* new_tmdy_defsfloader(void);

/***************************************************************
 *
 *                         GLOBAL
 */

/* has the synth module been initialized? */
static int tmdy_synth_initialized = 0;        
static void tmdy_synth_init(void);



/* default modulators
 * SF2.01 page 52 ff:
 *
 * There is a set of predefined default modulators. They have to be
 * explicitly overridden by the sound font in order to turn them off.  
 *
 


/***************************************************************
 *
 *               INITIALIZATION & UTILITIES
 */

/*
void tmdy_synth_settings(tmdy_settings_t* settings)
{
  tmdy_settings_register_str(settings, "synth.verbose", "no", 0, NULL, NULL);
  tmdy_settings_register_str(settings, "synth.dump", "no", 0, NULL, NULL);
  tmdy_settings_register_str(settings, "synth.reverb.active", "yes", 0, NULL, NULL);
  tmdy_settings_register_str(settings, "synth.chorus.active", "yes", 0, NULL, NULL);
  tmdy_settings_register_str(settings, "synth.ladspa.active", "no", 0, NULL, NULL);

  tmdy_settings_register_int(settings, "synth.polyphony", 
			     256, 16, 4096, 0, NULL, NULL);
  tmdy_settings_register_int(settings, "synth.midi-channels", 
			     16, 16, 256, 0, NULL, NULL);
  tmdy_settings_register_num(settings, "synth.gain", 
			     0.2f, 0.0f, 10.0f, 
			     0, NULL, NULL);
  tmdy_settings_register_int(settings, "synth.audio-channels", 
			     1, 1, 256, 0, NULL, NULL);
  tmdy_settings_register_int(settings, "synth.audio-groups", 
			     1, 1, 256, 0, NULL, NULL);
  tmdy_settings_register_int(settings, "synth.effects-channels", 
			     2, 2, 2, 0, NULL, NULL);
  tmdy_settings_register_num(settings, "synth.sample-rate", 
			     44100.0f, 22050.0f, 96000.0f, 
			     0, NULL, NULL);
}
*/
/*
 * tmdy_version
 */
void tmdy_version(int *major, int *minor, int *micro)
{
  char s_buf[]=PACKAGE_VERSION;
  char *cbuf2;
  if(0!=sscanf(s_buf,"%d,%d.%d-%s",major,minor,micro,cbuf2)) return;
  if(0!=sscanf(s_buf,"%d.%d.%d",major,minor,micro) )return;
  *major = 0;
  *minor = 0;
  *micro = 0;
  return;
}

/*
 * tmdy_version_str
 */
char* tmdy_version_str(void)
{
  return PACKAGE_VERSION;
}


/*
 * void tmdy_synth_init
 *
 * Does all the initialization for this module.
 */
static void 
tmdy_synth_init()
{
  tmdy_synth_initialized++;

/*							guha
  tmdy_conversion_config();

  tmdy_voice_config();

  tmdy_sys_config();
*/
/*
  /* SF2.01 page 53 section 8.4.1: MIDI Note-On Velocity to Initial Attenuation *
  tmdy_mod_set_source1(&default_vel2att_mod, /* The modulator we are programming here *
		       TIMIDITY_MOD_VELOCITY,    * Source. VELOCITY corresponds to 'index=2'. *
		       TIMIDITY_MOD_GC           * Not a MIDI continuous controller *
		       | TIMIDITY_MOD_CONCAVE    * Curve shape. Corresponds to 'type=1' * 
		       | TIMIDITY_MOD_UNIPOLAR   * Polarity. Corresponds to 'P=0' *
		       | TIMIDITY_MOD_NEGATIVE   * Direction. Corresponds to 'D=1' *
		       );
  tmdy_mod_set_source2(&default_vel2att_mod, 0, 0); * No 2nd source *
  tmdy_mod_set_dest(&default_vel2att_mod, GEN_ATTENUATION);  * Target: Initial attenuation *
  tmdy_mod_set_amount(&default_vel2att_mod, 960.0);          * Modulation amount: 960 *



  * SF2.01 page 53 section 8.4.2: MIDI Note-On Velocity to Filter Cutoff 
   * Have to make a design decision here. The specs don't make any sense this way or another.
   * One sound font, 'Kingston Piano', which has been praised for its quality, tries to
   * override this modulator with an amount of 0 and positive polarity (instead of what 
   * the specs say, D=1) for the secondary source.
   * So if we change the polarity to 'positive', one of the best free sound fonts works...
   *
  tmdy_mod_set_source1(&default_vel2filter_mod, TIMIDITY_MOD_VELOCITY, * Index=2 *
		       TIMIDITY_MOD_GC                        * CC=0 *
		       | TIMIDITY_MOD_LINEAR                  * type=0 *
		       | TIMIDITY_MOD_UNIPOLAR                * P=0 *
                       | TIMIDITY_MOD_NEGATIVE                * D=1 *
		       );
  tmdy_mod_set_source2(&default_vel2filter_mod, TIMIDITY_MOD_VELOCITY, * Index=2 *
		       TIMIDITY_MOD_GC                                 * CC=0 *
		       | TIMIDITY_MOD_SWITCH                           * type=3 *
		       | TIMIDITY_MOD_UNIPOLAR                         * P=0 *
		       // do not remove       | TIMIDITY_MOD_NEGATIVE                         * D=1 *
		       | TIMIDITY_MOD_POSITIVE                         * D=0 *
		       );
  tmdy_mod_set_dest(&default_vel2filter_mod, GEN_FILTERFC);        * Target: Initial filter cutoff *
  tmdy_mod_set_amount(&default_vel2filter_mod, -2400);



  * SF2.01 page 53 section 8.4.3: MIDI Channel pressure to Vibrato LFO pitch depth *
  tmdy_mod_set_source1(&default_at2viblfo_mod, TIMIDITY_MOD_CHANNELPRESSURE, * Index=13 *
		       TIMIDITY_MOD_GC                        * CC=0 *
		       | TIMIDITY_MOD_LINEAR                  * type=0 *
		       | TIMIDITY_MOD_UNIPOLAR                * P=0 *
		       | TIMIDITY_MOD_POSITIVE                * D=0 *
		       );
  tmdy_mod_set_source2(&default_at2viblfo_mod, 0,0); * no second source *
  tmdy_mod_set_dest(&default_at2viblfo_mod, GEN_VIBLFOTOPITCH);        * Target: Vib. LFO => pitch *
  tmdy_mod_set_amount(&default_at2viblfo_mod, 50);



  * SF2.01 page 53 section 8.4.4: Mod wheel (Controller 1) to Vibrato LFO pitch depth *
  tmdy_mod_set_source1(&default_mod2viblfo_mod, 1, * Index=1 *
		       TIMIDITY_MOD_CC                        * CC=1 *
		       | TIMIDITY_MOD_LINEAR                  * type=0 *
		       | TIMIDITY_MOD_UNIPOLAR                * P=0 *
		       | TIMIDITY_MOD_POSITIVE                * D=0 *
		       );
  tmdy_mod_set_source2(&default_mod2viblfo_mod, 0,0); * no second source *
  tmdy_mod_set_dest(&default_mod2viblfo_mod, GEN_VIBLFOTOPITCH);        * Target: Vib. LFO => pitch *
  tmdy_mod_set_amount(&default_mod2viblfo_mod, 50);



  * SF2.01 page 55 section 8.4.5: MIDI continuous controller 7 to initial attenuation*
  tmdy_mod_set_source1(&default_att_mod, 7,                     * index=7 * 
		       TIMIDITY_MOD_CC                              * CC=1 * 
		       | TIMIDITY_MOD_CONCAVE                       * type=1 * 
		       | TIMIDITY_MOD_UNIPOLAR                      * P=0 *
		       | TIMIDITY_MOD_NEGATIVE                      * D=1 *
		       );
  tmdy_mod_set_source2(&default_att_mod, 0, 0);                 * No second source *
  tmdy_mod_set_dest(&default_att_mod, GEN_ATTENUATION);         * Target: Initial attenuation *
  tmdy_mod_set_amount(&default_att_mod, 960.0);                 * Amount: 960 *



  * SF2.01 page 55 section 8.4.6 MIDI continuous controller 10 to Pan Position *
  tmdy_mod_set_source1(&default_pan_mod, 10,                    * index=10 *
		       TIMIDITY_MOD_CC                              * CC=1 *
		       | TIMIDITY_MOD_LINEAR                        * type=0 * 
		       | TIMIDITY_MOD_BIPOLAR                       * P=1 * 
		       | TIMIDITY_MOD_POSITIVE                      * D=0 *
		       );
  tmdy_mod_set_source2(&default_pan_mod, 0, 0);                 * No second source *
  tmdy_mod_set_dest(&default_pan_mod, GEN_PAN);                 * Target: pan *
  * Amount: 500. The SF specs $8.4.6, p. 55 syas: "Amount = 1000
     tenths of a percent". The center value (64) corresponds to 50%,
     so it follows that amount = 50% x 1000/% = 500. *
  tmdy_mod_set_amount(&default_pan_mod, 500.0);                 


  * SF2.01 page 55 section 8.4.7: MIDI continuous controller 11 to initial attenuation*
  tmdy_mod_set_source1(&default_expr_mod, 11,                     * index=11 * 
		       TIMIDITY_MOD_CC                              * CC=1 * 
		       | TIMIDITY_MOD_CONCAVE                       * type=1 * 
		       | TIMIDITY_MOD_UNIPOLAR                      * P=0 *
		       | TIMIDITY_MOD_NEGATIVE                      * D=1 *
		       );
  tmdy_mod_set_source2(&default_expr_mod, 0, 0);                 * No second source *
  tmdy_mod_set_dest(&default_expr_mod, GEN_ATTENUATION);         * Target: Initial attenuation *
  tmdy_mod_set_amount(&default_expr_mod, 960.0);                 * Amount: 960 *



  * SF2.01 page 55 section 8.4.8: MIDI continuous controller 91 to Reverb send *
  tmdy_mod_set_source1(&default_reverb_mod, 91,                 * index=91 * 
		       TIMIDITY_MOD_CC                              * CC=1 * 
		       | TIMIDITY_MOD_LINEAR                        * type=0 * 
		       | TIMIDITY_MOD_UNIPOLAR                      * P=0 *
		       | TIMIDITY_MOD_POSITIVE                      * D=0 *
		       );
  tmdy_mod_set_source2(&default_reverb_mod, 0, 0);              * No second source *
  tmdy_mod_set_dest(&default_reverb_mod, GEN_REVERBSEND);       * Target: Reverb send *
  tmdy_mod_set_amount(&default_reverb_mod, 200);                * Amount: 200 ('tenths of a percent') *



  * SF2.01 page 55 section 8.4.9: MIDI continuous controller 93 to Reverb send *
  tmdy_mod_set_source1(&default_chorus_mod, 93,                 * index=93 * 
		       TIMIDITY_MOD_CC                              * CC=1 * 
		       | TIMIDITY_MOD_LINEAR                        * type=0 * 
		       | TIMIDITY_MOD_UNIPOLAR                      * P=0 *
		       | TIMIDITY_MOD_POSITIVE                      * D=0 *
		       );
  tmdy_mod_set_source2(&default_chorus_mod, 0, 0);              * No second source *
  tmdy_mod_set_dest(&default_chorus_mod, GEN_CHORUSSEND);       * Target: Chorus *
  tmdy_mod_set_amount(&default_chorus_mod, 200);                * Amount: 200 ('tenths of a percent') *



  * SF2.01 page 57 section 8.4.10 MIDI Pitch Wheel to Initial Pitch ... *
  tmdy_mod_set_source1(&default_pitch_bend_mod, TIMIDITY_MOD_PITCHWHEEL, * Index=14 * 
		       TIMIDITY_MOD_GC                              * CC =0 *
		       | TIMIDITY_MOD_LINEAR                        * type=0 *
		       | TIMIDITY_MOD_BIPOLAR                       * P=1 * 
		       | TIMIDITY_MOD_POSITIVE                      * D=0 *
		       );
  tmdy_mod_set_source2(&default_pitch_bend_mod, TIMIDITY_MOD_PITCHWHEELSENS,  * Index = 16 *
		       TIMIDITY_MOD_GC                                        * CC=0 *
		       | TIMIDITY_MOD_LINEAR                                  * type=0 *
		       | TIMIDITY_MOD_UNIPOLAR                                * P=0 *
		       | TIMIDITY_MOD_POSITIVE                                * D=0 *
		       );     
  tmdy_mod_set_dest(&default_pitch_bend_mod, GEN_PITCH);                 * Destination: Initial pitch *
  tmdy_mod_set_amount(&default_pitch_bend_mod, 12700.0);                 * Amount: 12700 cents */
}

/*
int tmdy_synth_verify_settings(tmdy_settings_t *settings)
{
  return 0;
}
*/
/* timidity thread callback guha*/
DWORD WINAPI ThreadProc1(LPVOID synth)
{
	int i;
   char *argv[16];
	char opt_interface[8];
	char opt_rate[32];
	int argc;
	DWORD	ExitCode;
	
/*	rtsyn_ex=((tmdy_synth_t*)synth)->rtsyn;
	rtsyn_mutex_init( *(((tmdy_synth_t*)synth)->rtsyn->busy_p) );
	rtsyn_mutex_lock( *(((tmdy_synth_t*)synth)->rtsyn->busy_p) );

	instrum_ex=((tmdy_synth_t*)synth)->instrum;
	playmidi_ex=((tmdy_synth_t*)synth)->playmidi;
	readmidi_ex=((tmdy_synth_t*)synth)->readmidi;
	resample_ex=((tmdy_synth_t*)synth)->resample;
	timidity_ex=((tmdy_synth_t*)synth)->timidity;
	output_ex=((tmdy_synth_t*)synth)->output;
	aq_ex=((tmdy_synth_t*)synth)->aq;
	controls_ex=((tmdy_synth_t*)synth)->controls;
*/
	
    argc=0;
	argv[argc++] = "timidity";
	argv[argc++] = "-Od";
	argv[argc++] = "-ip";
	argv[argc++] = "rt";
//    argv[argc++] = "1";
//    argv[argc++] = "2";	
 	argv[argc] = NULL;

    // change to the configuration directory 
	timiditymain(argc, argv);

    GetExitCodeThread(hThread,&ExitCode);
	ExitThread(ExitCode);
}
DWORD WINAPI ThreadProc2(LPVOID synth)
{
	int i;
   char *argv[16];
	char opt_interface[8];
	char opt_rate[32];
	int argc;
	char *filename;
	DWORD	ExitCode;
	
/*	rtsyn_ex=((tmdy_synth_t*)synth)->rtsyn;

	instrum_ex=((tmdy_synth_t*)synth)->instrum;
	playmidi_ex=((tmdy_synth_t*)synth)->playmidi;
	readmidi_ex=((tmdy_synth_t*)synth)->readmidi;
	resample_ex=((tmdy_synth_t*)synth)->resample;
	timidity_ex=((tmdy_synth_t*)synth)->timidity;
	output_ex=((tmdy_synth_t*)synth)->output;
	aq_ex=((tmdy_synth_t*)synth)->aq;
	controls_ex=((tmdy_synth_t*)synth)->controls;
*/	
	filename = ((tmdy_synth_t*)synth)->rtsyn->filename;
	
    argc=0;
	argv[argc++] = "timidity";
	argv[argc++] = "-Od";
	argv[argc++] = "-ip";
	argv[argc++] = "dumb";
    argv[argc++] = filename;
	argv[argc] = NULL;

    // change to the configuration directory 
	timiditymain(argc, argv);

    GetExitCodeThread(hThread,&ExitCode);
	ExitThread(ExitCode);
}
 	
/***************************************************************
 *
 *                      TIMIDITY SYNTH
 *
 *
 * new_tmdy_synth
 */

tmdy_synth_t*
new_tmdy_synth_inside(int retaltime_f, char *filename);
		
tmdy_synth_t* 
new_tmdy_synth(){
	int realteime_f;
	return new_tmdy_synth_inside(1,NULL);
}

tmdy_synth_t* 
new_tmdy_synth_file(char * filename){
	int realteime_f;
	return new_tmdy_synth_inside(0,filename);
}

tmdy_synth_t* 
new_tmdy_synth_inside(int realtime_f, char *filename)
{
  int i;
  tmdy_synth_t* synth;
//  tmdy_sfloader_t* loader;
	
	/* initialize all the conversion tables and other stuff */
  if (tmdy_synth_initialized == 0) {
    tmdy_synth_init();
  }

//  tmdy_synth_verify_settings(settings);

  /* allocate a new synthesizer object */
  synth = TIMIDITY_NEW(tmdy_synth_t);
  if (synth == NULL) {
//    TIMIDITY_LOG(TIMIDITY_ERR, "Out of memory"); //guha 
    return NULL;
  }
  TIMIDITY_MEMSET(synth, 0, sizeof(tmdy_synth_t));
  
  rtsyn_mutex_init(synth->busy);

//  synth->settings = settings;
/*
  synth->with_reverb = tmdy_settings_str_equal(settings, "synth.reverb.active", "yes");
  synth->with_chorus = tmdy_settings_str_equal(settings, "synth.chorus.active", "yes");
  synth->verbose = tmdy_settings_str_equal(settings, "synth.verbose", "yes");
  synth->dump = tmdy_settings_str_equal(settings, "synth.dump", "yes");

  tmdy_settings_getint(settings, "synth.polyphony", &synth->polyphony);
  tmdy_settings_getnum(settings, "synth.sample-rate", &synth->sample_rate);
  tmdy_settings_getint(settings, "synth.midi-channels", &synth->midi_channels);
  tmdy_settings_getint(settings, "synth.audio-channels", &synth->audio_channels);
  tmdy_settings_getint(settings, "synth.audio-groups", &synth->audio_groups);
  tmdy_settings_getint(settings, "synth.effects-channels", &synth->effects_channels);
  tmdy_settings_getnum(settings, "synth.gain", &synth->gain);

  * register the callbacks *
  tmdy_settings_register_num(settings, "synth.gain", 
			      0.2f, 0.0f, 10.0f, 0, 
			      (tmdy_num_update_t) tmdy_synth_update_gain, synth);

  * do some basic sanity checking on the settings *
  if (synth->midi_channels < 16) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Requested number of MIDI channels is smaller than 16. " 
	     "Changing this setting to 16."); 
    synth->midi_channels = 16;
  } else if (synth->midi_channels > 1024) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Requested number of MIDI channels is too big (%d). " 
	     "Limiting this setting to 1024.", synth->midi_channels); 
    synth->midi_channels = 1024;
  }

  if (synth->audio_channels < 1) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Requested number of audio channels is smaller than 1. " 
	     "Changing this setting to 1."); 
    synth->audio_channels = 1;
  } else if (synth->audio_channels > 128) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Requested number of audio channels is too big (%d). " 
	     "Limiting this setting to 128.", synth->audio_channels); 
    synth->audio_channels = 128;
  }

  if (synth->audio_groups < 1) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Requested number of audio groups is smaller than 1. " 
	     "Changing this setting to 1."); 
    synth->audio_groups = 1;
  } else if (synth->audio_groups > 128) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Requested number of audio groups is too big (%d). " 
	     "Limiting this setting to 128.", synth->audio_groups); 
    synth->audio_groups = 128;
  }

  if (synth->effects_channels != 2) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Invalid number of effects channels (%d)."
	     "Setting effects channels to 2.", synth->effects_channels);
    synth->effects_channels = 2;
  }
*/

  /* The number of buffers is determined by the higher number of nr
   * groups / nr audio channels.  If LADSPA is unused, they should be
   * the same. *
  synth->nbuf = synth->audio_channels;
  if (synth->audio_groups > synth->nbuf) {
    synth->nbuf = synth->audio_groups;
  }

#ifdef LADSPA
  * Create and initialize the Fx unit.*
  synth->LADSPA_FxUnit = new_tmdy_LADSPA_FxUnit(synth);
#endif
  
  /* as soon as the synth is created it starts playing. */
  synth->state = TIMIDITY_SYNTH_PLAYING;
/*  synth->sfont = NULL;
  synth->noteid = 0;
  synth->ticks = 0;
  synth->tuning = NULL;
*/
  /* allocate and add the default sfont loader *
  loader = new_tmdy_defsfloader();

  if (loader == NULL) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Failed to create the default SoundFont loader"); 
  } else {
    tmdy_synth_add_sfloader(synth, loader);
  }

  * allocate all channel objects *
  synth->channel = TIMIDITY_ARRAY(tmdy_channel_t*, synth->midi_channels);
  if (synth->channel == NULL) {
    TIMIDITY_LOG(TIMIDITY_ERR, "Out of memory"); 
    goto error_recovery;
  }
  for (i = 0; i < synth->midi_channels; i++) {
    synth->channel[i] = new_tmdy_channel(synth, i);
    if (synth->channel[i] == NULL) {
      goto error_recovery;
    }
  }

  * allocate all synthesis processes *
  synth->nvoice = synth->polyphony;
  synth->voice = TIMIDITY_ARRAY(tmdy_voice_t*, synth->nvoice);
  if (synth->voice == NULL) {
    goto error_recovery;
  }
  for (i = 0; i < synth->nvoice; i++) {
    synth->voice[i] = new_tmdy_voice(synth->sample_rate);
    if (synth->voice[i] == NULL) {
      goto error_recovery;
    }
  }

  * Allocate the sample buffers 
   *
   * GCC seems to have a bug with alignment (address must be multiple
   * of 16 bytes.  So we have to align for ourselves...  As soon as
   * GCC aligns reliably, this mess can be cleaned up.
   */
/*
  synth->left_buf = NULL;
  synth->right_buf = NULL;
  synth->left_ubuf = NULL;
  synth->right_ubuf = NULL;
  synth->fx_left_buf = NULL;
  synth->fx_right_buf = NULL;
  synth->fx_left_ubuf = NULL;
  synth->fx_right_ubuf = NULL;

  * Left and right audio buffers *

  synth->left_buf = TIMIDITY_ARRAY(tmdy_real_t*, synth->nbuf);
  synth->right_buf = TIMIDITY_ARRAY(tmdy_real_t*, synth->nbuf);
  synth->left_ubuf = TIMIDITY_ARRAY(tmdy_real_t*, synth->nbuf);
  synth->right_ubuf = TIMIDITY_ARRAY(tmdy_real_t*, synth->nbuf);

  if ((synth->left_buf == NULL) || (synth->right_buf == NULL) ||
      (synth->left_ubuf == NULL) || (synth->right_ubuf == NULL)) {
    TIMIDITY_LOG(TIMIDITY_ERR, "Out of memory"); 
    goto error_recovery;
  } 

  TIMIDITY_MEMSET(synth->left_buf, 0, synth->nbuf * sizeof(tmdy_real_t*));
  TIMIDITY_MEMSET(synth->right_buf, 0, synth->nbuf * sizeof(tmdy_real_t*));
  TIMIDITY_MEMSET(synth->left_ubuf, 0, synth->nbuf * sizeof(tmdy_real_t*));
  TIMIDITY_MEMSET(synth->right_ubuf, 0, synth->nbuf * sizeof(tmdy_real_t*));

  for (i = 0; i < synth->nbuf; i++) {

    * +4: add four floats for 16 added bytes *

    synth->left_ubuf[i] = TIMIDITY_ARRAY(tmdy_real_t, TIMIDITY_BUFSIZE + 4);  
    synth->right_ubuf[i] = TIMIDITY_ARRAY(tmdy_real_t, TIMIDITY_BUFSIZE + 4);

    if ((synth->left_ubuf[i] == NULL) || (synth->right_ubuf[i] == NULL)) {
      TIMIDITY_LOG(TIMIDITY_ERR, "Out of memory"); 
      goto error_recovery;
    } 

    synth->left_buf[i] = (tmdy_real_t*) TIMIDITY_ALIGN16BYTE(synth->left_ubuf[i]);
    synth->right_buf[i] = (tmdy_real_t*) TIMIDITY_ALIGN16BYTE(synth->right_ubuf[i]);
  }

  * Effects audio buffers *

  synth->fx_left_buf = TIMIDITY_ARRAY(tmdy_real_t*, synth->effects_channels);
  synth->fx_right_buf = TIMIDITY_ARRAY(tmdy_real_t*, synth->effects_channels);
  synth->fx_left_ubuf = TIMIDITY_ARRAY(tmdy_real_t*, synth->effects_channels);
  synth->fx_right_ubuf = TIMIDITY_ARRAY(tmdy_real_t*, synth->effects_channels);

  if ((synth->fx_left_buf == NULL) || (synth->fx_left_ubuf == NULL) ||
      (synth->fx_right_buf == NULL) || (synth->fx_right_ubuf == NULL)) {
    TIMIDITY_LOG(TIMIDITY_ERR, "Out of memory"); 
    goto error_recovery;
  } 

  TIMIDITY_MEMSET(synth->fx_left_ubuf, 0, 2 * sizeof(tmdy_real_t*));
  TIMIDITY_MEMSET(synth->fx_left_buf, 0, 2 * sizeof(tmdy_real_t*));
  TIMIDITY_MEMSET(synth->fx_right_ubuf, 0, 2 * sizeof(tmdy_real_t*));
  TIMIDITY_MEMSET(synth->fx_right_buf, 0, 2 * sizeof(tmdy_real_t*));

  for (i = 0; i < synth->effects_channels; i++) {

    * +4: add four floats for 16 added bytes *
    synth->fx_left_ubuf[i] = TIMIDITY_ARRAY(tmdy_real_t, TIMIDITY_BUFSIZE + 4);  
    synth->fx_right_ubuf[i] = TIMIDITY_ARRAY(tmdy_real_t, TIMIDITY_BUFSIZE + 4);  

    if ((synth->fx_left_ubuf[i] == NULL) || (synth->fx_right_ubuf[i] == NULL)) {
      TIMIDITY_LOG(TIMIDITY_ERR, "Out of memory"); 
      goto error_recovery;
    } 

    synth->fx_left_buf[i] = (tmdy_real_t*) TIMIDITY_ALIGN16BYTE(synth->fx_left_ubuf[i]);
    synth->fx_right_buf[i] = (tmdy_real_t*) TIMIDITY_ALIGN16BYTE(synth->fx_right_ubuf[i]);
  }


  synth->cur = TIMIDITY_BUFSIZE;

  /* allocate the reverb module *
  synth->reverb = new_tmdy_revmodel();
  if (synth->reverb == NULL) {
    TIMIDITY_LOG(TIMIDITY_ERR, "Out of memory"); 
    goto error_recovery;
  }

  tmdy_synth_set_reverb(synth, 
			TIMIDITY_REVERB_DEFAULT_ROOMSIZE, 
			TIMIDITY_REVERB_DEFAULT_DAMP, 
			TIMIDITY_REVERB_DEFAULT_WIDTH, 
			TIMIDITY_REVERB_DEFAULT_LEVEL);

  * allocate the chorus module *
  synth->chorus = new_tmdy_chorus(synth->sample_rate);
  if (synth->chorus == NULL) {
    TIMIDITY_LOG(TIMIDITY_ERR, "Out of memory"); 
    goto error_recovery;
  }

  * FIXME */
//  synth->start = tmdy_curtime();



/*timidity sutart routine guha */
   	if(hThread !=NULL){
//   		TIMIDITY_LOG(TIMIDITY_ERR, "Thread is already running.");  guha
   		goto error_recovery;
   	}
	synth->rtsyn=new_rtsyn();
   	synth->instrum=new_instrum();
   	synth->playmidi=new_playmidi();
   	synth->readmidi=new_readmidi();
   	synth->resample=new_resample();
   	synth->timidity=new_timidity();
   	synth->output=new_output();
   	synth->aq=new_aq();
   	synth->controls=new_controls();
   	
	if(realtime_f==1){
  		hThread=CreateThread(NULL,0,ThreadProc1,(LPVOID)(synth),0,&(dwThreadId));
	}else{
		synth->rtsyn->filename=filename;
		hThread=CreateThread(NULL,0,ThreadProc2,(LPVOID)(synth),0,&(dwThreadId));
	}
	if(hThread==NULL){
//		TIMIDITY_LOG(TIMIDITY_ERR, "Can't craate timidity thread."); //guha
		goto error_recovery;
  }

  return synth;

 error_recovery:
   	delete_tmdy_synth(synth);
  return NULL;
}

/*
 * delete_tmdy_synth
 */
int 
delete_tmdy_synth(tmdy_synth_t* synth) 
{
  int i, k;
//  tmdy_list_t *list;
//  tmdy_sfont_t* sfont;
//  tmdy_sfloader_t* loader;

/* for timidity guha */
  if(hThread !=NULL){
  	DWORD ExitCode;
	GetExitCodeThread(hThread, &ExitCode);
	TerminateThread(hThread, ExitCode); 
  	WaitForSingleObject(hThread, INFINITE);
	CloseHandle(hThread);
	hThread=NULL;
  }

  if (synth == NULL) {
    return TIMIDITY_OK;
  }

//  tmdy_profiling_print();

  synth->state = TIMIDITY_SYNTH_STOPPED;

  /* delete all the SoundFonts */
/*  
  for (list = synth->sfont; list; list = tmdy_list_next(list)) {
    sfont = (tmdy_sfont_t*) tmdy_list_get(list);
    delete_tmdy_sfont(sfont);
  }

  delete_tmdy_list(synth->sfont);
*/
  /* delete all the SoundFont loaders */
/*  
  for (list = synth->loaders; list; list = tmdy_list_next(list)) {
    loader = (tmdy_sfloader_t*) tmdy_list_get(list);
    tmdy_sfloader_delete(loader);
  }

  delete_tmdy_list(synth->loaders);
*/
/*
  if (synth->channel != NULL) {
    for (i = 0; i < synth->midi_channels; i++) {
      if (synth->channel[i] != NULL) {
	delete_tmdy_channel(synth->channel[i]);
      }
    }
    TIMIDITY_FREE(synth->channel);
  }
  if (synth->voice != NULL) {
    for (i = 0; i < synth->nvoice; i++) {
      if (synth->voice[i] != NULL) {
	delete_tmdy_voice(synth->voice[i]);
      }
    }
    TIMIDITY_FREE(synth->voice);
  }
*/
  /* free all the sample buffers *
  if (synth->left_ubuf != NULL) {
    for (i = 0; i < synth->nbuf; i++) {
      if (synth->left_ubuf[i] != NULL) {
	TIMIDITY_FREE(synth->left_ubuf[i]);
      }
    }
    TIMIDITY_FREE(synth->left_ubuf);
  }
  if (synth->right_ubuf != NULL) {
    for (i = 0; i < synth->nbuf; i++) {
      if (synth->right_ubuf[i] != NULL) {
	TIMIDITY_FREE(synth->right_ubuf[i]);
      }
    }
    TIMIDITY_FREE(synth->right_ubuf);
  }
  if (synth->fx_left_ubuf != NULL) {
    for (i = 0; i < 2; i++) {
      if (synth->fx_left_ubuf[i] != NULL) {
	TIMIDITY_FREE(synth->fx_left_ubuf[i]);
      }
    }
    TIMIDITY_FREE(synth->fx_left_ubuf);
  }

  * release the reverb module *
  if (synth->reverb != NULL) {
    delete_tmdy_revmodel(synth->reverb);  guha
  }

  * release the chorus module *
  if (synth->chorus != NULL) {
  	delete_tmdy_chorus(synth->chorus);  guna
  }

  * free the tunings, if any *
  if (synth->tuning != NULL) {
    for (i = 0; i < 128; i++) {
      if (synth->tuning[i] != NULL) {
	for (k = 0; k < 128; k++) {
	  if (synth->tuning[i][k] != NULL) {
	    TIMIDITY_FREE(synth->tuning[i][k]);
	  }
	}
	TIMIDITY_FREE(synth->tuning[i]);
      }
    }
    TIMIDITY_FREE(synth->tuning);
  }

#ifdef LADSPA
  /* Release the LADSPA Fx unit *
  tmdy_LADSPA_shutdown(synth->LADSPA_FxUnit);
  TIMIDITY_FREE(synth->LADSPA_FxUnit);
#endif
*/
  destroy_rtsyn(synth->rtsyn);   //guha
  destroy_instrum(synth->instrum);
  destroy_playmidi(synth->playmidi);
  destroy_readmidi(synth->readmidi);
  destroy_resample(synth->resample);
  destroy_timidity(synth->timidity);
  destroy_output(synth->output);
  destroy_aq(synth->aq);
  destroy_controls(synth->controls);
	
  rtsyn_mutex_destroy(synth->busy);  
  TIMIDITY_FREE(synth);

  return TIMIDITY_OK;
}

/*
 * tmdy_synth_error
 *
 * The error messages are not thread-save, yet. They are still stored
 * in a global message buffer (see tmdy_sys.c).
 */
/*
char*
tmdy_synth_error(tmdy_synth_t* synth)
{
  return tmdy_error();
}
*/
/*
 * tmdy_synth_noteon
 */
int 
tmdy_synth_noteon(tmdy_synth_t* synth, int chan, int key, int vel) 
{
MidiEvent ev;
  if (vel == 0) {
    return tmdy_synth_noteoff(synth, chan, key);
  }

ev.type = ME_NOTEON;
ev.channel = chan;
ev.a = key;
ev.b = vel;
synth->rtsyn->rtsyn_play_event(&ev);
return TIMIDITY_OK;
}
/*
 * tmdy_synth_noteoff
 */
int 
tmdy_synth_noteoff(tmdy_synth_t* synth, int chan, int key)
{
MidiEvent ev;

ev.type = ME_NOTEOFF;
ev.channel = chan;
ev.a = key;
ev.b = 0;
synth->rtsyn->rtsyn_play_event(&ev);
return TIMIDITY_OK;
}
/*
 * tmdy_synth_damp_voices
 *
int 
tmdy_synth_damp_voices(tmdy_synth_t* synth, int chan)
{
  int i;
  tmdy_voice_t* voice;

  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);
  for (i = 0; i < synth->nvoice; i++) {
    voice = synth->voice[i];
    if ((voice->chan == chan) && _SUSTAINED(voice)) {
*        printf("turned off sustained note: chan=%d, key=%d, vel=%d\n", voice->chan, voice->key, voice->vel); *
      tmdy_voice_noteoff(voice);
    }
  }

  return TIMIDITY_OK;
}
*/
/*
 * tmdy_synth_cc
 */
int 
tmdy_synth_cc(tmdy_synth_t* synth, int chan, int num, int val)
{
  MidiEvent ev;

  ev.channel = chan;
  ev.a = num;
  ev.b = val;
  ev.type = ME_NONE;  
  if (! convert_midi_control_change(ev.channel, ev.a, ev.b, &ev))
	ev.type = ME_NONE;	
  synth->rtsyn->rtsyn_play_event(&ev);

 return TIMIDITY_OK;
}
/*
 * tmdy_synth_get_cc
 *
int
tmdy_synth_get_cc(tmdy_synth_t* synth, int chan, int num, int* pval)
{
  * check the ranges of the arguments *
  if ((chan < 0) || (chan >= synth->midi_channels)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Channel out of range");
    return TIMIDITY_FAILED;     
  }
  if ((num < 0) || (num >= 128)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Ctrl out of range");
    return TIMIDITY_FAILED;     
  }
  
  *pval = synth->channel[chan]->cc[num];
  return TIMIDITY_OK;
}
*/
/*
 * tmdy_synth_all_notes_off
 *
 * put all notes on this channel into released state.
 *
int
tmdy_synth_all_notes_off(tmdy_synth_t* synth, int chan)
{
  int i;
  tmdy_voice_t* voice;

  for (i = 0; i < synth->nvoice; i++) {
    voice = synth->voice[i];
    if (_PLAYING(voice) && (voice->chan == chan)) {
      tmdy_voice_noteoff(voice);
    }
  }
  return TIMIDITY_OK;
}
*/
/*
 * tmdy_synth_all_sounds_off
 *
 * put all notes on this channel into released state.
 *
int
tmdy_synth_all_sounds_off(tmdy_synth_t* synth, int chan)
{
  int i;
  tmdy_voice_t* voice;

  for (i = 0; i < synth->nvoice; i++) {
    voice = synth->voice[i];
    if (_PLAYING(voice) && (voice->chan == chan)) {
      tmdy_voice_off(voice);
    }
  }
  return TIMIDITY_OK;
}
*/
/*
 * tmdy_synth_system_reset
 *
 * Purpose: 
 * Respond to the MIDI command 'system reset' (0xFF, big red 'panic' button)
 */
int
tmdy_synth_system_reset(tmdy_synth_t* synth)
{
	MidiEvent ev;
	
	ev.type==ME_RESET;
	ev.a=*(synth->rtsyn->rtsyn_system_mode_p);
	synth->readmidi->change_system_mode(*(synth->rtsyn->rtsyn_system_mode_p));
	synth->rtsyn->rtsyn_play_event(&ev);
	
}
/*
 * tmdy_synth_modulate_voices
 *
 * tell all synthesis processes on this channel to update their
 * synthesis parameters after a control change.
 *
int 
tmdy_synth_modulate_voices(tmdy_synth_t* synth, int chan, int is_cc, int ctrl)
{
  int i;
  tmdy_voice_t* voice;

  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);
  for (i = 0; i < synth->nvoice; i++) {
    voice = synth->voice[i];
    if (voice->chan == chan) {
      tmdy_voice_modulate(voice, is_cc, ctrl);
    }
  }
  return TIMIDITY_OK;
}
*/
/*
 * tmdy_synth_modulate_voices_all
 *
 * Tell all synthesis processes on this channel to update their
 * synthesis parameters after an all control off message (i.e. all
 * controller have been reset to their default value).
 *
int 
tmdy_synth_modulate_voices_all(tmdy_synth_t* synth, int chan)
{
  int i;
  tmdy_voice_t* voice;
  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);

  for (i = 0; i < synth->nvoice; i++) {
    voice = synth->voice[i];
    if (voice->chan == chan) {
      tmdy_voice_modulate_all(voice);
    }
  }
  return TIMIDITY_OK;
}
*/
/*
 * tmdy_synth_pitch_bend
 */
int 
tmdy_synth_pitch_bend(tmdy_synth_t* synth, int chan, int val)
{
  MidiEvent ev;
  int LSB, MSB;
    LSB=(0x7f & val);
    MSB=(0x7f & (val >>7));
	
  ev.type = ME_PITCHWHEEL;
  ev.channel = chan;
  ev.a = LSB;
  ev.b = MSB;
  synth->rtsyn->rtsyn_play_event(&ev);
return TIMIDITY_OK;
}
/*
 * tmdy_synth_pitch_bend
 */
int
tmdy_synth_get_pitch_bend(tmdy_synth_t* synth, int chan, int* ppitch_bend)
{
  
	*ppitch_bend = (synth->playmidi->channel)[chan].pitchbend;
  return TIMIDITY_OK;
}

/*
 * tmdy_synth_pitch_wheel_sens
 */
int 
tmdy_synth_pitch_wheel_sens(tmdy_synth_t* synth, int chan, int val)
{

	MidiEvent ev;
	int LSB, MSB;

  LSB=(0x7f & val);
  MSB=(0x7f & (val >>7));

  ev.channel = chan;
  ev.a = 0x65;
  ev.b = 0x00;
  ev.type = ME_NONE;  
  if (! convert_midi_control_change(ev.channel, ev.a, ev.b, &ev))
	ev.type = ME_NONE;	
  synth->rtsyn->rtsyn_play_event(&ev);
	
   ev.channel = chan;
  ev.a = 0x64;
  ev.b = 0x00;
  ev.type = ME_NONE;  
  if (! convert_midi_control_change(ev.channel, ev.a, ev.b, &ev))
	ev.type = ME_NONE;	
  synth->rtsyn->rtsyn_play_event(&ev);

  ev.channel = chan;
  ev.a = 0x06;
  ev.b = MSB;
  ev.type = ME_NONE;  
  if (! convert_midi_control_change(ev.channel, ev.a, ev.b, &ev))
	ev.type = ME_NONE;	
  synth->rtsyn->rtsyn_play_event(&ev);

  ev.channel = chan;
  ev.a = 0x26;
  ev.b = LSB;
  ev.type = ME_NONE;  
  if (! convert_midi_control_change(ev.channel, ev.a, ev.b, &ev))
	ev.type = ME_NONE;	
  synth->rtsyn->rtsyn_play_event(&ev);

  return TIMIDITY_OK;
}

/*
 * tmdy_synth_get_pitch_wheel_sens
 *
 * Note : this function was added after version 1.0 API freeze.
 * So its API is not in the synth.h file. It should be added in some later
 * version of fluidsynth. Maybe v2.0 ? -- Antoine Schmitt May 2003
 */
/*******************
int 
tmdy_synth_get_pitch_wheel_sens(tmdy_synth_t* synth, int chan, int* pval)
{
  FLOAT_T pitchfactor;
  pitchfactor=synth->playmidi->channel[chan]->pitchfactor;

  // get the pitch-bend value in the channel
  *pval = synth->channel[chan]->pitch_wheel_sensitivity;

  return TIMIDITY_OK;
}
************/

/*
 * tmdy_synth_get_preset
 *
tmdy_preset_t*
tmdy_synth_get_preset(tmdy_synth_t* synth, unsigned int sfontnum, 
		      unsigned int banknum, unsigned int prognum)
{
  tmdy_preset_t* preset = NULL;
  tmdy_sfont_t* sfont = NULL;
  tmdy_list_t* list = synth->sfont;

  sfont = tmdy_synth_get_sfont_by_id(synth, sfontnum);
  
  if (sfont != NULL) {
    preset = tmdy_sfont_get_preset(sfont, banknum, prognum);
    if (preset != NULL) {
      return preset;
    }
  }
  return NULL;
}

tmdy_preset_t* tmdy_synth_find_preset(tmdy_synth_t* synth, 
				      unsigned int banknum, 
				      unsigned int prognum)
{
  tmdy_preset_t* preset = NULL;
  tmdy_sfont_t* sfont = NULL;
  tmdy_list_t* list = synth->sfont;

  while (list) {

    sfont = (tmdy_sfont_t*) tmdy_list_get(list);
    preset = tmdy_sfont_get_preset(sfont, banknum, prognum);

    if (preset != NULL) {
      preset->sfont = sfont; * FIXME *
      return preset;
    }
    
    list = tmdy_list_next(list);

  }
  return NULL;
}
*/
/*
 * tmdy_synth_program_change
 */
tmdy_synth_program_change(tmdy_synth_t* synth, int chan, int prognum)
{
MidiEvent ev;

ev.type = ME_PROGRAM;
ev.channel = chan;
ev.a = prognum;
ev.b = 0;
synth->rtsyn->rtsyn_play_event(&ev);
return TIMIDITY_OK;
}
/*
 * tmdy_synth_bank_select
 */
int tmdy_synth_bank_select(tmdy_synth_t* synth, int chan, unsigned int bank)
{
	MidiEvent ev;
	int LSB, MSB;

  LSB=(0x7f & bank);
  MSB=(0x7f & (bank >>7));

  ev.channel = chan;
  ev.a = 0x20;
  ev.b = LSB;
  ev.type = ME_NONE;  
  if (! convert_midi_control_change(ev.channel, ev.a, ev.b, &ev))
	ev.type = ME_NONE;	
  synth->rtsyn->rtsyn_play_event(&ev);

  ev.channel = chan;
  ev.a = 0x00;
  ev.b = MSB;
    if (! convert_midi_control_change(ev.channel, ev.a, ev.b, &ev))
	ev.type = ME_NONE;	
  synth->rtsyn->rtsyn_play_event(&ev);

	return TIMIDITY_OK;  //guha
}

/*
 * tmdy_synth_sfont_select
 *
int tmdy_synth_sfont_select(tmdy_synth_t* synth, int chan, unsigned int sfont_id)
{
  if ((chan >= 0) && (chan < synth->midi_channels)) {
    tmdy_channel_set_sfontnum(synth->channel[chan], sfont_id);
    return TIMIDITY_OK;
  }
  return TIMIDITY_FAILED;
}

*
 * tmdy_synth_get_program
 *
int 
tmdy_synth_get_program(tmdy_synth_t* synth, int chan, 
		       unsigned int* sfont_id, unsigned int* bank_num, unsigned int* preset_num)
{
  tmdy_channel_t* channel;
  if ((chan >= 0) && (chan < synth->midi_channels)) {
    channel = synth->channel[chan];
    *sfont_id = tmdy_channel_get_sfontnum(channel);
    *bank_num = tmdy_channel_get_banknum(channel);
    *preset_num = tmdy_channel_get_prognum(channel);
    return TIMIDITY_OK;
  }
  return TIMIDITY_FAILED;
}

*
 * tmdy_synth_program_select
 *
int tmdy_synth_program_select(tmdy_synth_t* synth, 
			      int chan, 
			      unsigned int sfont_id, 
			      unsigned int bank_num, 
			      unsigned int preset_num)
{
  tmdy_preset_t* preset = NULL;
  tmdy_channel_t* channel;

  if ((chan < 0) || (chan >= synth->midi_channels)) {
    TIMIDITY_LOG(TIMIDITY_ERR, "Channel number out of range (chan=%d)", chan);
    return TIMIDITY_FAILED;
  }
  channel = synth->channel[chan];

  preset = tmdy_synth_get_preset(synth, sfont_id, bank_num, preset_num);
  if (preset == NULL) {
    TIMIDITY_LOG(TIMIDITY_ERR, 
	     "There is no preset with bank number %d and preset number %d in SoundFont %d", 
	     bank_num, preset_num, sfont_id);
    return TIMIDITY_FAILED;
  }
  
  * inform the channel of the new bank and program number *
  tmdy_channel_set_sfontnum(channel, sfont_id);
  tmdy_channel_set_banknum(channel, bank_num);
  tmdy_channel_set_prognum(channel, preset_num);

  tmdy_channel_set_preset(channel, preset);

  return TIMIDITY_OK;
}

*
 * tmdy_synth_update_presets
 *
void tmdy_synth_update_presets(tmdy_synth_t* synth)
{
  int chan;
  tmdy_channel_t* channel;

  for (chan = 0; chan < synth->midi_channels; chan++) {
    channel = synth->channel[chan];
    tmdy_channel_set_preset(channel, 
			    tmdy_synth_get_preset(synth, 
						  tmdy_channel_get_sfontnum(channel), 
						  tmdy_channel_get_banknum(channel), 
						  tmdy_channel_get_prognum(channel)));
  }
}


*
 * tmdy_synth_update_gain
 */
int tmdy_synth_update_gain(tmdy_synth_t* synth, char* name, double value) 
{
  tmdy_synth_set_gain(synth, (float) value);
  return 0;
}

/*
 * tmdy_synth_set_gain
 */
void tmdy_synth_set_gain(tmdy_synth_t* synth, float gain)
{

  tmdy_clip(gain, 0.0f, 10.0f);
	rtsyn_mutex_lock( *(synth->rtsyn->busy_p) );
	*(synth->playmidi->amplification_p)=(int32) (MAX_AMPLIFICATION*gain/10);
	rtsyn_mutex_unlock( *(synth->rtsyn->busy_p) );

}


/*
 * tmdy_synth_get_drum_gain
 */
float tmdy_synth_get_gain(tmdy_synth_t* synth)
{
	float ts_buf;
	ts_buf=((float) *(synth->playmidi->amplification_p))/((float)(MAX_AMPLIFICATION))*10.0f;
	return ts_buf;
}

int tmdy_synth_update_drum_gain(tmdy_synth_t* synth, char* name, double value) 
{
  tmdy_synth_set_drum_gain(synth, (float) value);
  return 0;
}

/*
 * tmdy_synth_set_gain
 */
void tmdy_synth_set_drum_gain(tmdy_synth_t* synth, float gain)
{

  tmdy_clip(gain, 0.0f, 10.0f);
	rtsyn_mutex_lock( *(synth->rtsyn->busy_p) );
	*(synth->playmidi->opt_drum_power_p)=(int32) (MAX_AMPLIFICATION*gain/10);
	rtsyn_mutex_unlock( *(synth->rtsyn->busy_p) );

}


/*
 * tmdy_synth_get_gain
 */
float tmdy_synth_get_drum_gain(tmdy_synth_t* synth)
{
	float ts_buf;
	ts_buf=((float) *(synth->playmidi->opt_drum_power_p))/((float)(MAX_AMPLIFICATION))*10.0f;
	return ts_buf;
}

/*
 * tmdy_synth_get_internal_buffer_size
 *
int tmdy_synth_get_internal_bufsize(tmdy_synth_t* synth)
{
  return TIMIDITY_BUFSIZE;
}
*/
/*
 * tmdy_synth_program_reset
 *
 * Resend a bank select and a program change for every channel. This
 * function is called mainly after a SoundFont has been loaded,
 * unloaded or reloaded.  */
int 
tmdy_synth_program_reset(tmdy_synth_t* synth)
{ 
//  int i;
  /* try to set the correct presets */
//  for (i = 0; i < synth->midi_channels; i++){
//    tmdy_synth_program_change(synth, i, tmdy_channel_get_prognum(synth->channel[i]));
//  }
  return TIMIDITY_OK;
}

/*
 * tmdy_synth_set_reverb_preset
 *
int tmdy_synth_set_reverb_preset(tmdy_synth_t* synth, int num)
{
  int i = 0;
  while (revmodel_preset[i].name != NULL) {
    if (i == num) {
      tmdy_revmodel_setroomsize(synth->reverb, revmodel_preset[i].roomsize);
      tmdy_revmodel_setdamp(synth->reverb, revmodel_preset[i].damp);
      tmdy_revmodel_setwidth(synth->reverb, revmodel_preset[i].width);
      tmdy_revmodel_setlevel(synth->reverb, revmodel_preset[i].level);
      return TIMIDITY_OK;
    }
    i++;
  }
  return TIMIDITY_FAILED;
}

*
 * tmdy_synth_set_reverb
 *
void tmdy_synth_set_reverb(tmdy_synth_t* synth, double roomsize, double damping, 
			   double width, double level)
{
  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);
  tmdy_revmodel_setroomsize(synth->reverb, roomsize);
  tmdy_revmodel_setdamp(synth->reverb, damping);
  tmdy_revmodel_setwidth(synth->reverb, width);
  tmdy_revmodel_setlevel(synth->reverb, level);
}

*
 * tmdy_synth_set_chorus
 *
void tmdy_synth_set_chorus(tmdy_synth_t* synth, int nr, double level, 
			   double speed, double depth_ms, int type)
{
  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);
  tmdy_chorus_set_nr(synth->chorus, nr);
  tmdy_chorus_set_level(synth->chorus, (tmdy_real_t)level);
  tmdy_chorus_set_speed_Hz(synth->chorus, (tmdy_real_t)speed);
  tmdy_chorus_set_depth_ms(synth->chorus, (tmdy_real_t)depth_ms);
  tmdy_chorus_set_type(synth->chorus, type);
  tmdy_chorus_update(synth->chorus);
}

******************************************************

#define COMPRESS      1
#define COMPRESS_X1   4.0
#define COMPRESS_Y1   0.6
#define COMPRESS_X2   10.0
#define COMPRESS_Y2   1.0

  len2 = 2 * len;
  alpha1 = COMPRESS_Y1 / COMPRESS_X1;
  alpha2 = (COMPRESS_Y2 - COMPRESS_Y1) / (COMPRESS_X2 - COMPRESS_X1);
  if (COMPRESS_X1 == COMPRESS_Y1) {
    for (j = 0; j < len2; j++) {
      if (buf[j] > COMPRESS_X1) {
	if (buf[j] > COMPRESS_X2) {
	  buf[j] = COMPRESS_Y2;
	} else {
	  buf[j] = COMPRESS_Y1 + alpha2 * (buf[j] - COMPRESS_X1);
	}
      } else if (buf[j] < -COMPRESS_X1) {
	if (buf[j] < -COMPRESS_X2) {
	  buf[j] = -COMPRESS_Y2;
	} else {
	  buf[j] = -COMPRESS_Y1 + alpha2 * (buf[j] + COMPRESS_X1);
	}
      }
    }
  } else {
    for (j = 0; j < len2; j++) {
      if ((buf[j] >= -COMPRESS_X1) && (buf[j] <= COMPRESS_X1)) {
	buf[j] *= alpha1;
      } else if (buf[j] > COMPRESS_X1) {
	if (buf[j] > COMPRESS_X2) {
	  buf[j] = COMPRESS_Y2;
	} else {
	  buf[j] = COMPRESS_Y1 + alpha2 * (buf[j] - COMPRESS_X1);
	}
      } else {
	if (buf[j] < -COMPRESS_X2) {
	  buf[j] = -COMPRESS_Y2;
	} else {
	  buf[j] = -COMPRESS_Y1 + alpha2 * (buf[j] + COMPRESS_X1);
	}
      }
    }
  }

***************************************************

* 
 *  tmdy_synth_write_float
 *
int 
tmdy_synth_nwrite_float(tmdy_synth_t* synth, int len, 
			float** left, float** right, 
			float** fx_left, float** fx_right)
{
  tmdy_real_t** left_in = synth->left_buf;
  tmdy_real_t** right_in = synth->right_buf;
  tmdy_real_t** fx_left_in = synth->fx_left_buf;
  tmdy_real_t** fx_right_in = synth->fx_right_buf;
  double time = tmdy_utime();
  int i, num, available, count, bytes;

  * make sure we're playing *
  if (synth->state != TIMIDITY_SYNTH_PLAYING) {
    return 0;
  }

  * First, take what's still available in the buffer *
  count = 0;
  available = TIMIDITY_BUFSIZE - synth->cur;

  num = (available > len)? len : available;
  bytes = num * sizeof(float);

  for (i = 0; i < synth->audio_channels; i++) {
    TIMIDITY_MEMCPY(left[i], left_in[i] + synth->cur, bytes);
    TIMIDITY_MEMCPY(right[i], right_in[i] + synth->cur, bytes);
  }
  for (i = 0; i < synth->effects_channels; i++) {
    TIMIDITY_MEMCPY(fx_left[i], fx_left_in[i] + synth->cur, bytes);
    TIMIDITY_MEMCPY(fx_right[i], fx_right_in[i] + synth->cur, bytes);
  }
  count += num;

  * Then, run one_block() and copy till we have 'len' samples  *
  while (count < len) {
      tmdy_synth_one_block(synth, 1);

      num = (TIMIDITY_BUFSIZE > len - count)? len - count : TIMIDITY_BUFSIZE;
      bytes = num * sizeof(float);
      
      for (i = 0; i < synth->audio_channels; i++) {
	TIMIDITY_MEMCPY(left[i] + count, left_in[i], bytes);
	TIMIDITY_MEMCPY(right[i] + count, right_in[i], bytes);
      }
      for (i = 0; i < synth->effects_channels; i++) {
	TIMIDITY_MEMCPY(fx_left[i] + count, fx_left_in[i], bytes);
	TIMIDITY_MEMCPY(fx_right[i] + count, fx_right_in[i], bytes);
      }

      count += num;
  }

  synth->cur = num;

  time = tmdy_utime() - time;
  synth->cpu_load = 0.5 * (synth->cpu_load +
			   time * synth->sample_rate / len / 10000.0);

*   printf("CPU: %.2f\n", synth->cpu_load); *

  return 0;
}

int tmdy_synth_process(tmdy_synth_t* synth, int len,
		       int nin, float** in, 
		       int nout, float** out)
{
  return tmdy_synth_write_float(synth, len, out[0], 0, 1, out[1], 0, 1); 
}


* 
 *  tmdy_synth_write_float
 *
int 
tmdy_synth_write_float(tmdy_synth_t* synth, int len, 
		       void* lout, int loff, int lincr, 
		       void* rout, int roff, int rincr)
{
  int i, j, k, l;
  float* left_out = (float*) lout;
  float* right_out = (float*) rout;
  tmdy_real_t* left_in = synth->left_buf[0];
  tmdy_real_t* right_in = synth->right_buf[0];
  double time = tmdy_utime();

  * make sure we're playing *
  if (synth->state != TIMIDITY_SYNTH_PLAYING) {
    return 0;
  }

  l = synth->cur;

  for (i = 0, j = loff, k = roff; i < len; i++, l++, j += lincr, k += rincr) {
    * fill up the buffers as needed *
      if (l == TIMIDITY_BUFSIZE) {
	tmdy_synth_one_block(synth, 0);
	l = 0;
      }
      
      left_out[j] = (float) left_in[l];
      right_out[k] = (float) right_in[l];
  }
  
  synth->cur = l;

  time = tmdy_utime() - time;
  synth->cpu_load = 0.5 * (synth->cpu_load +
			   time * synth->sample_rate / len / 10000.0);

*   printf("CPU: %.2f\n", synth->cpu_load); *

  return 0;
}

* 
 *  tmdy_synth_write_s16
 *
int 
tmdy_synth_write_s16(tmdy_synth_t* synth, int len, 
		     void* lout, int loff, int lincr, 
		     void* rout, int roff, int rincr)
{
  int i, j, k, cur;
  signed short* left_out = (signed short*) lout;
  signed short* right_out = (signed short*) rout;
  tmdy_real_t* left_in = synth->left_buf[0];
  tmdy_real_t* right_in = synth->right_buf[0];
  double prof_ref = tmdy_profile_ref();
  tmdy_real_t left_sample;
  tmdy_real_t right_sample;
  double time = tmdy_utime();

  * make sure we're playing *
  if (synth->state != TIMIDITY_SYNTH_PLAYING) {
    return 0;
  }

  cur = synth->cur;

  for (i = 0, j = loff, k = roff; i < len; i++, cur++, j += lincr, k += rincr) {

    * fill up the buffers as needed *
    if (cur == TIMIDITY_BUFSIZE) {

      double prof_ref_on_block = tmdy_profile_ref();

      tmdy_synth_one_block(synth, 0);
      cur = 0;
      
      tmdy_profile(TIMIDITY_PROF_ONE_BLOCK, prof_ref_on_block);
    }

    left_sample=left_in[cur]* 32767.0f;
    right_sample=right_in[cur] * 32767.0f;
    
    * digital clipping *
    if (left_sample > 32767.0f) {
      left_sample = 32767;
    } 
    if (left_sample < -32768.0f) {
      left_sample = -32768;
    }
    if (right_sample > 32767.0f) {
      right_sample = 32767;
    } 
    if (right_sample < -32768.0f) {
      right_sample = -32768;
    } 
    left_out[j] = (signed short) left_sample;
    right_out[k] = (signed short) right_sample;
  }
  
  synth->cur = cur;

  tmdy_profile(TIMIDITY_PROF_WRITE_S16, prof_ref);


  time = tmdy_utime() - time;
  synth->cpu_load = 0.5 * (synth->cpu_load +
			   time * synth->sample_rate / len / 10000.0);

*   printf("CPU: %.2f\n", synth->cpu_load); *

  return 0;
}


* 
 *  tmdy_synth_one_block
 *
int 
tmdy_synth_one_block(tmdy_synth_t* synth, int do_not_mix_fx_to_out)
{
  int i, auchan;
  tmdy_voice_t* voice;
  tmdy_real_t* left_buf;
  tmdy_real_t* right_buf;
  tmdy_real_t* reverb_buf;
  tmdy_real_t* chorus_buf;
  int byte_size = TIMIDITY_BUFSIZE * sizeof(tmdy_real_t);
  double prof_ref = tmdy_profile_ref();
  rtsyn_mutex_lock(synth->busy); * Here comes the audio thread. Lock the synth. *
  
  tmdy_check_fpe("??? Just starting up ???");  

  * clean the audio buffers *
  for (i = 0; i < synth->nbuf; i++) {
    TIMIDITY_MEMSET(synth->left_buf[i], 0, byte_size);
    TIMIDITY_MEMSET(synth->right_buf[i], 0, byte_size);
  }
  for (i = 0; i < synth->effects_channels; i++) {
    TIMIDITY_MEMSET(synth->fx_left_buf[i], 0, byte_size);
    TIMIDITY_MEMSET(synth->fx_right_buf[i], 0, byte_size);
  }

  * Set up the reverb / chorus buffers only, when the effect is
   * enabled on synth level.  Nonexisting buffers are detected in the
   * DSP loop. Not sending the reverb / chorus signal saves some time
   * in that case. *
  if (synth->with_reverb) {
    reverb_buf = synth->fx_left_buf[0];
  } else {
    reverb_buf = NULL;
  }
  
  if (synth->with_chorus) {
    chorus_buf = synth->fx_left_buf[1];
  } else {
    chorus_buf = NULL;
  }


  tmdy_profile(TIMIDITY_PROF_ONE_BLOCK_CLEAR, prof_ref);

  * call all playing synthesis processes *
  for (i = 0; i < synth->nvoice; i++) {
    voice = synth->voice[i];
    
    if (_PLAYING(voice)) {
      double prof_ref_voice = tmdy_profile_ref();

      * The output associated with a MIDI channel is wrapped around using the number of 
       * audio groups as modulo divider.
       * This is typically the number of output channels on the 'sound card', as long as the
       * LADSPA Fx unit is not used. In case of LADSPA unit, think of it as subgroups on a mixer.
       * For example: Assume that the number of groups is set to 2.
       * Then MIDI channel 1, 3, 5, 7 etc. go to output 1, channels 2, 4, 6, 8 etc to output 2. 
       * Or assume 3 groups:
       * Then MIDI channels 1, 4, 7, 10 etc go to output 1;  2, 5, 8, 11 etc to output 2,
       * 3, 6, 9, 12 etc to output 3.
       *
      auchan = tmdy_channel_get_num(tmdy_voice_get_channel(voice));
      auchan %= synth->audio_groups;
      left_buf = synth->left_buf[auchan];
      right_buf = synth->right_buf[auchan];

      tmdy_voice_write(voice, left_buf, right_buf, reverb_buf, chorus_buf);

      tmdy_profile(TIMIDITY_PROF_ONE_BLOCK_VOICE, prof_ref_voice);
    }
  }
  tmdy_check_fpe("Synthesis processes");

  tmdy_profile(TIMIDITY_PROF_ONE_BLOCK_VOICES, prof_ref);

  * if multi channel output, don't mix the output of the chorus and
     reverb in the final output. The effects outputs are send
     separately. *

  if (do_not_mix_fx_to_out) {

    * send to reverb *
    if (reverb_buf) {
      tmdy_revmodel_processreplace(synth->reverb, reverb_buf, 
				   synth->fx_left_buf[0], synth->fx_right_buf[0]);
      tmdy_check_fpe("Reverb");
    }

    tmdy_profile(TIMIDITY_PROF_ONE_BLOCK_REVERB, prof_ref);
    
    * send to chorus *
    if (chorus_buf) {
      tmdy_chorus_processreplace(synth->chorus, chorus_buf, 
				 synth->fx_left_buf[1], synth->fx_right_buf[1]);
      tmdy_check_fpe("Chorus");
    }

  } else {

    * send to reverb *
    if (reverb_buf) {
      tmdy_revmodel_processmix(synth->reverb, reverb_buf, 
			       synth->left_buf[0], synth->right_buf[0]);
      tmdy_check_fpe("Reverb");
    }

    tmdy_profile(TIMIDITY_PROF_ONE_BLOCK_REVERB, prof_ref);
    
    * send to chorus *
    if (chorus_buf) {
      tmdy_chorus_processmix(synth->chorus, chorus_buf, 
			     synth->left_buf[0], synth->right_buf[0]);
      tmdy_check_fpe("Chorus");
    }
  }

  tmdy_profile(TIMIDITY_PROF_ONE_BLOCK_CHORUS, prof_ref);

#ifdef LADSPA
  * Run the signal through the LADSPA Fx unit *
  tmdy_LADSPA_run(synth->LADSPA_FxUnit, synth->left_buf, synth->right_buf, synth->fx_left_buf, synth->fx_right_buf);
  tmdy_check_fpe("LADSPA");
#endif

  synth->ticks += TIMIDITY_BUFSIZE;

  * Testcase, that provokes a denormal floating point error *
#if 0
  {float num=1;while (num != 0){num*=0.5;};};
#endif
  tmdy_check_fpe("??? Remainder of synth_one_block ???");
  rtsyn_mutex_unlock(synth->busy); * Allow other threads to touch the synth *

  return 0;  
}


*
 * tmdy_synth_free_voice_by_kill
 *
 * selects a voice for killing. the selection algorithm is a refinement
 * of the algorithm previously in tmdy_synth_alloc_voice.
 *
tmdy_voice_t*
tmdy_synth_free_voice_by_kill (tmdy_synth_t* synth)
{
  int i;
  tmdy_real_t best_prio=999999.;
  tmdy_real_t this_voice_prio;
  tmdy_voice_t* voice;
  int best_voice_index=-1;

  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);

  for (i = 0; i < synth->nvoice; i++) {
    
    voice = synth->voice[i];
    
    * safeguard against an available voice. *
    if (_AVAILABLE(voice))
      return voice;
    
    * Determine, how 'important' a voice is.
     * Start with an arbitrary number *
    this_voice_prio=10000.; 
    
    * Is this voice on the drum channel? 
     * Then it is very important.
     * Also, forget about the released-note condition:
     * Typically, drum notes are triggered only very briefly, they run most
     * of the time in release phase.
     *
    if (voice->chan == 9){
      this_voice_prio+=4000;
    } else if (_RELEASED(voice)){
      * The key for this voice has been released. Consider it much less important
       * than a voice, which is still held.
       *
      this_voice_prio-=2000.;
    };
    if (_SUSTAINED(voice)){
      * The sustain pedal is held down on this channel.
       * Consider it less important than non-sustained channels.
       * This decision is somehow subjective. But usually the sustain pedal
       * is used to play 'more-voices-than-fingers', so it shouldn't hurt
       * if we kill one voice.
       *
      this_voice_prio-=1000;
    };
        
    * We are not enthusiastic about releasing voices, which have just been started.
     * Otherwise hitting a chord may result in killing notes belonging to that very same
     * chord. 
     * So subtract the age of the voice from the priority - an older voice is just a little
     * bit less important than a younger voice. 
     * This is a number between roughly 0 and 100.*
    this_voice_prio -= (synth->noteid-tmdy_voice_get_id(voice));
    
    * take a rough estimate of loudness into account. Louder voices are more important. *
    if (voice->volenv_section != TIMIDITY_VOICE_ENVATTACK){
      this_voice_prio += voice->volenv_val*1000.;
    };

    * check if this voice has less priority than the previous candidate. *
    if (this_voice_prio < best_prio)
      best_voice_index = i,
      best_prio = this_voice_prio;
  }

  if (best_voice_index < 0)
    return NULL;
  
  voice = synth->voice[best_voice_index];
  tmdy_voice_off (voice);
  return voice;
}

*
 * tmdy_synth_alloc_voice
 *
tmdy_voice_t* 
tmdy_synth_alloc_voice(tmdy_synth_t* synth, tmdy_sample_t* sample, int chan, int key, int vel)
{
  int i, k;
  tmdy_voice_t* voice = NULL;

  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);

  * If there is another voice process on the same channel and key,
     advance it to the release phase. *
  tmdy_synth_release_voice_on_same_note(synth, chan, key);

  * check if there's an available synthesis process *
  for (i = 0; i < synth->nvoice; i++) {
    if (_AVAILABLE(synth->voice[i])) {
      voice = synth->voice[i];
      break;
    }
  }

  * No success yet? Then stop a running voice. *
  if (voice == NULL) {
    voice = tmdy_synth_free_voice_by_kill (synth);
  }

  if (voice == NULL) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Failed to allocate a synthesis process. (chan=%d,key=%d)", chan, key);
    return NULL;
  }  

  if (synth->verbose) {
    k = 0;
    for (i = 0; i < synth->nvoice; i++) {
      if (!_AVAILABLE(synth->voice[i])) {
	k++;
      }
    }

    TIMIDITY_LOG(TIMIDITY_INFO, "noteon\t%d\t%d\t%d\t%05d\t%.3f\t%.3f\t%.3f\t%d", 
	     chan, key, vel, synth->noteid, 
	     (float) synth->ticks / 44100.0f, 
	     (tmdy_curtime() - synth->start) / 1000.0f,
	     0.0f,
	     k);
  }

  if (tmdy_voice_init(voice, sample, synth->channel[chan], key, vel, 
		      synth->noteid, synth->ticks, synth->gain) != TIMIDITY_OK) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Failed to initialize voice");
    return NULL;
  }
   
  * add the default modulators to the synthesis process. *
  tmdy_voice_add_mod(voice, &default_vel2att_mod, TIMIDITY_VOICE_DEFAULT);    * SF2.01 $8.4.1  *
  tmdy_voice_add_mod(voice, &default_vel2filter_mod, TIMIDITY_VOICE_DEFAULT); * SF2.01 $8.4.2  *
  tmdy_voice_add_mod(voice, &default_at2viblfo_mod, TIMIDITY_VOICE_DEFAULT);  * SF2.01 $8.4.3  *
  tmdy_voice_add_mod(voice, &default_mod2viblfo_mod, TIMIDITY_VOICE_DEFAULT); * SF2.01 $8.4.4  *
  tmdy_voice_add_mod(voice, &default_att_mod, TIMIDITY_VOICE_DEFAULT);        * SF2.01 $8.4.5  *
  tmdy_voice_add_mod(voice, &default_pan_mod, TIMIDITY_VOICE_DEFAULT);        * SF2.01 $8.4.6  *
  tmdy_voice_add_mod(voice, &default_expr_mod, TIMIDITY_VOICE_DEFAULT);       * SF2.01 $8.4.7  *
  tmdy_voice_add_mod(voice, &default_reverb_mod, TIMIDITY_VOICE_DEFAULT);     * SF2.01 $8.4.8  *
  tmdy_voice_add_mod(voice, &default_chorus_mod, TIMIDITY_VOICE_DEFAULT);     * SF2.01 $8.4.9  *
  tmdy_voice_add_mod(voice, &default_pitch_bend_mod, TIMIDITY_VOICE_DEFAULT); * SF2.01 $8.4.10 *
  
  return voice;
}

*
 * tmdy_synth_kill_by_exclusive_class
 *
void tmdy_synth_kill_by_exclusive_class(tmdy_synth_t* synth, tmdy_voice_t* new_voice)
{
  ** Kill all voices on a given channel, which belong into
      excl_class.  This function is called by a SoundFont's preset in
      response to a noteon event.  If one noteon event results in
      several voice processes (stereo samples), ignore_ID must name
      the voice ID of the first generated voice (so that it is not
      stopped). The first voice uses ignore_ID=-1, which will
      terminate all voices on a channel belonging into the exclusive
      class excl_class.
  *
  
  int i;
  int excl_class = _GEN(new_voice,GEN_EXCLUSIVECLASS);

  * Check if the voice belongs to an exclusive class. In that case,
     previous notes from the same class are released. *
  
  * Excl. class 0: No exclusive class *
  if (excl_class == 0) { 
    return; 
  }
  
  //  TIMIDITY_LOG(TIMIDITY_INFO, "Voice belongs to exclusive class (class=%d, ignore_id=%d)\n", excl_class, ignore_ID);
  
    * Kill all notes on the same channel with the same exclusive class *
  
  for (i = 0; i < synth->nvoice; i++) {
    tmdy_voice_t* existing_voice = synth->voice[i];
    
    * Existing voice does not play? Leave it alone. *
    if (!_PLAYING(existing_voice)) {
      continue;
    }
    
    * An exclusive class is valid for a whole channel (or preset).
     * Is the voice on a different channel? Leave it alone. *
    if (existing_voice->chan != new_voice->chan) {
      continue;
    }
    
    * Existing voice has a different (or no) exclusive class? Leave it alone. *
    if ((int)_GEN(existing_voice, GEN_EXCLUSIVECLASS) != excl_class) {
      continue;
    }
    
    * Existing voice is a voice process belonging to this noteon
     * event (for example: stereo sample)?  Leave it alone. *
    if (tmdy_voice_get_id(existing_voice) == tmdy_voice_get_id(new_voice)) {
      continue;
    }
    
    //    TIMIDITY_LOG(TIMIDITY_INFO, "Releasing previous voice of exclusive class (class=%d, id=%d)\n", 
    //     (int)_GEN(existing_voice, GEN_EXCLUSIVECLASS), (int)tmdy_voice_get_id(existing_voice));
    
    tmdy_voice_kill_excl(existing_voice);
  };
};

*
 * tmdy_synth_start_voice
 *
void tmdy_synth_start_voice(tmdy_synth_t* synth, tmdy_voice_t* voice)
{
  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);

  * Find the exclusive class of this voice. If set, kill all voices
   * that match the exclusive class and are younger than the first
   * voice process created by this noteon event. *
  tmdy_synth_kill_by_exclusive_class(synth, voice);  

  * Start the new voice *

  tmdy_voice_start(voice);
}
*/
/*
 * tmdy_synth_get_channel_preset
 *
tmdy_preset_t*
tmdy_synth_get_channel_preset(tmdy_synth_t* synth, int chan)
{
  if ((chan >= 0) && (chan < synth->midi_channels)) {
    return tmdy_channel_get_preset(synth->channel[chan]);
  }
  
  return NULL;
}

*
 * tmdy_synth_get_voicelist
 *
void
tmdy_synth_get_voicelist(tmdy_synth_t* synth, tmdy_voice_t* buf[], int bufsize, int ID)
{
  int i;
  int count = 0;
  for (i = 0; i < synth->nvoice; i++) {
    tmdy_voice_t* voice = synth->voice[i];
    if (count >= bufsize) {
      return;
    }
    
    if (_PLAYING(voice) && ((int)voice->id == ID || ID < 0)) {
      buf[count++] = voice;
    }
  }
  if (count >= bufsize) {
    return;
  }
  buf[count++] = NULL;
}

* Purpose: 
 * Turns on / off the reverb unit in the synth *
void tmdy_synth_set_reverb_on(tmdy_synth_t* synth, int on)
{
  synth->with_reverb = on;
}

* Purpose: 
 * Turns on / off the chorus unit in the synth *
void tmdy_synth_set_chorus_on(tmdy_synth_t* synth, int on)
{
  synth->with_chorus = on;
}

* Purpose: 
 * Reports the current setting of the chorus unit. *
int tmdy_synth_get_chorus_nr(tmdy_synth_t* synth)
{
    return tmdy_chorus_get_nr(synth->chorus);
}

double tmdy_synth_get_chorus_level(tmdy_synth_t* synth)
{
    return (double)tmdy_chorus_get_level(synth->chorus);
}

double tmdy_synth_get_chorus_speed_Hz(tmdy_synth_t* synth)
{
    return (double)tmdy_chorus_get_speed_Hz(synth->chorus);
}

double tmdy_synth_get_chorus_depth_ms(tmdy_synth_t* synth)
{
    return (double)tmdy_chorus_get_depth_ms(synth->chorus);
}

int tmdy_synth_get_chorus_type(tmdy_synth_t* synth)
{
    return tmdy_chorus_get_type(synth->chorus);
}

* Purpose:
 * Returns the current settings_old of the reverb unit *
double tmdy_synth_get_reverb_roomsize(tmdy_synth_t* synth)
{
    return (double)tmdy_revmodel_getroomsize(synth->reverb);
}

double tmdy_synth_get_reverb_damp(tmdy_synth_t* synth)
{
    return (double) tmdy_revmodel_getdamp(synth->reverb);
}

double tmdy_synth_get_reverb_level(tmdy_synth_t* synth)
{
    return (double) tmdy_revmodel_getlevel(synth->reverb);
}

double tmdy_synth_get_reverb_width(tmdy_synth_t* synth)
{
    return (double) tmdy_revmodel_getwidth(synth->reverb);
}

* Purpose: 
 *
 * If the same note is hit twice on the same channel, then the older
 * voice process is advanced to the release stage.  Using a mechanical
 * MIDI controller, the only way this can happen is when the sustain
 * pedal is held.  In this case the behaviour implemented here is
 * natural for many instruments.  Note: One noteon event can trigger
 * several voice processes, for example a stereo sample.  Don't
 * release those...
 *
void tmdy_synth_release_voice_on_same_note(tmdy_synth_t* synth, int chan, int key){
  int i;
  tmdy_voice_t* voice;
  rtsyn_mutex_lock(synth->busy); * Don't interfere with the audio thread *
  rtsyn_mutex_unlock(synth->busy);

  for (i = 0; i < synth->nvoice; i++) {
    voice = synth->voice[i];
    if (_PLAYING(voice) 
	&& (voice->chan == chan) 
	&& (voice->key == key) 
	&& (tmdy_voice_get_id(voice) != synth->noteid)) {
      tmdy_voice_noteoff(voice);
    }
  }
}*/
/*
enum {
	RESAMPLE_CSPLINE,
	RESAMPLE_LAGRANGE,
	RESAMPLE_GAUSS,
	RESAMPLE_NEWTON,
	RESAMPLE_LINEAR,
	RESAMPLE_NONE
};
*/
int tmdy_synth_set_interp_method(tmdy_synth_t* synth,int type,int val){
	if(0 != synth->resample->set_current_resampler(type) ){
	    synth->controls->ctl->cmsg(CMSG_FATAL, VERB_NORMAL,
		      "Can't set interp method!"); 
		return TIMIDITY_FAILED;
	}
	if(0 != set_resampler_parm(val) ){
		 synth->controls->ctl->cmsg(CMSG_FATAL, VERB_NORMAL,
		      "Can't set interp method parameter!"); 
		return TIMIDITY_FAILED;
	}
	return TIMIDITY_OK;
}
int tmdy_synth_get_interp_method(tmdy_synth_t* synth){
	return synth->resample->get_current_resampler();
}

/* Purpose:
 * Sets the interpolation method to use on channel chan.
 * If chan is < 0, then set the interpolation method on all channels.
 *
int tmdy_synth_set_interp_method(tmdy_synth_t* synth, int chan, int interp_method){
  int i;
  for (i = 0; i < synth->midi_channels; i++) {
    if (synth->channel[i] == NULL){
      TIMIDITY_LOG(TIMIDITY_ERR, "Channels don't exist (yet)!"); 
      return TIMIDITY_FAILED;
    };
    if (chan < 0 || tmdy_channel_get_num(synth->channel[i]) == chan){
      tmdy_channel_set_interp_method(synth->channel[i], interp_method);
    };
  };
  return TIMIDITY_OK;
};

* Purpose:
 * Returns the number of allocated midi channels
 *
int 
tmdy_synth_count_midi_channels(tmdy_synth_t* synth)
{
  return synth->midi_channels;
}

* Purpose:
 * Returns the number of allocated audio channels
 *
int 
tmdy_synth_count_audio_channels(tmdy_synth_t* synth)
{
  return synth->audio_channels;
}

* Purpose:
 * Returns the number of allocated audio channels
 *
int 
tmdy_synth_count_audio_groups(tmdy_synth_t* synth)
{
  return synth->audio_groups;
}

* Purpose:
 * Returns the number of allocated effects channels
 *
int
tmdy_synth_count_effects_channels(tmdy_synth_t* synth)
{
  return synth->effects_channels;
}

double tmdy_synth_get_cpu_load(tmdy_synth_t* synth)
{
  return synth->cpu_load;
}

static tmdy_tuning_t* 
tmdy_synth_get_tuning(tmdy_synth_t* synth, int bank, int prog)
{
  if ((bank < 0) || (bank >= 128)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Bank number out of range");
    return NULL;     
  }
  if ((prog < 0) || (prog >= 128)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Program number out of range");
    return NULL;     
  }
  if ((synth->tuning == NULL) ||
      (synth->tuning[bank] == NULL) ||
      (synth->tuning[bank][prog] == NULL)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "No tuning at bank %d, prog %d", bank, prog);
    return NULL;     
  }
  return synth->tuning[bank][prog];
}

static tmdy_tuning_t* 
tmdy_synth_create_tuning(tmdy_synth_t* synth, int bank, int prog, char* name)
{
  if ((bank < 0) || (bank >= 128)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Bank number out of range");
    return NULL;     
  }
  if ((prog < 0) || (prog >= 128)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Program number out of range");
    return NULL;     
  }
  if (synth->tuning == NULL) {
    synth->tuning = TIMIDITY_ARRAY(tmdy_tuning_t**, 128);
    if (synth->tuning == NULL) {
      TIMIDITY_LOG(TIMIDITY_PANIC, "Out of memory");
      return NULL;
    }
    TIMIDITY_MEMSET(synth->tuning, 0, 128 * sizeof(tmdy_tuning_t**));
  }

  if (synth->tuning[bank] == NULL) {
    synth->tuning[bank] = TIMIDITY_ARRAY(tmdy_tuning_t*, 128);
    if (synth->tuning[bank] == NULL) {
      TIMIDITY_LOG(TIMIDITY_PANIC, "Out of memory");
      return NULL;
    }
    TIMIDITY_MEMSET(synth->tuning[bank], 0, 128 * sizeof(tmdy_tuning_t*));
  }

  if (synth->tuning[bank][prog] == NULL) {
    synth->tuning[bank][prog] = new_tmdy_tuning(name, bank, prog);
    if (synth->tuning[bank][prog] == NULL) {
      return NULL;
    }
  }

  if ((tmdy_tuning_get_name(synth->tuning[bank][prog]) == NULL) 
      || (TIMIDITY_STRCMP(tmdy_tuning_get_name(synth->tuning[bank][prog]), name) != 0)) {
    tmdy_tuning_set_name(synth->tuning[bank][prog], name);
  }

  return synth->tuning[bank][prog];
}

int tmdy_synth_create_key_tuning(tmdy_synth_t* synth, 
				 int bank, int prog,
				 char* name, double* pitch)
{
  tmdy_tuning_t* tuning = tmdy_synth_create_tuning(synth, bank, prog, name);
  if (tuning == NULL) {
    return TIMIDITY_FAILED;
  }
  if (pitch) {
    tmdy_tuning_set_all(tuning, pitch);
  }
  return TIMIDITY_OK;
}


int tmdy_synth_create_octave_tuning(tmdy_synth_t* synth, 
				    int bank, int prog,
				    char* name, double* pitch)
{
  tmdy_tuning_t* tuning = tmdy_synth_create_tuning(synth, bank, prog, name);
  if (tuning == NULL) {
    return TIMIDITY_FAILED;
  }
  tmdy_tuning_set_octave(tuning, pitch);
  return TIMIDITY_OK;
}

int tmdy_synth_tune_notes(tmdy_synth_t* synth, int bank, int prog,
			  int len, int *key, double* pitch, int apply)
{
  tmdy_tuning_t* tuning = tmdy_synth_get_tuning(synth, bank, prog);
  int i;

  if (tuning == NULL) { 
    return TIMIDITY_FAILED;     
  }

  for (i = 0; i < len; i++) {
    tmdy_tuning_set_pitch(tuning, key[i], pitch[i]);
  }

  return TIMIDITY_OK;
}

int tmdy_synth_select_tuning(tmdy_synth_t* synth, int chan, 
			     int bank, int prog)
{
  tmdy_tuning_t* tuning = tmdy_synth_get_tuning(synth, bank, prog);

  if (tuning == NULL) { 
    return TIMIDITY_FAILED;     
  }
  if ((chan < 0) || (chan >= synth->midi_channels)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Channel out of range");
    return TIMIDITY_FAILED;     
  }

  tmdy_channel_set_tuning(synth->channel[chan], synth->tuning[bank][prog]);

  return TIMIDITY_OK;
}

int tmdy_synth_reset_tuning(tmdy_synth_t* synth, int chan)
{
  if ((chan < 0) || (chan >= synth->midi_channels)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Channel out of range");
    return TIMIDITY_FAILED;     
  }

  tmdy_channel_set_tuning(synth->channel[chan], NULL);
  
  return TIMIDITY_OK;
}

void tmdy_synth_tuning_iteration_start(tmdy_synth_t* synth)
{
  synth->cur_tuning = NULL;
}

int tmdy_synth_tuning_iteration_next(tmdy_synth_t* synth, int* bank, int* prog)
{
  int b = 0, p = 0;
  
  if (synth->tuning == NULL) {
    return 0;
  }

  if (synth->cur_tuning != NULL) {
    * get the next program number *
    b = tmdy_tuning_get_bank(synth->cur_tuning);
    p = 1 + tmdy_tuning_get_prog(synth->cur_tuning);
    if (p >= 128) {
      p = 0;
      b++;
    }
  }

  while (b < 128) {
    if (synth->tuning[b] != NULL) {
      while (p < 128) {
	if (synth->tuning[b][p] != NULL) {
	  synth->cur_tuning = synth->tuning[b][p];
	  *bank = b;
	  *prog = p;
	  return 1;
	}
	p++;
      }
    }
    p = 0;
    b++;
  }

  return 0;
}

int tmdy_synth_tuning_dump(tmdy_synth_t* synth, int bank, int prog, 
			   char* name, int len, double* pitch)
{
  tmdy_tuning_t* tuning = tmdy_synth_get_tuning(synth, bank, prog);

  if (tuning == NULL) { 
    return TIMIDITY_FAILED;     
  }

  if (name) {
    snprintf(name, len - 1, "%s", tmdy_tuning_get_name(tuning));
    name[len - 1] = 0;  * make sure the string is null terminated *
  }
  if (pitch) {
    TIMIDITY_MEMCPY(pitch, tmdy_tuning_get_all(tuning), 128 * sizeof(double));
  }

  return TIMIDITY_OK;
}

tmdy_settings_t* tmdy_synth_get_settings(tmdy_synth_t* synth)
{
  return synth->settings;
}

int tmdy_synth_setstr(tmdy_synth_t* synth, char* name, char* str)
{
  return tmdy_settings_setstr(synth->settings, name, str);
}

int tmdy_synth_getstr(tmdy_synth_t* synth, char* name, char** str)
{
  return tmdy_settings_getstr(synth->settings, name, str);
}

int tmdy_synth_setnum(tmdy_synth_t* synth, char* name, double val)
{
  return tmdy_settings_setnum(synth->settings, name, val);
}

int tmdy_synth_getnum(tmdy_synth_t* synth, char* name, double* val)
{
  return tmdy_settings_getnum(synth->settings, name, val);
}

int tmdy_synth_setint(tmdy_synth_t* synth, char* name, int val)
{
  return tmdy_settings_setint(synth->settings, name, val);
}

int tmdy_synth_getint(tmdy_synth_t* synth, char* name, int* val)
{
  return tmdy_settings_getint(synth->settings, name, val);
}

int 
tmdy_synth_set_gen(tmdy_synth_t* synth, int chan, int param, float value)
{
  int i;
  tmdy_voice_t* voice;

  if ((chan < 0) || (chan >= synth->midi_channels)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Channel out of range");
    return TIMIDITY_FAILED;     
  }

  if ((param < 0) || (param >= GEN_LAST)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Parameter number out of range");
    return TIMIDITY_FAILED;     
  }

  tmdy_channel_set_gen(synth->channel[chan], param, value);

  for (i = 0; i < synth->nvoice; i++) {
    voice = synth->voice[i];
    if (voice->chan == chan) {
      tmdy_voice_set_param(voice, param, value);
    }
  }

  return TIMIDITY_OK;  
}

float tmdy_synth_get_gen(tmdy_synth_t* synth, int chan, int param)
{
  if ((chan < 0) || (chan >= synth->midi_channels)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Channel out of range");
    return 0.0;     
  }

  if ((param < 0) || (param >= GEN_LAST)) {
    TIMIDITY_LOG(TIMIDITY_WARN, "Parameter number out of range");
    return 0.0;     
  }

  return tmdy_channel_get_gen(synth->channel[chan], param);
}
*/
/* The synth needs to know the router for the command line handlers (they only 
 * supply the synth as argument)
 *
void tmdy_synth_set_midi_router(tmdy_synth_t* synth, tmdy_midi_router_t* router){
  synth->midi_router=router;
};

* Purpose:
 * Any MIDI event from the MIDI router arrives here and is handed
 * to the appropriate function.
 *
int tmdy_synth_handle_midi_event(void* data, tmdy_midi_event_t* event)
{
  tmdy_synth_t* synth = (tmdy_synth_t*) data;
  int type = tmdy_midi_event_get_type(event);
  int chan = tmdy_midi_event_get_channel(event);

  switch(type) {
      case NOTE_ON:
	return tmdy_synth_noteon(synth, chan, 
				 tmdy_midi_event_get_key(event), 
				 tmdy_midi_event_get_velocity(event));

      case NOTE_OFF:
	return tmdy_synth_noteoff(synth, chan, tmdy_midi_event_get_key(event));

      case CONTROL_CHANGE:
	return tmdy_synth_cc(synth, chan, 
			     tmdy_midi_event_get_control(event), 
			     tmdy_midi_event_get_value(event));

      case PROGRAM_CHANGE:
	return tmdy_synth_program_change(synth, chan, tmdy_midi_event_get_program(event));

      case PITCH_BEND:
	return tmdy_synth_pitch_bend(synth, chan, tmdy_midi_event_get_pitch(event));

      case MIDI_SYSTEM_RESET:
	return tmdy_synth_system_reset(synth);
  }
  return TIMIDITY_FAILED;
}
*/
void tmdy_synth_add_soundfont(tmdy_synth_t* synth, char *sf_file, int sf_order,
			  int cutoff_allowed, int resonance_allowed,
				int amp)
{
	synth->instrum->add_soundfont(sf_file, sf_order, 
		cutoff_allowed, resonance_allowed,amp);
}
void tmdy_synth__remove_soundfont(tmdy_synth_t* synth, char *sf_file)
{
	synth->instrum->remove_soundfont(sf_file);
}
void tmdy_synth_init_load_soundfont(tmdy_synth_t* synth)
{
	synth->instrum->init_load_soundfont();
}
	//enum{ CHORUS_DISABLE, CHORUS_NORMAL, CHORUS_SURROUND };
void tmdy_synth_set_chorus(tmdy_synth_t* synth,int type,int value,int degree){
	int opt_surround_chorus = 1;
	int opt_chorus_control = 1;
	
	if(type==CHORUS_DISABLE){
		opt_chorus_control = 0;
		opt_surround_chorus = 0;
	}
	if(type==CHORUS_NORMAL){
	}
	if(type==CHORUS_SURROUND){
		
		if(degree==0){
			opt_surround_chorus = 0;
		}else{
			opt_surround_chorus = 1;
		}
		if((value>=0) &&(value<=0x7f)) {
			opt_chorus_control=-value;
		}else{
			opt_chorus_control = 1;
		}
	}
	rtsyn_mutex_lock( *(synth->rtsyn->busy_p) );
	*(synth->playmidi->opt_surround_chorus_p)=opt_surround_chorus;
	*(synth->playmidi->opt_chorus_control_p)=opt_chorus_control;
	rtsyn_mutex_unlock( *(synth->rtsyn->busy_p) );
}

	//enum{ REVERB_DISABLE, REVERB_NORMAL, REVERB_GLOBAL, REVERB_FREEVERB };
void tmdy_synth_set_reverb(tmdy_synth_t* synth,int type,int value){
	int opt_reverb_control = 1;
	
	if(type==REVERB_DISABLE){
		opt_chorus_control = 0;
		opt_surround_chorus = 0;
	}
	if(type==REVERB_NORMAL){
		if((value>=0) &&(value<=0x7f)) {
			opt_reverb_control=-value;
		}else{
			opt_reverb_control = 1;
		}
	}
	if(type==REVERB_GLOBAL){
		opt_reverb_control = 2;
	}
	if(type==REVERB_FREEVERB){
		opt_reverb_control = 3;
	}
	rtsyn_mutex_lock( *(synth->rtsyn->busy_p) );
	*(synth->playmidi->opt_reverb_control_p)=opt_reverb_control;
	rtsyn_mutex_unlock( *(synth->rtsyn->busy_p) );

}
	
int tmdy_synth_set_output(tmdy_synth_t* synth, char mode, __int32 encoding ){
	PlayMode *pmp, **pmpp;
	PlayMode *play_mode_buf;
	int found = 0;
	int i;
	int32 encoding_buf;
	
	for (pmpp = synth->output->play_mode_list; pmp = *pmpp; pmpp++)
		if (pmp->id_character == mode) {
			found = 1;
			play_mode_buf = pmp;
			break;
		}
	if (! found) {
		synth->controls->ctl->cmsg(CMSG_ERROR, VERB_NORMAL,
				"Playmode `%c' is not compiled in.", mode);
  		return TIMIDITY_FAILED;
	}
	encoding_buf=pmp->encoding;
	
	if(!(encoding & PE_MONO)){  //stereo 
			encoding_buf &= ~PE_MONO;
	}else{
			encoding_buf |= PE_MONO;
	}
	if( encoding & PE_SIGNED){
			encoding_buf |= PE_SIGNED;
			encoding_buf &= ~(PE_ULAW | PE_ALAW);
	}else{
			encoding_buf &= ~PE_SIGNED;
			encoding_buf &= ~(PE_ULAW | PE_ALAW);
	}
	if( encoding & PE_16BIT){
			encoding_buf |= PE_16BIT;
			encoding_buf &= ~(PE_ULAW | PE_ALAW);
	}else{
			encoding_buf &= ~PE_16BIT;
	}
	if( encoding & PE_ULAW){
			encoding_buf |= PE_ULAW;
			encoding_buf &=
					~(PE_SIGNED | PE_16BIT | PE_ALAW | PE_BYTESWAP);
	}else{
		if(encoding & PE_ALAW){
			encoding_buf |= PE_ALAW;
			encoding_buf &=
				~(PE_SIGNED | PE_16BIT | PE_ULAW | PE_BYTESWAP);
		}else{   
			if( encoding | PE_BYTESWAP){
				encoding_buf |= PE_BYTESWAP;
				encoding_buf &= ~(PE_ULAW | PE_ALAW);
			}else{     //linear 
				encoding_buf &= ~(PE_ULAW | PE_ALAW);
			}
		}
	}
	
//	synth->playmidi->kill_all_voices();
	synth->aq->aq_flush(1);
	synth->output->play_mode->close_output();
	
	synth->output->play_mode=play_mode_buf;
	rtsyn_mutex_lock( *(synth->rtsyn->busy_p) );
	pmp->encoding=encoding_buf;
	rtsyn_mutex_unlock( *(synth->rtsyn->busy_p) );
	if ((synth->output->target_play_mode)->flag & PF_PCM_STREAM) {
	    (synth_struct->output->target_play_mode)->extra_param[1] = synth->aq->aq_calc_fragsize();
	    ctl->cmsg(CMSG_INFO, VERB_DEBUG_SILLY,
		      "requesting fragment size: %d",
		      synth->output->play_mode->extra_param[1]);
	}
	synth->aq->aq_setup();
	synth->timidity->timidity_init_aq_buff();
	synth->aq->aq_flush(1);	
	if(synth->output->play_mode->open_output()<0);
	{
	    synth->controls->ctl->cmsg(CMSG_FATAL, VERB_NORMAL,
		      "Couldn't open %s (`%c')",
		      synth->output->play_mode->id_name, synth->output->play_mode->id_character);
		
 		return TIMIDITY_FAILED;
	}

	
	return TIMIDITY_OK;  
}
char* tmdy_synth_get_output_mode_list(tmdy_synth_t* synth){
		PlayMode *pmp, **pmpp;
		char mode_list[80];
		int i=0;
	
		for (pmpp = synth->output->play_mode_list; pmp = *pmpp; pmpp++)
		{
			mode_list[i]=pmp->id_character;
			i++;
		}
		mode_list[i]='\0';
		return strdup(mode_list);
}

char tmdy_synth_get_output_mode(tmdy_synth_t* synth){
	return synth->output->play_mode->id_character;
}
__int32 tmdy_synth_get_output_encoding(tmdy_synth_t* synth){
	return synth->output->play_mode->encoding;
}

