/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    resample.h
*/

#ifndef ___RESAMPLE_H_
#define ___RESAMPLE_H_

#ifdef HAVE_CONFIH_H
#include "config.h"
#endif

enum {
	RESAMPLE_CSPLINE,
	RESAMPLE_LAGRANGE,
	RESAMPLE_GAUSS,
	RESAMPLE_NEWTON,
	RESAMPLE_LINEAR,
	RESAMPLE_NONE
};

typedef struct resample_rec {
	splen_t loop_start;
	splen_t loop_end;
	splen_t data_length;
} resample_rec_t;
/**** local definitions *****/
#define DEFAULT_GAUSS_ORDER	25
typedef sample_t (*resampler_t)(tmdy_struct_ex_t *, sample_t*, splen_t, resample_rec_t *);

struct _resample_ex_t {

int (*get_current_resampler)(tmdy_struct_ex_t *tmdy_struct);
int (*set_current_resampler)(tmdy_struct_ex_t *tmdy_struct, int type);
void (*initialize_resampler_coeffs)(tmdy_struct_ex_t *tmdy_struct);
int (*set_resampler_parm)(tmdy_struct_ex_t *tmdy_struct, int val);
sample_t (*do_resamplation)(tmdy_struct_ex_t *tmdy_struct, sample_t *src, splen_t ofs, resample_rec_t *rec);
sample_t *(*resample_voice)(tmdy_struct_ex_t *tmdy_struct, int v, int32 *countptr);
void (*pre_resample)(tmdy_struct_ex_t *tmdy_struct, Sample *sp);

/**** local variables ****/
float newt_coeffs[58][58];
float *gauss_table[(1<<FRACTION_BITS)];
int gauss_n;

int newt_n;
int32 newt_old_trunc_x;
int newt_grow;
int newt_max;
double newt_divd[60][60];
double newt_recip[60];
sample_t *newt_old_src;

resampler_t cur_resample;

sample_t resample_buffer[AUDIO_BUFFER_SIZE];
int resample_buffer_offset;

};

//extern resample_ex_t* resample_ex;

resample_ex_t* new_resample(tmdy_struct_ex_t *tmdy_struct);
void destroy_resample(resample_ex_t* resample);

#endif /* ___RESAMPLE_H_ */
