/******************************************************************************/
/*                                                                            */
/*  Interface independent functions (see rtsyn_common.c)                      */
/*                                                                            */
/******************************************************************************/
/* reset synth    */
void rtsyn_gm_reset(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_gs_reset(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_xg_reset(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_normal_reset(tmdy_struct_ex_t *tmdy_struct);

/* mode change                                            *
 * only in nomalmode program can accept reset(sysex) data */
void rtsyn_gm_modeset(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_gs_modeset(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_xg_modeset(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_normal_modeset(tmdy_struct_ex_t *tmdy_struct);

void rtsyn_init(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_close(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_play_event(tmdy_struct_ex_t *tmdy_struct, MidiEvent *ev);
void rtsyn_server_reset(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_stop_playing(tmdy_struct_ex_t *tmdy_struct);
int rtsyn_play_one_data (tmdy_struct_ex_t *tmdy_struct, int port, int32 dwParam1);
void rtsyn_play_one_sysex (tmdy_struct_ex_t *tmdy_struct, char *sysexbuffer, int exlen );
void rtsyn_play_calculate(tmdy_struct_ex_t *tmdy_struct);

int rtsyn_add_midi_port(tmdy_struct_ex_t *tmdy_struct, int port_id);
void rtsyn_delete_midi_port(tmdy_struct_ex_t *tmdy_struct, int port_id);
/******************************************************************************/
/*                                                                            */
/*  Interface dependent functions (see rtsyn_winmm.c rtsyn_portmidi.c)        */
/*                                                                            */
/******************************************************************************/
void rtsyn_get_port_list(tmdy_struct_ex_t *tmdy_struct);
int rtsyn_synth_start(tmdy_struct_ex_t *tmdy_struct);
void rtsyn_synth_stop(tmdy_struct_ex_t *tmdy_struct);
int rtsyn_play_some_data (tmdy_struct_ex_t *tmdy_struct);

#if defined(IA_WINSYN) || defined(IA_W32G_SYN)
int rtsyn_buf_check(tmdy_struct_ex_t *tmdy_struct);
#endif

void rtsyn_midiports_close(tmdy_struct_ex_t *tmdy_struct);
	
#define RTSYN (TMDY_RTSYN)
