#include "ServerConf.h"
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <limits.h>

//2003/08/04 modified by ortana.
#ifndef WIN32
#include <expat.h> // for expat XML parsing library - http://expat.sourceforge.net/
#endif//!WIN32

#include "dirchar.h"

#if !defined(WIN32)
#include <unistd.h>
#endif//!WIN32

#if !defined(_PREFPANE_)
#include "ServerLog.h"
#else
#include <syslog.h>
//#define DEBUG_CALL(call) call
#endif



//2003/08/04 added by ortana.
#ifndef WIN32
#define XMLPARSEAPI(type) type

class ConfigParser
{

public:

	static void init()
	{
		mBeginConfig = false;
	}


	static void startTag(void *inUserData, const XML_Char *inName, const XML_Char **inAtts);
	static void endTag(void *inUserData, const XML_Char *inName);
	static void dataHandler(void *inUserData, const XML_Char *inData, int inLen);

private:
	static string mTagName;
	static string mTagAttr;
	static string mAttrValue;
	static bool mBeginConfig;

};

string ConfigParser::mTagName;
string ConfigParser::mTagAttr;
string ConfigParser::mAttrValue;
bool ConfigParser::mBeginConfig = false;
#endif//!WIN32

//2003/08/04 added by ortana.
#ifdef WIN32
#include "WinProject\\stdafx.h"

namespace win_conf{
	const char SV_GROUP[] = "ServerConfig";

	const char SV_PORT[] = "port";
	const char SV_NAME[] = "name";
	const char SV_DES[] = "description";
	const char SV_VERSION[] = "version";
	const char SV_USER_ID[] = "user_id";
	const char SV_GROUP_ID[] = "group_id";
	const char SV_MAX_DOWN[] = "max_download";
	const char SV_MAX_UP[] = "max_upload";
	const char SV_MAX_USERS[] = "max_users";
	const char SV_MAX_PER_ADDR[] = "max_client_per_addr";
	const char SV_FILES_PATH[] = "files_path";
	const char SV_LOG_PATH[] = "log_path";
	const char SV_NEWS_PATH[] = "news_path";
	const char SV_NEWS_DIR_PATH[] = "news_dir_path";
	const char SV_AGREE_PATH[] = "agree_path";
	const char SV_ACCOUNT_DIR_PATH[] = "account_dir_path";
	const char SV_SOCKS_DETECT[] = "socks_detect";
	const char SV_IDLE_TIME[] = "idle_time";
	const char SV_BAN_TIME[] = "ban_time";
	const char SV_TRACKER_COUNT[] = "tracker_count";


	const char TR_GROUP[] = "TrackerConfig";


	//2003/08/07 added.
	const char SV_MAX_SPEED_UP[]		= "max_upload_speed";
	const char SV_MAX_SPEED_DOWN[]	= "max_download_speed";
	const char SV_USE_RATE[]				= "use_rate";
	const char 	SV_GREETING_CHECK[] = "greeting_check";
}

std::string CstringToString(const CString *str)
{
	char *buff = new char[ str->GetAllocLength() + 1 ];
	strcpy( buff , (LPCTSTR)*str );

	std::string string(buff);

	delete [] buff;

	return string;
}
#endif//WIN32

ServerConf::ServerConf()
{
	// possible security problem
	dirPermissions = 0777;
	filePermissions = 0777;

	maxDownloads = 5;
	maxUploads = 5;
	maxUsers = 50;
	maxClientsPerAddress = 3; // max number of client connections per ip
	idleTimeout = (10 * 60);
	banTimeout = (60 * 60); // default for temp ban is an hour
	serverPort = 5500;
	serverName = "Terra";
	serverDescription = "A Terra Server";
	//terra can't use thread news.why server version is 191?  fixed by ortana.
	serverVersion = 123; // version number the server sends to 1.5+ clients
	databaseReadOnly = false;
	databaseAddress = "localhost";
	textEncoding = "MacRoman"; // "Shift-JIS"
	//databaseUser = "";
	//databasePassword = "";
	//databaseName = "";
	//trackerList;
	string defaultTracker = "tracked.homedns.org";
	string defaultPass = "";
	//2003/07/26 added by ortana.
	confFile = "data\\winterra.xml";
	trackerList.push_back(TrackerEntry(defaultTracker, defaultPass));
#if defined(_PREFPANE_)
	rootPath = "/Library/HotlineServer/";
	agreementPath = "/etc/terra/agreement";
	newsPath = "/etc/terra/news";
	newsDirPath = "/etc/terra/newsdir/";
	accountsPath = "/etc/terra/accounts/";
	logsPath = "/private/var/log/terra/";
#else
	rootPath = "files/";
	agreementPath = "agreement"; // whatever...
	newsPath = "news";
	newsDirPath = "newsdir/";
	accountsPath = "accounts/";
#endif    
	socksDetectLevel = 0;
	// by default, we don't change these
	userID = 0;
	groupID = 0;
	//linkServer = "";

	//2003/08/07 added by ortana.
#ifdef _WINTERRA_
	max_upload_speed = 0;
	max_download_speed = 0;

	greeting_check = false;
	LoadRateConfig();
#endif//_WINTERRA_
}

void ServerConf::ReloadConf()
{
	if (!confFile.empty())
		ReadConf(confFile.c_str());
}

bool ServerConf::ReadConf(const char *inConfFile) throw (runtime_error)
{
	bool result = false;
	bool validConfig = true;
	int size;
	string errorString;
	trackerList.clear();


	//2003/07/25 modified by ortana.
	//2003/08/04 modified by ortana.
#ifdef WIN32
	CWinApp* pApp = AfxGetApp( );
	using namespace win_conf;

	serverPort = pApp->GetProfileInt(	 SV_GROUP , SV_PORT ,  5500);
	serverName = ::CstringToString( &pApp->GetProfileString( SV_GROUP , SV_NAME , "WinTerra" ));
	serverDescription  = ::CstringToString( &pApp->GetProfileString( SV_GROUP , SV_DES , "A WinTerra Server"));
	serverVersion = pApp->GetProfileInt(  SV_GROUP , SV_VERSION , 123);
	userID = pApp->GetProfileInt(  SV_GROUP , SV_USER_ID , 0);
	groupID = pApp->GetProfileInt(  SV_GROUP , SV_GROUP_ID , 0);

	maxDownloads = pApp->GetProfileInt(  SV_GROUP , SV_MAX_DOWN , 50);
	maxUploads = pApp->GetProfileInt(  SV_GROUP , SV_MAX_UP , 50);
	maxUsers = pApp->GetProfileInt(  SV_GROUP , SV_MAX_USERS ,50);
	maxClientsPerAddress = pApp->GetProfileInt(  SV_GROUP , SV_MAX_PER_ADDR , 3);

	rootPath =  ::CstringToString(&pApp->GetProfileString( SV_GROUP , SV_FILES_PATH , "files/" ));
	logsPath =  ::CstringToString(&pApp->GetProfileString( SV_GROUP , SV_LOG_PATH , "log/" ));
	newsPath =  ::CstringToString(&pApp->GetProfileString( SV_GROUP , SV_NEWS_PATH , "data/MessageBoard.txt"));
	newsDirPath =  ::CstringToString(&pApp->GetProfileString( SV_GROUP , SV_NEWS_DIR_PATH , "data/news/" ));
	agreementPath  =  ::CstringToString(&pApp->GetProfileString( SV_GROUP , SV_AGREE_PATH ,"data/Agreement.txt" ));
	accountsPath = ::CstringToString(&pApp->GetProfileString( SV_GROUP ,	SV_ACCOUNT_DIR_PATH , "Users/" ));
	socksDetectLevel = pApp->GetProfileInt(  SV_GROUP , SV_SOCKS_DETECT ,  0);

	idleTimeout = pApp->GetProfileInt(  SV_GROUP , SV_IDLE_TIME , 10 ) * 60;
	banTimeout = pApp->GetProfileInt(  SV_GROUP , SV_BAN_TIME , 60 ) * 60;

	int count = pApp->GetProfileInt(  SV_GROUP , SV_TRACKER_COUNT , 0 );


	//2003/08/07 added.
	max_upload_speed		= pApp->GetProfileInt(  SV_GROUP		,SV_MAX_SPEED_UP ,  0);
	max_download_speed	= pApp->GetProfileInt(	SV_GROUP		,SV_MAX_SPEED_DOWN ,0);
	use_rate = 	pApp->GetProfileInt(  SV_GROUP		,SV_USE_RATE			 , 0);
	greeting_check = pApp->GetProfileInt(  SV_GROUP		, SV_GREETING_CHECK , 0 );

	if( count == 0 ){return true;}

	CString tr;
	int i = 0;

	for( int i = 0 ; i < count ; i++ )
	{
		tr.Format("%s%d" ,  TR_GROUP , i );
		string address =  ::CstringToString(&pApp->GetProfileString( tr , "address" , ""));
		if(pApp->GetProfileString( tr , "pass" ,  "" ) == "" )
		{
			if( address != "" )
				trackerList.push_back(TrackerEntry( address , "" ));
		}
		else 
		{
			string pass = ::CstringToString(&pApp->GetProfileString( tr , "pass" ,  "" ));
			if( address != "" )
				trackerList.push_back(TrackerEntry( address , pass ));
		}
	}

	LoadRateConfig();

	return true;
#else
	int fd = open(inConfFile, O_RDONLY, 0);

	if (fd == -1){return FALSE;}

	//get size
	int size = lseek(fd, 0, SEEK_END);

	if (size == -1){return FALSE;}

	lseek(fd, 0, SEEK_SET);
	char *readBuf = new char[size];
	read(fd, readBuf, size);
	close(fd);

	// i might want to specify an encoding right here, in the future
	XML_Parser parser = XML_ParserCreate(NULL);

	XML_SetUserData(parser, this);
	XML_SetElementHandler(parser, ConfigParser::startTag, ConfigParser::endTag);
	XML_SetCharacterDataHandler(parser, ConfigParser::dataHandler);

	ConfigParser::init();

	if (XML_Parse(parser, readBuf, size, true))
	{
		confFile = inConfFile;
		result = true;
	}
	else
	{
		char errorBuf[512];
		snprintf(errorBuf, 511, "parser error at line %d: %s",
			XML_GetCurrentLineNumber(parser),
			XML_ErrorString(XML_GetErrorCode(parser)));

#if !defined(_PREFPANE_)
		ServerLog::ErrorLog(__FILE__, __LINE__, errorBuf);
#else

		syslog(LOG_ERR, errorBuf);
#endif
		errorString = errorBuf;
		validConfig = false;
	}

	XML_ParserFree(parser);
	delete[] readBuf;

	if (!validConfig)
		throw runtime_error(errorString);

	return result;

#endif//WIN32
}

/*
string XMLEscape(const char *pstr)
{
// escape a char string - remove &<>" and replace with escape codes
const char *p;
string ret;
for(p = pstr; *p; p++) {
switch( *p ) {
case '&': ret.append("&amp;",  5); break;
case '<': ret.append("&lt;",   4); break;
case '>': ret.append("&gt;",   4); break;
case '"': ret.append("&quot;", 6); break;
default:  ret.append(1, *p);
}
}
return ret;
}
*/

bool ServerConf::WriteConf(const char *inConfFile)
{
#ifdef WIN32
	CWinApp* pApp = AfxGetApp( );

	using namespace win_conf;
	pApp->WriteProfileInt(	 SV_GROUP , SV_PORT , serverPort );
	pApp->WriteProfileString( SV_GROUP , SV_NAME , serverName.c_str() );
	pApp->WriteProfileString( SV_GROUP , SV_DES , serverDescription.c_str() );
	pApp->WriteProfileInt(  SV_GROUP , SV_VERSION , serverVersion );
	pApp->WriteProfileInt(  SV_GROUP , SV_USER_ID , userID );
	pApp->WriteProfileInt(  SV_GROUP , SV_GROUP_ID , groupID );

	pApp->WriteProfileInt(  SV_GROUP , SV_MAX_DOWN , maxDownloads );
	pApp->WriteProfileInt(  SV_GROUP , SV_MAX_UP , maxUploads );
	pApp->WriteProfileInt(  SV_GROUP , SV_MAX_USERS , maxUsers );
	pApp->WriteProfileInt(  SV_GROUP , SV_MAX_PER_ADDR , maxClientsPerAddress);

	pApp->WriteProfileString( SV_GROUP , SV_FILES_PATH , rootPath.c_str() );
	pApp->WriteProfileString( SV_GROUP , SV_LOG_PATH , logsPath.c_str() );
	pApp->WriteProfileString( SV_GROUP , SV_NEWS_PATH , newsPath.c_str() );
	pApp->WriteProfileString( SV_GROUP , SV_NEWS_DIR_PATH , newsDirPath.c_str() );
	pApp->WriteProfileString( SV_GROUP , SV_AGREE_PATH ,agreementPath.c_str() );
	pApp->WriteProfileString( SV_GROUP ,	SV_ACCOUNT_DIR_PATH , accountsPath.c_str() );

	pApp->WriteProfileInt(  SV_GROUP , SV_SOCKS_DETECT , socksDetectLevel );

	pApp->WriteProfileInt(  SV_GROUP , SV_IDLE_TIME , (unsigned int)(idleTimeout / 60) );
	pApp->WriteProfileInt(  SV_GROUP , SV_BAN_TIME , (unsigned int)(banTimeout / 60) );

	//2003/08/07 added.
	pApp->WriteProfileInt(  SV_GROUP		,SV_MAX_SPEED_UP ,		max_upload_speed );
	pApp->WriteProfileInt(	SV_GROUP		,SV_MAX_SPEED_DOWN ,	max_download_speed );
	pApp->WriteProfileInt(  SV_GROUP		,SV_USE_RATE			 ,  use_rate );
	pApp->WriteProfileInt(	SV_GROUP		,SV_GREETING_CHECK , greeting_check);
	// tracker
	pApp->WriteProfileInt(  SV_GROUP , SV_TRACKER_COUNT , trackerList.size() );

	CString tr;
	TrackerList::iterator iter = trackerList.begin();
	int i = 0;
	while (iter != trackerList.end())
	{
		tr.Format("%s%d" , TR_GROUP , i++ );
		if( (*iter).addr != "" )
		{
			pApp->WriteProfileString( tr , "address" , (*iter).addr.c_str() );
			pApp->WriteProfileString( tr , "pass" ,  (*iter).pass.c_str() );
		}

		iter++;
	}

	return true;
#else
	bool result = false;

	int fd = open(inConfFile, O_RDWR | O_CREAT | O_TRUNC, 0777);

	//2003/08/04 modified by ortana. 
	//if (fd != -1)
	//{
	if( -1 == fd ){ return FALSE ;}

	char tempBuf[1024];

	string xmlConf =
		"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<terraconfig version=\"1\">\n";


	snprintf(tempBuf, 1023, "\t<port>%u</port>\n", serverPort);
	xmlConf.append(tempBuf);
	//snprintf(tempBuf, 1023, "\t<name><![CDATA[%s]]></name>\n",
	//    serverName.c_str());
	//snprintf(tempBuf, 1023, "\t<name>%s</name>\n",
	//    serverName.c_str());
	//xmlConf.append(tempBuf);

	xmlConf.append("\t<name>");
	xmlConf.append(serverName);
	xmlConf.append("</name>\n");

	//snprintf(tempBuf, 1023, "\t<description><![CDATA[%s]]></description>\n",
	//    serverDescription.c_str());
	//snprintf(tempBuf, 1023, "\t<description>%s</description>\n",
	//    serverDescription.c_str());
	//xmlConf.append(tempBuf);

	xmlConf.append("\t<description>");
	xmlConf.append(serverDescription);
	xmlConf.append("</description>\n");

	snprintf(tempBuf, 1023, "\t<version>%u</version>\n",
		serverVersion);
	xmlConf.append(tempBuf);

	snprintf(tempBuf, 1023, "\t<textencoding>%s</textencoding>\n",
		textEncoding.c_str());
	xmlConf.append(tempBuf);

	snprintf(tempBuf, 1023, "\t<userid>%u</userid>\n",
		userID);
	xmlConf.append(tempBuf);

	snprintf(tempBuf, 1023, "\t<groupid>%u</groupid>\n",
		groupID);
	xmlConf.append(tempBuf);

	snprintf(tempBuf, 1023, "\t<max type=\"downloads\">%u</max>\n",
		maxDownloads);
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<max type=\"uploads\">%u</max>\n", maxUploads);
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<max type=\"users\">%u</max>\n", maxUsers);
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<max type=\"clients_per_address\">%u</max>\n", maxClientsPerAddress);
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<path type=\"root\">%s</path>\n",
		rootPath.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<path type=\"accounts\">%s</path>\n",
		accountsPath.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<path type=\"logs\">%s</path>\n",
		logsPath.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<path type=\"news\">%s</path>\n",
		newsPath.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<path type=\"newsdir\">%s</path>\n",
		newsDirPath.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<path type=\"agreement\">%s</path>\n",
		agreementPath.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<database type=\"address\">%s</database>\n",
		databaseAddress.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<database type=\"user\">%s</database>\n",
		databaseUser.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<database type=\"password\">%s</database>\n",
		databasePassword.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<database type=\"name\">%s</database>\n",
		databaseName.c_str());
	xmlConf.append(tempBuf);
	string readOnly;
	if (databaseReadOnly)
		readOnly = "yes";
	else
		readOnly = "no";
	snprintf(tempBuf, 1023, "\t<database type=\"readonly\">%s</database>\n",
		readOnly.c_str());
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<socksdetect>%u</socksdetect>\n",
		socksDetectLevel);
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<time type=\"idle\">%u</time>\n",
		(unsigned int)(idleTimeout / 60)); // seconds to minutes
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<time type=\"ban\">%u</time>\n",
		(unsigned int)(banTimeout / 60)); // seconds to minutes
	xmlConf.append(tempBuf);

	snprintf(tempBuf, 1023, "\t<permissions type=\"directory\">0%o</permissions>\n",
		(unsigned int)dirPermissions);
	xmlConf.append(tempBuf);
	snprintf(tempBuf, 1023, "\t<permissions type=\"file\">0%o</permissions>\n",
		(unsigned int)filePermissions);
	xmlConf.append(tempBuf);

	snprintf(tempBuf, 1023, "\t<linkserver>%s</linkserver>\n", linkServer.c_str());
	xmlConf.append(tempBuf);

	TrackerList::iterator iter = trackerList.begin();
	while (iter != trackerList.end())
	{
		if ((*iter).pass.empty())
			snprintf(tempBuf, 1023, "\t<tracker>%s</tracker>\n", (*iter).addr.c_str());
		else
		{
			snprintf(tempBuf, 1023, "\t<tracker password=\"%s\">%s</tracker>\n",
				(*iter).pass.c_str(), (*iter).addr.c_str());
		}
		xmlConf.append(tempBuf);
		iter++;
	}

	xmlConf.append("</terraconfig>");

	write(fd, xmlConf.c_str(), xmlConf.length());

	//		}
	result = true;
	close(fd);


	return result;
#endif//WIN32
}


//2003/08/04 added by ortana.
#ifndef WIN32
void ConfigParser::startTag(void *inUserData,
														const XML_Char *inName, const XML_Char **inAtts)
{
	mTagName = inName;
	if (inAtts[0] != NULL)
	{
		mTagAttr = inAtts[0];
		mAttrValue = inAtts[1];
	}
	else
	{
		mTagAttr = "";
		mAttrValue = "";
	}

	if (!mBeginConfig)
	{
		if (mTagName == "terraconfig" &&
			mTagAttr == "version" &&
			mAttrValue == "1")
		{
			mBeginConfig = true;
		}
	}
	else
	{
		ServerConf *serverConf = (ServerConf *)inUserData;

		if (mTagName == "port")
		{
			serverConf->serverPort = 0;
		}
		else if (mTagName == "name")
		{
			serverConf->serverName = "";
		}
		else if (mTagName == "description")
		{
			serverConf->serverDescription = "";
		}
		else if (mTagName == "linkserver")
		{
			serverConf->linkServer = "";
		}
		else if (mTagName == "version")
		{
			serverConf->serverVersion = 0;
		}
		else if (mTagName == "textencoding")
		{
			serverConf->textEncoding = "";
		}
		else if (mTagName == "userid")
		{
			serverConf->userID = 0;
		}
		else if (mTagName == "groupid")
		{
			serverConf->groupID = 0;
		}
		else if (mTagName == "max" && mTagAttr == "type")
		{
			if (mAttrValue == "downloads")
			{
				serverConf->maxDownloads = 0;
			}
			else if (mAttrValue == "uploads")
			{
				serverConf->maxUploads = 0;
			}
			else if (mAttrValue == "users")
			{
				serverConf->maxUsers = 0;
			}
			else if (mAttrValue == "clients_per_address")
			{
				serverConf->maxClientsPerAddress = 0;
			}
		}
		else if (mTagName == "time" && mTagAttr == "type")
		{
			if (mAttrValue == "idle")
			{
				serverConf->idleTimeout = 0;
			}
			else if (mAttrValue == "ban")
			{
				serverConf->banTimeout = 0;
			}
		}
		else if (mTagName == "socksdetect")
		{
			serverConf->socksDetectLevel = 0;
		}
		else if (mTagName == "path" && mTagAttr == "type")
		{
			if (mAttrValue == "root")
			{
				serverConf->rootPath = "";
			}
			else if (mAttrValue == "accounts")
			{
				serverConf->accountsPath = "";
			}
			else if (mAttrValue == "logs")
			{
				serverConf->logsPath = "";
			}
			else if (mAttrValue == "news")
			{
				serverConf->newsPath = "";
			}
			else if (mAttrValue == "newsdir")
			{
				serverConf->newsDirPath = "";
			}
			else if (mAttrValue == "agreement")
			{
				serverConf->agreementPath = "";
			}
		}
		else if (mTagName == "permissions" && mTagAttr == "type")
		{
			if (mAttrValue == "directory")
			{
				serverConf->dirPermissions = 0;
			}
			else if (mAttrValue == "file")
			{
				serverConf->filePermissions = 0;
			}
		}
		else if (mTagName == "database" && mTagAttr == "type")
		{
			if (mAttrValue == "readonly")
			{
				serverConf->databaseReadOnly = false;
			}
			else if (mAttrValue == "address")
			{
				serverConf->databaseAddress = "";
			}
			else if (mAttrValue == "user")
			{
				serverConf->databaseUser = "";
			}
			else if (mAttrValue == "password")
			{
				serverConf->databasePassword = "";
			}
			else if (mAttrValue == "name")
			{
				serverConf->databaseName = "";
			}
		}
	}
}

void ConfigParser::endTag(void *inUserData, const XML_Char * inName )
{
	(void)inName;
	// assuming mTagName == inName
	if (mBeginConfig)
	{
		if (mTagName == "terraconfig")
		{
			mBeginConfig = false;
		}
		else
		{
			ServerConf *serverConf = (ServerConf *)inUserData;

			if (mTagName == "path" && mTagAttr == "type")
			{
				if (mAttrValue == "root" && serverConf->rootPath.length() > 1)
				{
					if (serverConf->rootPath[serverConf->rootPath.length() - 1] != DIRCHAR)
						serverConf->rootPath += DIRCHAR;
				}
				else if (mAttrValue == "accounts" && serverConf->accountsPath.length() > 1)
				{
					if (serverConf->accountsPath[serverConf->accountsPath.length() - 1] != DIRCHAR)
						serverConf->accountsPath += DIRCHAR;
				}
				else if (mAttrValue == "logs" && serverConf->logsPath.length() > 1)
				{
					if (serverConf->logsPath[serverConf->logsPath.length() - 1] != DIRCHAR)
						serverConf->logsPath += DIRCHAR;
				}
				else if (mAttrValue == "newsdir" && serverConf->newsDirPath.length() > 1)
				{
					if (serverConf->newsDirPath[serverConf->newsDirPath.length() - 1] != DIRCHAR)
						serverConf->newsDirPath += DIRCHAR;
				}
			}
		}
	}
}

void ConfigParser::dataHandler(void *inUserData, const XML_Char *inData, int inLen)
{
	if (mBeginConfig)
	{
		ServerConf *serverConf = (ServerConf *)inUserData;

		// ignore formatting
		if (inLen == 1 && (inData[0] == '\n' || inData[0] == '\t'))
			return;

		string tagData(inData, inLen);

		if (mTagName == "port")
		{
			serverConf->serverPort = strtoul(tagData.c_str(), 0, 10);
			DEBUG_CALL(printf("serverPort: %u\n", serverConf->serverPort));
		}
		else if (mTagName == "name")
		{
			serverConf->serverName.append(tagData);
			DEBUG_CALL(printf("serverName: %s\n", serverConf->serverName.c_str()));
		}
		else if (mTagName == "description")
		{
			serverConf->serverDescription.append(tagData);
			DEBUG_CALL(printf("serverDescription: %s\n", serverConf->serverDescription.c_str()));
		}
		else if (mTagName == "linkserver")
		{
			serverConf->linkServer.append(tagData);
			DEBUG_CALL(printf("linkServer: %s\n", serverConf->linkServer.c_str()));
		}
		else if (mTagName == "version")
		{
			serverConf->serverVersion = strtoul(tagData.c_str(), 0, 10);
			DEBUG_CALL(printf("serverVersion: %u\n", serverConf->serverVersion));
		}
		else if (mTagName == "textencoding")
		{
			serverConf->textEncoding.append(tagData);
			DEBUG_CALL(printf("textEncoding: %s\n", serverConf->textEncoding.c_str()));
		}
		else if (mTagName == "userid")
		{
			serverConf->userID = strtoul(tagData.c_str(), 0, 10);
			DEBUG_CALL(printf("userID: %u\n", serverConf->userID));
		}
		else if (mTagName == "groupid")
		{
			serverConf->groupID = strtoul(tagData.c_str(), 0, 10);
			DEBUG_CALL(printf("groupID: %u\n", serverConf->groupID));
		}
		else if (mTagName == "max" && mTagAttr == "type")
		{
			if (mAttrValue == "downloads")
			{
				serverConf->maxDownloads = strtoul(tagData.c_str(), 0, 10);
				DEBUG_CALL(printf("maxDownloads: %u\n", serverConf->maxDownloads));
			}
			else if (mAttrValue == "uploads")
			{
				serverConf->maxUploads = strtoul(tagData.c_str(), 0, 10);
				DEBUG_CALL(printf("maxUploads: %u\n", serverConf->maxUploads));
			}
			else if (mAttrValue == "users")
			{
				serverConf->maxUsers = strtoul(tagData.c_str(), 0, 10);
				DEBUG_CALL(printf("maxUsers: %u\n", serverConf->maxUsers));
			}
			else if (mAttrValue == "clients_per_address")
			{	
				serverConf->maxClientsPerAddress = strtoul(tagData.c_str(), 0, 10);
				DEBUG_CALL(printf("maxClientsPerAddress: %u\n", serverConf->maxClientsPerAddress));
			}
			else
			{
				DEBUG_CALL(printf("unknown max tag: %s = %s\n",
					mAttrValue.c_str(), tagData.c_str()));
			}
		}
		else if (mTagName == "time" && mTagAttr == "type")
		{
			if (mAttrValue == "idle")
			{
				// convert minutes to seconds
				serverConf->idleTimeout = 60 * strtol(tagData.c_str(), 0, 0);
				DEBUG_CALL(printf("idleTimeout: %u\n", (unsigned int)serverConf->idleTimeout));
			}
			else if (mAttrValue == "ban")
			{
				// convert minutes to seconds
				serverConf->banTimeout = 60 * strtol(tagData.c_str(), 0, 0);
				DEBUG_CALL(printf("banTimeout: %u\n", (unsigned int)serverConf->banTimeout));
			}
			else
			{
				DEBUG_CALL(printf("unknown time tag: %s = %s\n",
					mAttrValue.c_str(), tagData.c_str()));
			}
		}
		else if (mTagName == "socksdetect")
		{
			serverConf->socksDetectLevel = strtol(tagData.c_str(), 0, 0);
			// should validate this, needs to be 0,1,2
			DEBUG_CALL(printf("socksDetectLevel: %u\n", serverConf->socksDetectLevel));
		}
		else if (mTagName == "path" && mTagAttr == "type")
		{
			if (mAttrValue == "root")
			{
				serverConf->rootPath.append(tagData);
				DEBUG_CALL(printf("rootPath: %s\n", serverConf->rootPath.c_str()));
			}
			else if (mAttrValue == "accounts")
			{
				serverConf->accountsPath.append(tagData);
				DEBUG_CALL(printf("accountsPath: %s\n", serverConf->accountsPath.c_str()));
			}
			else if (mAttrValue == "logs")
			{
				serverConf->logsPath.append(tagData);
				DEBUG_CALL(printf("logsPath: %s\n", serverConf->logsPath.c_str()));
			}
			else if (mAttrValue == "news")
			{
				serverConf->newsPath.append(tagData);
				DEBUG_CALL(printf("newsPath: %s\n", serverConf->newsPath.c_str()));
			}
			else if (mAttrValue == "newsdir")
			{
				serverConf->newsDirPath.append(tagData);
				DEBUG_CALL(printf("newsDirPath: %s\n", serverConf->newsDirPath.c_str()));
			}
			else if (mAttrValue == "agreement")
			{
				serverConf->agreementPath.append(tagData);
				DEBUG_CALL(printf("agreementPath: %s\n", serverConf->agreementPath.c_str()));
			}
			else
			{
				DEBUG_CALL(printf("unknown path tag: %s = %s\n",
					mAttrValue.c_str(), tagData.c_str()));
			}
		}
		else if (mTagName == "tracker")
		{
			if (mTagAttr == "password")
			{
				serverConf->trackerList.push_back(TrackerEntry(tagData, mAttrValue));
				DEBUG_CALL(printf("tracker: %s password: %s\n", tagData.c_str(), mAttrValue.c_str()));
			}
			else
			{
				serverConf->trackerList.push_back(TrackerEntry(tagData, ""));
				DEBUG_CALL(printf("tracker: %s\n", tagData.c_str()));
			}
		}
		else if (mTagName == "permissions" && mTagAttr == "type")
		{
			if (mAttrValue == "directory")
			{
				serverConf->dirPermissions = strtol(tagData.c_str(), 0, 0);
				DEBUG_CALL(printf("dirPermissions: %s\n", tagData.c_str()));
			}
			else if (mAttrValue == "file")
			{
				serverConf->filePermissions = strtol(tagData.c_str(), 0, 0);
				DEBUG_CALL(printf("filePermissions: %s\n", tagData.c_str()));
			}
			else
			{
				DEBUG_CALL(printf("unknown permissions tag: %s = %s\n",
					mAttrValue.c_str(), tagData.c_str()));
			}
		}
		else if (mTagName == "database" && mTagAttr == "type")
		{
			if (mAttrValue == "readonly")
			{
				if (tagData == "yes" || tagData == "1" || tagData == "true")
				{
					serverConf->databaseReadOnly = true;
					DEBUG_CALL(printf("databaseReadOnly: yes\n"));
				}
				else
				{
					serverConf->databaseReadOnly = false;
					DEBUG_CALL(printf("databaseReadOnly: no\n"));
				}
			}
			else if (mAttrValue == "address")
			{
				serverConf->databaseAddress.append(tagData);
			}
			else if (mAttrValue == "user")
			{
				serverConf->databaseUser.append(tagData);
			}
			else if (mAttrValue == "password")
			{
				serverConf->databasePassword.append(tagData);
			}
			else if (mAttrValue == "name")
			{
				serverConf->databaseName.append(tagData);
			}
			else
			{
				DEBUG_CALL(printf("unknown database tag: %s = %s\n",
					mAttrValue.c_str(), tagData.c_str()));
			}
		}
		else
		{
			DEBUG_CALL(printf("unknown/ignored tag: %s[%s] = %s\n",
				mTagName.c_str(), mAttrValue.c_str(), tagData.c_str()));
		}
	}
}
#endif//!WIN32

//2003/08/07 added by ortana.
#ifdef _WINTERRA_
void ServerConf::LoadRateConfig()
{
	rateList.exclude.clear();
	rateList.rate.clear();
	std::ifstream stream( RATE_CONF_PATH );
	if( !stream ){ return; }
	char buff[256];
	typedef boost::tokenizer<boost::char_separator<char> > tokenizer;
	boost::char_separator<char> sep(":");
	raw_rate_conf.assign("");
	while( stream.getline( buff , 256 , '\n' ) )
	{
		std::string s( buff );
		raw_rate_conf.append( s + "\r\n" );



		if( s[0] == '|' ){ continue; }
		if( s == "" ){ continue; }


		if( s[0] == '>' )
		{
			tokenizer tokens(s, sep);
			tokenizer::iterator tok_iter = tokens.begin();
			int exRate = -1;
			std::string exName;
			int cnt = 0;
			for( tok_iter ; tok_iter != tokens.end() ; ++tok_iter )
			{
				if( 0 == cnt )
				{
					exName = *tok_iter;
					exName = exName.substr( 1 , exName.size() - 1 );//remove ">"
				}
				else
				{
					int exRate = atoi( (*tok_iter).c_str() );
				}
				cnt++;
			}

			if( exRate > 0 )
			{
				rateList.exclude.push_back(exName);
				rateList.exRate = exRate;
				printf( "exname :%s  rate: %s\n" , exName.c_str() , (*tok_iter).c_str() );
			}
		}
		else
		{
			tokenizer tokens2(s, sep);
			tokenizer::iterator tok_iter = tokens2.begin();
			int rate = -1;
			std::string loginName;
			int cnt2 = 0;
			for( tok_iter ; tok_iter != tokens2.end() ; ++tok_iter )
			{
				if( 0 == cnt2 )
				{
					loginName = *tok_iter;
				}
				else
				{
					rate = atoi( (*tok_iter).c_str() );
				}
				cnt2++;
			}

			if( rate > 0 )
			{
				rateList.rate[ loginName ] = rate;

				printf( "loginName : %s rate: %d\n" , loginName.c_str() , rate );
			}
		}

	}
	stream.close();
}

void ServerConf::SaveRateConfig()
{
	FILE *fp = fopen( RATE_CONF_PATH , "w" );
	if( fp == NULL ){ return; }

	if( 1 > fwrite( raw_rate_conf.c_str() , raw_rate_conf.size() , 1 , fp ) )
	{
		return;
	}

	fclose( fp );


	LoadRateConfig();
}
#endif//_WINTERRA