// HLSocket has basic functions for handshake, sending, and receiving hotline packets

#ifndef HL_SOCKET_H
#define HL_SOCKET_H

#include "BufferedSocket.h"
#include "HLPacket.h"

class HLSocketCallback
{
    protected:
        virtual void HandlePacket(HLPacket &inPacket) = 0;
        virtual void OnClose() = 0;

friend class HLSocket;
};

class HLSocket : public BufferedSocket
{
    public:
        HLSocket(int inDescriptor, struct sockaddr_in* inRemoteAddress);
        virtual ~HLSocket();
        
        void SendPacket(HLPacket &inPacket);
        
        void SetCallback(HLSocketCallback *inCallback)
            { mCallback = inCallback; }
        
    protected:
        HLPacket mPacket;
        HLSocketCallback *mCallback;
        u_int32_t mPacketCounter;
		bool mGotMagic;
        bool mWaitingHeader;
        
        void DataAvailable();
        void OnClose();
};

#endif // HL_SOCKET_H

