// HLPacket is a representation of a Hotline packet. It contains a
// list of HLObjects and it has functions for flattening the packet
// into a byte stream for sending or instantiating the class
// from a received byte stream. It also provides useful functions
// for constructing a packet and processing the data objects in a packet.

#ifndef HL_PACKET_H
#define HL_PACKET_H 1

#include "HLObject.h"

typedef struct
{
	u_int32_t type PACKED;
	u_int32_t id PACKED;
	u_int32_t flag PACKED;
	u_int32_t size1 PACKED;
	u_int32_t size2 PACKED;
} HL_PACKET_HEADER;

using namespace std;

class HLPacket : public HLObjectList
{
	public:
		 HLPacket();
		 HLPacket(u_int32_t inType, u_int32_t inID = 0, u_int32_t inFlag = 0);
		~HLPacket();
		
		void SetHeader(HL_PACKET_HEADER *ioHdr);
		
		u_int32_t GetType() const;
		u_int32_t GetID() const;
		u_int32_t GetFlag() const;
		u_int32_t GetSize() const
            { return HLObjectList::GetSize() + sizeof(HL_PACKET_HEADER); }
		
		void SetID(u_int32_t inID)
			{ mID = inID; }
		
		void Flatten(char *outBytes, u_int32_t &ioSize, u_int32_t inID) throw (logic_error);
		
		void Clear();
		
	private:
		u_int32_t mType;
		u_int32_t mID;
		u_int32_t mFlag;
};

#endif //HL_PACKET_H


