// Wrapper around pthreads. Used by HLServer, HLClient, HLTransfer, and InspectSOCKS
// The server is heavily threaded, so it might be useful at some point to create a thread pool

#ifndef THREAD_H
#define THREAD_H

#if defined(USE_PTHREADS)
#include <pthread.h>
#endif // USE_PTHREADS

class BThread
{
	public:
		BThread();
		virtual ~BThread();
		
		void Create();
		
	protected:
		virtual void Run() = 0;
		
#if defined (USE_PTHREADS)
		pthread_t mPThread;
#endif //USE_PTHREADS

#if defined (USE_WIN32THREADS)
		unsigned long mThreadId;
#endif //USE_WIN32THREADS
		
	private:

#if defined (USE_PTHREADS)
	static void* _Proc(void* inThis);
#endif //USE_PTHREADS

#if defined (USE_WIN32THREADS)
	static void _Proc(void* inThis);
#endif //USE_WIN32THREADS
};

#endif // THREAD_H


