#ifndef ASYNC_DNS_H
#define ASYNC_DNS_H

#include <string>

#if !defined(WIN32)
#include <netinet/in.h>
#endif // WIN32

using namespace std;

class AsyncDNSLookupThread;

class AsyncDNSCallback
{
public:
	virtual ~AsyncDNSCallback();
protected:
	virtual void HostLookup(const string &inName, const struct in_addr *inAddr)
		{ (void)inName; (void)inAddr; }
	virtual void NameLookup(const string &inHost, const string &inName)
		{ (void)inHost; (void)inName; }

friend class AsyncDNSLookupThread;
friend class AsyncDNS;
};

class AsyncDNS
{
public:
	AsyncDNS();
	// get an ip from a domain name
	void HostByName(const string &inName, AsyncDNSCallback *inCallback);
	// get a domain name from an ip
	void ResolveHost(const string &inHost, AsyncDNSCallback *inCallback);
protected:
	static AsyncDNSLookupThread *mThread;

friend class AsyncDNSCallback;
};

#endif // ASYNC_DNS_H