/*
 *  serialize.h
 *  serialize
 *
 *  Created by Jason Toffaletti on Fri Apr 18 2003.
 *  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
 *
 */
#ifndef FLATTENABLE_H
#define FLATTENABLE_H

#include <iostream>
#include <exception>

#define FLAT_INVALID_TYPE (flat::flat_type_code)0

namespace flat {

typedef unsigned int flat_type_code;

class flattenable
{
public:
	virtual const flat_type_code type_code() const = 0;
	virtual const bool is_fixed_size() const = 0;
	virtual const unsigned int flattened_size() const = 0;
	
	virtual void flatten(std::ostream &strm) const = 0;
	virtual void unflatten(std::istream &strm) = 0;
};

template <typename T> class basic_flattenable : public flattenable
{
public:
	virtual const bool is_fixed_size() const { return true; }	
	virtual const unsigned int flattened_size() const { return sizeof(T); }
	
	virtual const T hton(const T t1) const { return t1; }
	virtual const T ntoh(const T t1) const { return t1; }

	// conversion
	operator T() const { return m_data; }
	
	// assignment
	T operator = (const T t1)
	{
		m_data = t1;
		return m_data;
	}

	// add prefix
	basic_flattenable &operator ++ ()
	{
		m_data++;
		return *this;
	}
	
	// add postfix
	basic_flattenable &operator ++ (int unused)
	{
		(void)unused;
		++m_data;
		return *this;
	}
	
	// minus prefix
	basic_flattenable &operator -- ()
	{
		m_data--;
		return *this;
	}
	
	// minus postfix
	basic_flattenable &operator -- (int unused)
	{
		(void)unused;
		--m_data;
		return *this;
	}
	
	// addition assignment
	T operator += (const T t1)
	{
		return m_data += t1;
	}
	
	// subtraction assignment
	T operator -= (const T t1)
	{
		return m_data -= t1;
	}
	
	virtual void flatten(std::ostream &strm) const
	{
		T tmp = hton(m_data);
		strm.write(reinterpret_cast<const char*>(&tmp), sizeof(T));
	}
	
	virtual void unflatten(std::istream &strm)
	{
		T tmp;
		strm.read(reinterpret_cast<char*>(&tmp), sizeof(T));
		m_data = ntoh(tmp);
	}
protected:
	T m_data;
};

} // end namespace flat

#endif // FLATTENABLE_H
