#ifdef __cplusplus
extern "C" {
#endif

#include <sys/timeb.h>

int gettimeofday(struct timeval *tp, struct timezone *tzp)
{
    struct _timeb w32tv;
    (void)tzp; /* just ignore the timezone stuff */
    _ftime(&w32tv);
    tp->tv_sec = w32tv.time;
    tp->tv_usec = w32tv.millitm * 1000; /* convert from milli to micro seconds */
    return 0;
}

#ifdef __cplusplus
} // extern "C"
#endif
