// Embedded web server support
#ifndef WEBSERVER_H
#define WEBSERVER_H

#if defined(_HTTPD_)
#include "BThread.h"
#include "libhttpd/httpd.h"
#include <string>
#include "HLProtocol.h"
#include "HLAccount.h"

using namespace std;

class HLTransfer;

class WebServer : public BThread
{
    public:
        WebServer();
        ~WebServer();
        
    private:
        void Run();
        static int preloadAuthenticate(httpd *inServer);
        static void indexPage(httpd *inServer);
        static void loginPage(httpd *inServer);
        static void shutdownPage(httpd *inServer);
        static void reconfigPage(httpd *inServer);
        static void configPage(httpd *inServer);
        static void statusPage(httpd *inServer);
        static void newsPage(httpd *inServer);
        static void broadcastPage(httpd *inServer);
        static void transferProgress(HLTransfer *inTransfer, string &outProgressString);
        
        HLAccount mUserAccount;
        httpd *mServer;
};

#endif // defined(_HTTPD_)

#endif // WEBSERVER_H


