#if defined(CONFIG_THREADEDNEWS)

#include <string>
#include <fstream>
#include "HLPacket.h"

using namespace std;

namespace NewsUtils
{
	typedef struct {
		u_int32_t time_low PACKED;
		u_int16_t time_mid PACKED;
		u_int16_t time_hi_and_version PACKED;
		u_int8_t  clock_seq_hi_and_reserved PACKED;
		u_int8_t  clock_seq_low PACKED;
		u_int8_t  node[6] PACKED;
	} uuid_t;
	
	/* used by main_map_block */
	typedef struct {
		u_int32_t block_offset PACKED;
		u_int32_t map_count PACKED;
	} map_t;
	
	/* this block gives the offsets to the actual post_map_blocks (see below)    */
	typedef struct {
		map_t     map[32] PACKED;
	} main_map_block;
	
	/* used by post_map_block */
	typedef struct {
		u_int32_t id PACKED;                 /* internal block id */
		u_int32_t offset PACKED;             /* block offset within file (0x200 base)    */
	} p_map_t;
	
	/* these are littered throughout the news file to give the actual whereabouts
	of posts and their offsets within the news file */
	typedef struct {
		p_map_t   map[32] PACKED;
	} post_map_block;
	
	/* this is the first (header) block in the news file */
	typedef struct {
		u_int8_t  magic[8] PACKED;           /* "HLNZ" + version, is \0\0\0\2 in all files tested */
		
		uuid_t    uuid PACKED;               /* internal UUID used as category ID        */
					
		u_int32_t flag1 PACKED;              /* numb of posts + 1 ?                      */
		u_int32_t flag2 PACKED;              /* seems to be constant '\0'                */
		u_int32_t block_size PACKED;         /* block size used in the file (256 byte)   */
		u_int32_t num_objects PACKED;
		u_int32_t quick_send_len PACKED;     /* the size of the last object in the file  */
		u_int32_t post_count PACKED;         /* post count */
		u_int32_t first_post_offset PACKED;  /* using 0x200 as offset */
		u_int32_t last_post_offset PACKED;   /* using 0x200 as offset */
		u_int32_t flag9 PACKED;
		u_int32_t flag10 PACKED;
		u_int32_t flag11 PACKED;
		u_int32_t flag12 PACKED;
		u_int32_t flag13 PACKED;
		u_int32_t max_title_len PACKED;      /* max len of a title (0x1f = 31) */
		u_int32_t unknown[3] PACKED;
		
		u_int8_t cat_name_len PACKED;        /* category name length */
		char category_name[31] PACKED;   /* the category name itself */
	} main_hdr_block;
	
	typedef struct {
		u_int32_t base PACKED;
		u_int32_t sec PACKED;
	} post_date;
	
	typedef struct {
		u_int32_t data_offset PACKED;        /* block offset of post data */
		u_int32_t unknown01 PACKED;          /* usually 0xC0              */
		
		u_int8_t  mime_type_len PACKED;      /* mime type length          */
		u_int8_t  mime_type[27] PACKED;      /* the category name itself  */
		
		u_int32_t internal_id PACKED;        /* the id of the post        */
		u_int32_t previous_thread PACKED;    /* block offset of thread    */
		u_int32_t next_thread PACKED;        /* see previous_thread       */
		u_int32_t parent_thread PACKED;      /* see previous_thread       */
		u_int32_t reply_thread PACKED;       /* see previous_thread       */
		
		post_date date PACKED;
		
		u_int32_t unknown02 PACKED;          /* usually \0                */
		
		u_int8_t  post_title_len PACKED;
		u_int8_t  post_title[63] PACKED;
		u_int8_t  author_len PACKED;
		u_int8_t  author[31] PACKED;
		u_int8_t  post_uuid_len PACKED;
		u_int8_t  post_uuid[91] PACKED;
	} post_info_block;
	
	/* when reading in the post text, read until null */
	
	typedef struct {
		u_int32_t unknown PACKED;            /* constant '\0'         */
		
		u_int32_t post_len PACKED;           /* post_text length ... if more than 236
											we have to read multiple blocks of post
											text in 256-byte blocks */
											
		u_int8_t  mime_len PACKED;           /* not including \0 term */
		u_int8_t  mime[11] PACKED;				/* mime type string, \0, the post text  */
	//	u_int8_t  post_text[236];	//it is 236 bytes for 256 byte blocks --jcb
		u_int8_t  post_text[ZERO_SIZE_ARRAY_SIZE] PACKED;
	} post_data_block;
	
	typedef struct {
		u_int8_t  post_text[ZERO_SIZE_ARRAY_SIZE] PACKED;
	} extended_post_data_block;
	
	typedef struct {
		post_info_block           info PACKED;
		post_data_block           data PACKED;
		extended_post_data_block  extended PACKED;
		u_int8_t                  has_extended PACKED;
	} post_block;
	
	void scanPathToPacket(const string &inPath, HLPacket &ioPacket);
	bool getFileHeader(istream &inFile, main_hdr_block &outHdr);
	bool getPostHeaders(const string &inPath, HLPacket &ioPacket);
	bool getPostData(const string &inPath, u_int16_t inThreadID, HLPacket &ioPacket);
	bool setFileHeader(ostream &inFile, const main_hdr_block &inHdr);
	bool createNewsFile(const string &inPath, const string &inFileName);
	bool addPost(const string &inPath, u_int32_t inParentID, const string &inTitle, const string &inAuthor, const char *inPostData, u_int16_t inPostDataLen);
}

#endif // CONFIG_THREADEDNEWS

