// A resizable buffer used by BufferedSocket and HLTransfer

#ifndef DYNAMIC_BUFFER_H
#define DYNAMIC_BUFFER_H

#define kMinBufferSize	(8 * 1024)

class DynamicBuffer
{
    public:
        DynamicBuffer(size_t inSize = 0);
        ~DynamicBuffer();
        
        size_t Size()
            { return mSize; }
        
        char *Ptr(size_t inPos = 0)
		{
			assert(inPos < mSize);
			return &mPtr[inPos];
		}
        
        char *Resize(size_t inSize);
        
        void CopyInto(const char *inBytes, const size_t inSize);
        
        void RemoveFrom(const size_t inSize);
        
        void Free();
        
    protected:
        
        size_t mSize;
        char *mPtr;
};

#endif // DYNAMIC_BUFFER_H

