#include "BMutex.h"
#include <string.h>

BMutex::BMutex()
{
#if defined(USE_PTHREADS)
    // this code might not be very crossplatform
    // needs testing
    pthread_mutexattr_t attr;
    int err = pthread_mutexattr_init(&attr);
    assert(err == 0);
    
    err = pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
    assert(err == 0);
    
	err = pthread_mutex_init(&mMutex, &attr);
	if (err != 0)
	{
		DEBUG_CALL(printf("error initing mutex(%d): %s\n", err, strerror(err)));
        // throw a runtime error
	}
#endif // USE_PTHREADS

#if defined(USE_WIN32THREADS)
	// This function returns no errors
	::InitializeCriticalSection( &mCriticalSection );
#endif
}

BMutex::~BMutex()
{
#if defined(USE_PTHREADS)
	int err = pthread_mutex_destroy(&mMutex);
	if (err != 0)
	{
		DEBUG_CALL(printf("error destroying mutex(%d): %s\n", err, strerror(err)));
	}
#endif // USE_PTHREADS

#if defined(USE_WIN32THREADS)
	::DeleteCriticalSection( &mCriticalSection );
#endif // USE_WIN32THREADS
}

bool BMutex::TryLock()
{
#if defined (USE_PTHREADS)
	return (pthread_mutex_trylock(&mMutex) == 0);
#endif //USE_PTHREADS

#if defined (USE_WIN32THREADS)
	return ::TryEnterCriticalSection( &mCriticalSection ) ? true : false;
#endif //USE_WIN32THREADS
}

void BMutex::Lock()
{
#if defined (USE_PTHREADS)
	int err = pthread_mutex_lock(&mMutex);
	if (err != 0)
	{
		DEBUG_CALL(printf("error locking mutex(%d): %s\n", err, strerror(err)));
	}
#endif //USE_PTHREADS

#if defined (USE_WIN32THREADS)
	::EnterCriticalSection( &mCriticalSection );
#endif //USE_WIN32THREADS
}

void BMutex::Unlock()
{
#if defined (USE_PTHREADS)
	int err = pthread_mutex_unlock(&mMutex);
    if (err != 0)
    {
        DEBUG_CALL(printf("error unlocking mutex(%d): %s\n", err, strerror(err)));
    }
#endif //USE_PTHREADS

#if defined (USE_WIN32THREADS)
	::LeaveCriticalSection( &mCriticalSection );
#endif //USE_WIN32THREADS
}
