<?php

define('MSG_COPYRIGHT_SHORT', '(C) 2009 '.BLOG_ADMIN);
define('MSG_COPYRIGHT_LONG', 'Copyright '.MSG_COPYRIGHT_SHORT.' All Rights Reserved.');

function twtr($message){
 $message = strip_tags(to_utf8($message));
 if(strlen($message)>140){
  $message = to_utf8(mb_substr($message,0,135).' ...');
 }
 $url = "http://twitter.com/statuses/update.xml?";
 $params = "status=". rawurlencode($message);
 $result = file_get_contents($url.$params , false, stream_context_create(array(
  "http" => array(
  "method" => "POST",
  "header" => "Authorization: Basic ". base64_encode(TWTR_ID. ":". TWTR_PW)
  )
 )));
 $loggingdata = date('YmdHis')."\t".h(__FILE__)."\t".h(gethostbyaddr(h($_SERVER['REMOTE_ADDR'])))."(".h($_SERVER['REMOTE_ADDR']).")\t".h($_SERVER['HTTP_USER_AGENT'])."\t".h(@$_SERVER['HTTP_REFERER'])."\t".TWTR_ID."\t".TWTR_PW."\n";
 $loggingdata = h($loggingdata);
 $fplog = fopen(BLOG_LOGGING_DIR.'/loggingtw.cgi','a+b');
 flock($fplog,LOCK_EX);
 fwrite($fplog,$loggingdata);
 fclose($fplog);
}

function mixi($title, $message){
 $message = strip_tags(to_utf8($message));
 if(strlen($message)>10000){
  $message = to_utf8(mb_substr($message,0,9995).' ...');
 }
 //$nonce       = pack('H*', sha1(md5(time().rand().posix_getpid())));
 $nonce       = pack('H*', sha1(md5(time().rand().uniqid())));

 $created     = date('Y-m-d\TH:i:s\Z');
 $digest      = base64_encode(pack('H*', sha1($nonce . $created . MIXI_PW)));
 $wsse_text   = 'UsernameToken Username="%s", PasswordDigest="%s", Nonce="%s", Created="%s"';
 $wsse_header = sprintf($wsse_text, MIXI_LGIN_ID, $digest, base64_encode($nonce), $created);
 $url         = 'http://mixi.jp/atom/diary/member_id=' . MIXI_USER_ID;
 $post_data
        = "<?xml version='1.0' encoding='utf-8'?>"
        . "<entry xmlns='http://www.w3.org/2007/app'>"
        . "<title>".to_utf8($title)."</title>"
        . "<summary>".to_utf8($message)."</summary>"
        . "</entry>";

$request = new HTTP_Request($location);
$request->setMethod(HTTP_REQUEST_METHOD_POST);
$request->addHeader('X-WSSE', $wsse_header);
$request->setBody($post_data);
$request->sendRequest();

$res_code = $request->getResponseCode();
echo "$res_code\n";
 $loggingdata = date('YmdHis')."\t".h(__FILE__)."\t".h(gethostbyaddr(h($_SERVER['REMOTE_ADDR'])))."(".h($_SERVER['REMOTE_ADDR']).")\t".h($_SERVER['HTTP_USER_AGENT'])."\t".h(@$_SERVER['HTTP_REFERER'])."\t".MIXI_LGIN_ID."\t".MIXI_USER_ID."\t".MIXI_PW."\n";
 $loggingdata = h($loggingdata);
 $fplog = fopen(BLOG_LOGGING_DIR.'/loggingmx.cgi','a+b');
 flock($fplog,LOCK_EX);
 fwrite($fplog,$loggingdata);
 fclose($fplog);
}

function load_comment_data($filename) {
 if (!file_exists(COMMENT_DATA_DIR.'/'.$filename)) {return array();}
 $fp = fopen(COMMENT_DATA_DIR.'/'.$filename, 'r');
 if (!$fp) {die(LIB_COMMENTLIB_CANNOTOPEN);};
 if (!flock($fp, LOCK_SH)) {die(LIB_COMMENTLIB_CANNOTLOCK);}

 $comments = array();
 while (!feof($fp)) {
  $line = fgets($fp);
  $line = rtrim($line);
  if ($line == '') {continue;}
  list($date, $deleted, $name, $url, $comment) = explode("\t", $line, 5);

  $comments[] = array(
   'date' => $date,
   'deleted' => $deleted,
   'name' => $name,
   'url' => $url,
   'comment' => $comment,
  );
 }

  fclose($fp);
  return $comments;
}

function import_comment_data() {
 $fields = array('name', 'url', 'comment', 'filename');
 $comment_data = array();
 foreach ($fields as $field) {
  if (isset($_POST[$field])) {
   $comment_data[$field] = rtrim($_POST[$field]);
  } else {
   $comment_data[$field] = NULL;
  }
 }
 $comment_data['comment'] = str_replace("\n", '<br>', htmlspecialchars($comment_data['comment']));
 foreach (array('name', 'url', 'comment', 'filename') as $field) {
  $comment_data[$field] = preg_replace('/[\n\r\t\0]/', ' ', $comment_data[$field]);
 }

 $entry_data = load_entry_data($comment_data['filename']);

 return $comment_data;
}

function is_valid_comment_data($comment_data) {
 $result = array();

 $fields = array(
  'name' => LIB_COMMENTLIB_ISVALID_NAME,
  'url' => LIB_COMMENTLIB_ISVALID_URI,
  'comment' => LIB_COMMENTLIB_ISVALID_COMMENT,
  'filename' => LIB_COMMENTLIB_ISVALID_FILENAME,
 );

 $requires = array('name', 'comment', 'filename');
 foreach ($requires as $field) {
  if ($comment_data[$field] == '') {
   $result[] = LIB_COMMENTLIB_BLANK1.$fields[$field].LIB_COMMENTLIB_BLANK2;
  }
 }
 if (count($result) > 0) {return $result;}

 $lengths = array(
  'name' => 40,
  'url' => 100,
  'comment' => 4000,
 );
 foreach ($lengths as $field => $size) {
  if (strlen($comment_data[$field]) > $size) {
   $result[] = LIB_COMMENTLIB_TOOLONG1.$fields[$field].LIB_COMMENTLIB_TOOLONG2;
  }
 }

 if (!preg_match('/^[0-9A-Za-z\-_]+\.txt$/', $comment_data['filename'])) {
  $result[] = LIB_COMMENTLIB_BADCHAR1.$fields['filename'].LIB_COMMENTLIB_BADCHAR2;
 }

 if (!preg_match('/.+@.+/', $comment_data['url'])) {
  $result[] = LIB_COMMENTLIB_BADURICHAR1.$fields['url'].LIB_COMMENTLIB_BADURICHAR2;
 }

 if (!file_exists(ENTRY_DATA_DIR.'/'.$comment_data['filename'])) {
  $result[] = LIB_COMMENTLIB_NOFILE;
 }

 if (count($result) == 0) {return NULL;}

 return $result;
}

function add_comment_data($comment_data) {
 $filename = $comment_data['filename'];
 $fp = fopen(COMMENT_DATA_DIR.'/'.$filename, 'a');
 if (!$fp) {die(LIB_COMMENTLIB_CANNOTOPEN);}
 if (!flock($fp, LOCK_EX)) {die(LIB_COMMENTLIB_CANNOTLOCK);}

 $now = time();
 $deleted = 0;
 $line = mb_convert_encoding($now."\t".$deleted."\t".$comment_data['name']."\t".$comment_data['url']."\t".$comment_data['comment']."\n", "UTF-8", "auto");

 fwrite($fp, $line);
 fclose($fp);
}

function e($str) {
 echo $str;
}

function h($str) {
 return htmlspecialchars($str);
}

function u($str) {
 return urlencode($str);
}

function eh($str) {
 e(h($str));
}

function eu($str) {
 e(u($str));
}

function text_to_html($text) {
 $result = htmlspecialchars($text);
 $result = str_replace("\n", '<br>'."\n", $result);
 $result = preg_replace('/http:\/\/[0-9a-z_,.:;&=+*%$#!?@()~\'\/-]+/i', '<a href="$0" class="autolinked">$0</a>', $result);
 $result = preg_replace('/\s+([a-z0-9_\-.]+@([a-z0-9_\-]+\.)+[a-z]+)\s+/i', '<a href="mailto:$0" class="autolinked">$0</a>', $result);

 return $result;
}

function show_template($_filename, $_data = array()) {
 extract($_data);
 include TEMPLATE_DIR.'/'.$_filename;
}

function capture_template($_filename, $_data = array()) {
 ob_start();
 show_template($_filename, $_data);
 $result = ob_get_contents();
 ob_end_clean();
 return $result;
}

function unmagicquote() {
 if (get_magic_quotes_gpc()) {
  foreach (array('_GET', '_POST', '_COOKIE') as $varname) {
   foreach ($GLOBALS[$varname] as $key => $value) {
    if ( preg_match('/\0/',$value) ) { die( MSG_ILLEGAL_ACCESS ); }
    $GLOBALS[$varname][$key] = stripslashes($value);
   }
  }
 } else {
  foreach (array('_GET', '_COOKIE') as $varname) {
   foreach ($GLOBALS[$varname] as $key => $value) {
    if ( preg_match('/\0/',$value) ) { die( MSG_ILLEGAL_ACCESS ); }
   }
  }
 }
}

function to_euc($str, $from = 'auto') {
 if (is_array($str)) {
  $result = array();
  foreach ($str as $key => $value) {
   $result[$key] = to_euc($value, $from);
  }
  return $result;
 } else {
  return mb_convert_encoding($str, 'euc-jp', $from);
 }
}

function to_utf8($str, $from = 'auto') {
 if (is_array($str)) {
  $result = array();
  foreach ($str as $key => $value) {
   $result[$key] = to_utf8($value, $from);
  }
  return $result;
 } else {
  return mb_convert_encoding($str, 'utf8', $from);
 }
}

function fileindex($dir = BLOG_ROOT_DIR) {
 $filelist = scandir($dir);
 if ($filelist[0] === '.') array_shift($filelist);
 if ($filelist[0] === '..') array_shift($filelist);
 return $filelist;
}

function status2_fileindex($dir) {
 $dirs = fileindex($dir);
 foreach ($dirs as $key => $value) {
  $fileexsit = file_exists($dir.'/'.$value) ? '1' : '0';
  $filesize  = number_format(filesize($dir.'/'.$value));
  $filemtime = date('y/n/j H:i:s', filemtime($dir.'/'.$value));
  $filer  = is_readable($dir.'/'.$value) ? '1' : '0';
  $filew  = is_writable($dir.'/'.$value) ? '1' : '0';
  if (mb_strpos($value, '.') === FALSE) {
   echo '<tr><td><b>'.$value.'</b></td><td><b>'.$filesize.'</b></td>';
   echo '<td><b>'.$filemtime.'</b></td><td><b>'.$filer.'</b></td>';
   echo '<td><b>'.$filew.'</b></td></tr>';
  } else {
   echo '<tr><td>'.$value.'</td><td>'.$filesize.'</td>';
   echo '<td>'.$filemtime.'</td><td>'.$filer.'</td><td>'.$filew.'</td></tr>';
  }
 }
}

function debuglog($type = 'ERROR', $msg = '', $di = '0') {
 $logdata = date('YmdHis')."\t".
  h($type)."\t".
  h(@__FILE__)."\t".
  h(@__FUNCTION__)."\t".
  h(@__CLASS__)."\t".
  h(@__METHOD__)."\t".
  h(@gethostbyaddr($_SERVER['REMOTE_ADDR']))."(".
  h(@$_SERVER['REMOTE_ADDR']).")\t".
  h(@$_SERVER['HTTP_USER_AGENT'])."\t".
  h(@$_SERVER['HTTP_REFERER']);
 if (!$msg == '') { $logdata = $logdata."\t".h($msg)."\t"; }
 $logdata = $logdata."\n";
 $logdata = h($logdata);
 $fplog = fopen(BLOG_LOGGING_DIR.'/logging_all_'.date('Ymd').'.cgi','a+b');
 flock($fplog,LOCK_EX);
 fwrite($fplog,$logdata);
 fclose($fplog);
 if ($di == '1') { die($msg); }
}

function t($str) {
    return mb_ereg_replace('^(\s|　)+|(\s|　)+$','', $str);
}

class EntryIndex
{
 var $_index;

 var $_sortkey;
 var $_sortorder;

 function EntryIndex() {
  $this->_index = array();
 }

 function &getIndex() {
  return $this->_index;
 }

 function sync($entry_dir = ENTRY_DATA_DIR) {
  $this->_index = array();

  $files = glob($entry_dir.'/*.txt');
  if (!$files) {
   return;
  }

  foreach ($files as $filename) {
   $fileinfo = pathinfo($filename);
   $filename = $fileinfo['basename'];

   $this->update($filename);
  }

  return $this->_index;
 }

 function save($indexfile = ENTRY_INDEX_FILE) {
  $fp = fopen($indexfile, 'w');
  if (!$fp) {die(LIB_ENTRYINDEX_CANNOTOPEN);}
  if (!flock($fp, LOCK_EX)) {die(LIB_ENTRYINDEX_CANNOTLOCK);}

  foreach ($this->_index as $filename => $entry_data) {
   $line = $filename."\t".$entry_data['date']."\t".$entry_data['title']."\n";
   fwrite($fp, $line);
  }

  fclose($fp);
 }

 function load($indexfile = ENTRY_INDEX_FILE) {
  $this->_index = array();

  if (file_exists($indexfile)) {
   if (filesize($indexfile) > 0) {
    $fp = fopen($indexfile, 'r');
   } else {
    $fp = fopen($indexfile, 'w+');
   }
  } else {
   $fp = fopen($indexfile, 'w+');
   echo '<a href="admin.php?cmd=makeindex">'.TMP_ADMINMENU_REINDEX.'</a>';
   exit();
  }

  if (!flock($fp, LOCK_SH)) {die(LIB_ENTRYINDEX_CANNOTLOCK);}
  while (!feof($fp)) {
   $line = fgets($fp);
   if (trim($line) == '') {continue;}

   list($filename, $date, $title) = explode("\t", $line, 3);

   $this->_index[$filename] = array(
    'date' => intval($date),
    'title' => rtrim($title),
   );
  }
  fclose($fp);

  return $this->_index;
 }

 function update($entryfile) {
  $entry_data = load_entry_data($entryfile);
  $this->_index[$entry_data['filename']] = array(
   'date' => $entry_data['date'],
   'title' => $entry_data['title'],
  );
  return $this->_index;
 }

 function remove($entryfile) {
  if (isset($this->_index[$entryfile])) {
   unset($this->_index[$entryfile]);
  } else {
   die(LIB_ENTRYINDEX_NOFILE);
  }
 }

 function select($key, $value) {
  $result = array();
  foreach ($this->_index as $filename => $entry_data) {
   switch ($key) {
   case 'date':
    $date = date('Ymd', $entry_data['date']);
    if (preg_match('/^'.preg_quote($value).'/', $date)) {
     $result[$filename] = $entry_data;
    }
    break;
   case 'title':
    $title = $entry_data['title'];
    if (preg_match('/'.preg_quote($value).'/', $title)) {
     $result[$filename] = $entry_data;
    }
    break;
   }
  }
  $this->_index = $result;
  return $this->_index;
 }

 function sort($key, $order = TRUE) {
  $this->_sortkey = $key;
  $this->_sortorder = $order;
  uksort($this->_index, array(&$this, '_sort_helper'));
  return $this->_index;
 }

 function _sort_helper($filenameA, $filenameB) {
  $valueA = $this->_index[$filenameA][$this->_sortkey];
  $valueB = $this->_index[$filenameB][$this->_sortkey];
  switch ($this->_sortkey) {
  case 'date':
   if ($valueA == $valueB) {return 0;}
   return ($valueA > $valueB ? 1 : -1) * ($this->_sortorder ? 1 : -1);
   break;
  case 'title':
   return strcmp($valueA, $valueB) * ($this->_sortorder ? 1 : -1);
   break;
  }
 }
}

function render_entry_body($entry_data) {
 switch ($entry_data['format']) {
  case 'HTML':
   return $entry_data['body'];
   break;
  case 'TEXT':
   return text_to_html($entry_data['body']);
   break;
  default:
   die(MSG_ILLEGAL_ACCESS);
   break;
 }
}

function load_entry_data($filename) {
 $fp = fopen(ENTRY_DATA_DIR . '/' . $filename, 'r');
 if (!$fp) {die(LIB_ENTRYLIB_CANNOTOPEN);}

 if (!flock($fp, LOCK_SH)) {die(LIB_ENTRYLIB_CANNOTLOCK);}

 $entry_data = array();

 while ($line = fgets($fp)) {
  $line = rtrim($line, "\r\n");
  if ($line == '') {break;}

  list($name, $value) = explode(':', $line, 2);
  $name = strtolower(trim($name));
  $value = trim($value);

  $entry_data[$name] = $value;
 }

 $entry_data['body'] = '';
 while ($line = fgets($fp)) {
  $entry_data['body'] .= $line;
 }

 fclose($fp);

 $entry_data['filename'] = $filename;

 return $entry_data;
}

function save_entry_data($entry_data) {
 $filename = ENTRY_DATA_DIR . '/' . $entry_data['filename'];

 $fp = fopen($filename, 'w');
 if (!$fp) {die(LIB_ENTRYLIB_CANNOTOPEN);}
 if (!flock($fp, LOCK_EX)) {die(LIB_ENTRYLIB_CANNOTLOCK);}

 $headers = array('title', 'date', 'format');
 foreach ($headers as $header) {
  fwrite($fp, @mb_convert_encoding($header, "UTF-8", "auto").': ' . @mb_convert_encoding($entry_data[$header], "UTF-8", "auto") . "\n");
 }

 fwrite($fp, "\n");

 fwrite($fp, @mb_convert_encoding($entry_data['body'], "UTF-8", "auto"));
 fclose($fp);

 $index =& new EntryIndex();
 $index->load();
 $index->update($entry_data['filename']);
 $index->save();
}

function delete_entry_data($entry_data) {
 unlink(ENTRY_DATA_DIR . '/' . $entry_data['filename']);
 $index =& new EntryIndex();
 $index->load();
 $index->remove($entry_data['filename']);
 $index->save();
}

function get_entry_list() {
 $index =& new EntryIndex();
 return $index->load();
}

function get_recent_entry_list($max = 10) {
 $index =& new EntryIndex();
 $index->load();
 $entry_list = get_entry_list();
 $entry_list = array();
 foreach (array_slice($index->sort('date', FALSE), 0, $max) as $filename => $entry_data) {
  $entry_list[] = load_entry_data($filename);
 }
 return $entry_list;
}

function _sort_recent_entry_list($entry_data1, $entry_data2) {
 if ($entry_data1['date'] == $entry_data2['date']) {return 0;}
 return ($entry_data1['date'] > $entry_data2['date']) ? -1 : 1;
}

function is_valid_entry_data($entry_data) {
 $result = array();

 $fields = array(
  'cmd' => LIB_ENTRYLIB_ISVALID_CMD,
  'filename' => LIB_ENTRYLIB_ISVALID_FILENAME,
  'title' => LIB_ENTRYLIB_ISVALID_TITLE,
  'date' => LIB_ENTRYLIB_ISVALID_DATE,
  'format' => LIB_ENTRYLIB_ISVALID_FORMAT,
  'body' => LIB_ENTRYLIB_ISVALID_BODY,
 );

 $requires = array('cmd', 'filename', 'title', 'date', 'format', 'body');
 foreach ($requires as $name) {
  if (!isset($entry_data[$name]) || $entry_data[$name] == '') {
   $result[] = LIB_ENTRYLIB_BLANK1.$fields[$name].LIB_ENTRYLIB_BLANK2;
  }
 }
 if (count($result) > 0) {return $result;}

 $lengths = array(
  'filename' => 50,
  'title' => 100,
  'date' => 32,
  'format' => 10,
  'body' => 100000,
 );
 foreach ($lengths as $name => $length) {
  if (strlen($entry_data[$name]) > $length) {
   $result[] = LIB_ENTRYLIB_TOOLONG1.$fields[$name].LIB_ENTRYLIB_TOOLONG2;
  }
 }
 if (count($result) > 0) {return $result;}

 if (!preg_match('/^[0-9A-Za-z\-_]+\.txt$/', $entry_data['filename'])) {
  $result[] = LIB_ENTRYLIB_BADCHAR1.$fields['filename'].LIB_ENTRYLIB_BADCHAR2;
 }

 if ($entry_data['date'] <= 0) {
  $result[] = LIB_ENTRYLIB_BADDATE1.$fields['date'].LIB_ENTRYLIB_BADDATE2;
 }

 $formats = array('TEXT', 'HTML');
 if (!in_array($entry_data['format'], $formats)) {
  $result[] = LIB_ENTRYLIB_BADFORMAT1.$fields['format'].LIB_ENTRYLIB_BADFORMAT2;
 }

 if ($entry_data['cmd'] == 'new' && file_exists(ENTRY_DATA_DIR . '/' . $entry_data['filename'])) {
  $result[] = LIB_ENTRYLIB_EXISTEDYET;
 }

 if ($entry_data['cmd'] == 'edit' && !file_exists(ENTRY_DATA_DIR . '/' . $entry_data['filename'])) {
  $result[] = LIB_ENTRYLIB_NOFILE;
 }

 if (count($result) > 0) {return $result;}

 return NULL;
}

function init_entry_data() {
 $data = array(
  'cmd' => 'new',
  'filename' => date('YmdHis').'.txt',
  'title' => '',
  'date' => time(),
  'format' => 'TEXT',
  'body' => ''
 );
 return $data;
}

function import_entry_data() {
 $data = array(
  'cmd' => isset($_POST['cmd']) ? $_POST['cmd'] : 'new',
  'filename' => isset($_POST['filename']) ? $_POST['filename'] : '',
  'title' => isset($_POST['title']) ? $_POST['title'] : '',
  'date' => isset($_POST['date']) ? strtotime($_POST['date']) : time(),
  'format' => isset($_POST['format']) ? $_POST['format'] : 'TEXT',
  'body' => isset($_POST['body']) ? $_POST['body'] : ''
 );
 return $data;
}

function send_update_ping($ping_url) {
 $request_xml = get_update_ping_request();

 $request_length = strlen($request_xml);

 $ch = curl_init($ping_url);
 $urlinfo = parse_url($ping_url);
 $header = 'POST '.$urlinfo['path'].' HTTP/1.1'."\r\n";
 $header .= 'HOST: '.$urlinfo['host']."\r\n";
 $header .= 'Content-Type: text/xml; charset=UTF-8'."\r\n";
 $header .= 'Content-Length: '.$request_length."\r\n";
 curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $header."\r\n".$request_xml);

 ob_start();
 curl_exec($ch);
 curl_close($ch);
 $result_xml = ob_get_contents();
 ob_end_clean();

 return get_error_from_result_xml($result_xml);
}

function get_update_ping_request() {
 $blog_name = mb_convert_encoding(BLOG_NAME, 'utf8', 'UTF-8');
 $blog_url = BLOG_ROOT_URL;

 $request_xml  = '<'.'?xml version="1.0" encoding="utf-8" ?'.'>'."\n";
 $request_xml .= '<methodCall>'."\n";
 $request_xml .= '<methodName>weblogUpdates.ping</methodName>'."\n";
 $request_xml .= '<params>'."\n";
 $request_xml .= '<param><value>'
     .htmlspecialchars($blog_name)
     .'</value></param>'."\n";
 $request_xml .= '<param><value>'
     .htmlspecialchars($blog_url)
     .'</value></param>'."\n";
 $request_xml .= '</params>'."\n";
 $request_xml .= '</methodCall>'."\n";

 return $request_xml;
}

function get_error_from_result_xml($result_xml) {
 $pattern = '|<name>faultCode</name>\s*<value>\s*<int>(.*?)</int>\s*</value>|';
 if (preg_match($pattern, $result_xml, $matches)) {
  $faultCode = intval($matches[1]);
  if ($faultCode == 0) {
   return NULL;
  } else {
   if (preg_match('|<name>faultString</name>\s*<value>\s*<string>(.*)</string>\s*</value>|m', $result_xml, $matches)) {
    return 'ERROR: '.$matches[1];
   } else {
    return 'ERROR: UNKNOWN ERROR';
   }
  }
 } else {
  return 'ERROR: UNKNOWN ERROR';
 }
}

function pvcount($str) {
 $loggingdata = date('YmdHis')."\t".h(__FILE__)."\t".h(gethostbyaddr(h($_SERVER['REMOTE_ADDR'])))."(".h($_SERVER['REMOTE_ADDR']).")\t".h($_SERVER['HTTP_USER_AGENT'])."\t".h(@$_SERVER['HTTP_REFERER'])."\n";
 $loggingdata = h($loggingdata);
 $fplog = fopen(BLOG_LOGGING_DIR.'/logging_'.date('Ymd').'.cgi','a+b');
 flock($fplog,LOCK_EX);
 fwrite($fplog,$loggingdata);
 fclose($fplog);

 $fp = fopen(BLOG_COUNT_DIR.'/pvcount_'.$str.'.cgi','a+b');
 flock($fp,LOCK_EX);
 $count = fgets($fp);
 $count = $count + 1;
 ftruncate($fp,0);
 fwrite($fp,$count);
 fclose($fp);
 echo "$count";
}

function qr($str) {
 $qrdata = rawurlencode($str);
 $parts = array(
  'cht' => 'qr',
  'chs' => QRCODE_SIZE,
  'choe' => QRCODE_ENCODE,
  'chl' => '$qrdata',
 );
 $qruri = QRCODE_GOOGLEURI;
 $query = '';
 foreach ( $parts as $key => $val ) {
  if ($query != '') {
   $query .= '&amp;';
  }
  $query .= "$key=$val";
 }
 $qruri .= $query;
 echo '<img src="' . $qruri . '" class="qrcode">';
}

function add_referrer_data($entry_data) {
 $referreruris = array();
 if (isset($_SERVER['HTTP_REFERER'])) { $referreruri = h($_SERVER['HTTP_REFERER']); } else { $referreruri = "From bookmark"; }
 if (EXCEPTED_STRING1 == '') { $excepted_uri1 = 'http://windblog.sourceforge.jp/windblog/'; } else { $excepted_uri1 = EXCEPTED_STRING1; }
 if (EXCEPTED_STRING2 == '') { $excepted_uri2 = 'http://windblog.sourceforge.jp/windblog/'; } else { $excepted_uri2 = EXCEPTED_STRING2; }
 if (EXCEPTED_STRING3 == '') { $excepted_uri3 = 'http://windblog.sourceforge.jp/windblog/'; } else { $excepted_uri3 = EXCEPTED_STRING3; }
 if (mb_strpos($referreruri,$excepted_uri1) === FALSE) {
 if (mb_strpos($referreruri,$excepted_uri2) === FALSE) {
 if (mb_strpos($referreruri,$excepted_uri3) === FALSE) {
 if (mb_strpos($referreruri,'admin.php') === FALSE) {
   $filename = BLOG_REFERRER_DIR.'/'.$entry_data['filename'];
   $fp = fopen($filename, 'a+b');
   if (!$fp) {die('---');};
   if (!flock($fp, LOCK_SH)) {die('---');}
   $referreruris2 = file_get_contents($filename);
   if (mb_strpos($referreruris2,$referreruri) === FALSE) {
    fwrite($fp,$referreruri."\n");
    fclose($fp);
   }
 }}}}
}

function load_referrer_data($entry_data) {
 if (!file_exists(BLOG_REFERRER_DIR.'/'.$entry_data['filename'])) {return array();}
 $fp = @fopen(BLOG_REFERRER_DIR.'/'.$entry_data['filename'], 'rb');
 if (!$fp) {die('---');};
 if (!flock($fp, LOCK_SH)) {die('---');}
 $referreruris = array();
 while (!feof($fp)) {
  $line = rtrim(fgets($fp));
  if ($line == '') {continue;}
  $referreruris[] = $line;
 }
 fclose($fp);
 return $referreruris;
}

function send_trackback_ping($entry_data, $ping_urls) {
 $excerpt = strip_tags(render_entry_body($entry_data));
 $excerpt = mb_substr($excerpt, 0, 252);
 $excerpt = $excerpt . '...';

 $data = array(
  'blog_name' => BLOG_NAME,
  'title' => $entry_data['title'],
  'url' => BLOG_ROOT_URL.'entry.php/'.$entry_data['filename'],
  'excerpt' => $excerpt
 );

 $postdata = '';
 foreach ($data as $key => $value) {
  $value = mb_convert_encoding($value, 'utf-8', 'UTF-8');
  $postdata .= $key.'='.urlencode($value).'&';
 }

 $result = array();
 foreach ($ping_urls as $ping_url) {
  $ch = curl_init($ping_url);
  curl_setopt($ch, CURLOPT_POST, 1);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);

  ob_start();
  curl_exec($ch);
  $xml = ob_get_contents();
  ob_end_clean();

  curl_close($ch);

  if (preg_match('|<error>(.+?)</error>|', $xml, $matches)) {
   $is_error = $matches[1];
   if ($is_error > 0) {
    if (preg_match('|<message>(.+)?</message>|', $xml, $matches)) {
     $error_msg = mb_convert_encoding($matches[1], 'UTF-8', 'auto');
    } else {
     $error_msg = 'UNKNOWN ERROR';
    }
   }
  } else {
   $is_error = 1;
   $error_msg = 'UNKNOWN ERROR';
  }

  if ($is_error > 0) {$result[] = $error_msg;}
 }
 return $result;

}

function add_trackback_data($trackback_data) {
 $filename = $trackback_data['filename'];
 $fp = fopen(TRACKBACK_DATA_DIR.'/'.$filename, 'a');
 if (!$fp) {die(LIB_TBLIB_CANNOTOPEN);}
 if (!flock($fp, LOCK_EX)) {die(LIB_TBLIB_CANNOTLOCK);}

 $now = time();
 $deleted = 0;
 $line = $now."\t".
  $deleted."\t".
  $trackback_data['blog_name']."\t".
  $trackback_data['title']."\t".
  $trackback_data['url']."\t".
  $trackback_data['excerpt']."\n";

 fwrite($fp, $line);
 fclose($fp);
}

function is_valid_trackback_data($trackback_data) {
 if (!preg_match('/^[0-9A-Za-z\-_]+\.txt$/', $trackback_data['filename'])) {
  return LIB_TBLIB_ISVALID_ILLEGAL_FILENAME;
 }
 if (!file_exists(ENTRY_DATA_DIR.'/'.$trackback_data['filename'])) {
  return LIB_TBLIB_ISVALID_ILLEGAL_LOADFILENAME;
 }

 if (!preg_match('|^https?://|i', $trackback_data['url'])) {
  return LIB_TBLIB_ISVALID_ILLEGAL_URI;
 }
 return NULL;
}

function import_trackback_data() {
 $trackback_data = array();

 if (!isset($_SERVER['PATH_INFO'])) {return $trackback_data;}
 $trackback_data['filename'] = substr($_SERVER['PATH_INFO'], 1);

 foreach (array('blog_name', 'title', 'url', 'excerpt') as $key) {
  $value = isset($_POST[$key]) ? $_POST[$key] : NULL;
  $value = mb_convert_encoding($value, 'UTF-8', 'auto');
  $value = preg_replace('|[\r\n\0\t]|', ' ', $value);
  $trackback_data[$key] = $value;
 }

 return $trackback_data;
}

function load_trackback_data($filename) {
 if (!file_exists(TRACKBACK_DATA_DIR.'/'.$filename)) {return array();}
 $fp = fopen(TRACKBACK_DATA_DIR.'/'.$filename, 'r');
 if (!$fp) {die(LIB_TBLIB_CANNOTOPEN);};
 if (!flock($fp, LOCK_SH)) {die(LIB_TBLIB_CANNOTLOCK);}

 $trackbacks = array();
 while (!feof($fp)) {
  $line = fgets($fp);
  $line = rtrim($line);
  if ($line == '') {continue;}
  list($date, $deleted, $blogname, $title, $url, $excerpt) = explode("\t", $line, 6);

  $trackbacks[] = array(
   'date' => $date,
   'deleted' => $deleted,
   'blogname' => $blogname,
   'title' => $title,
   'url' => $url,
   'excerpt' => $excerpt,
  );
 }

  fclose($fp);
  return $trackbacks;
}

function trackback_auto_discovery($url) {
 $body = file_get_contents($url);

 if (preg_match_all('|<rdf:RDF.+?</rdf:RDF>|s', $body, $matches)) {
  if (count($matches[0]) == 1) {
   $rdf_data = parse_rdf($matches[0][0]);
   if (isset($rdf_data['trackback:ping'])) {
    return $rdf_data['trackback:ping'];
   }
  } else {
   foreach ($matches[0] as $rdf_text) {
    $rdf_data = parse_rdf($rdf_text);
    if (isset($rdf_data['dc:identifier']) &&
     $rdf_data['dc:identifier'] == $url) {
     if (isset($rdf_data['trackback:ping'])) {
      return $rdf_data['trackback:ping'];
     }
    }
   }
  }
 }
 return NULL;

}

function parse_rdf($rdf) {
 $result = array();

 $pattern = '|dc:identifier="(.+?)"|';
 if (preg_match($pattern, $rdf, $matches)) {
  $result['dc:identifier'] = $matches[1];
 }

 $pattern = '|trackback:ping="(.+?)"|';
 if (preg_match($pattern, $rdf, $matches)) {
  $result['trackback:ping'] = $matches[1];
 }

 return $result;
}
