<?php
require_once 'config.php';

main();

function main() {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $trackback_data = import_trackback_data();

        $result = is_valid_trackback_data($trackback_data);
        if (!$result) {
            add_trackback_data($trackback_data);
        }

        header('content-type: text/xml; charset=utf-8');
        show_template('trackback_result.tmpl', array('message' => $result));
    } elseif (isset($_GET['__mode'] ) && $_GET['__mode'] == 'rss') {
        $filename = isset($_SERVER['PATH_INFO']) ? substr($_SERVER['PATH_INFO'], 1) : '';
        if (!preg_match('|^[0-9A-Za-z_\-]+\.txt$|', $filename)) {
            die(MSG_ENTRY_SAVE_NOFILENAME);
        }
        $entry_data = to_utf8(load_entry_data($filename));
        $trackbacks = to_utf8(load_trackback_data($filename));
        header('content-type: text/xml; charset=utf8');
        show_template('trackback_rss.tmpl', array(
            'entry_data' => $entry_data,
            'trackbacks' => $trackbacks,
        ));
    }
}