<?php

function send_trackback_ping($entry_data, $ping_urls) {
    $excerpt = strip_tags(render_entry_body($entry_data));
    $excerpt = mb_substr($excerpt, 0, 252);
    $excerpt = $excerpt . '...';

    $data = array(
        'blog_name' => BLOG_NAME,
        'title' => $entry_data['title'],
        'url' => BLOG_ROOT_URL.'entry.php/'.$entry_data['filename'],
        'excerpt' => $excerpt
    );

    $postdata = '';
    foreach ($data as $key => $value) {
        $value = mb_convert_encoding($value, 'utf-8', 'UTF-8');
        $postdata .= $key.'='.urlencode($value).'&';
    }

    $result = array();
    foreach ($ping_urls as $ping_url) {
        $ch = curl_init($ping_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);

        ob_start();
        curl_exec($ch);
        $xml = ob_get_contents();
        ob_end_clean();

        curl_close($ch);

        if (preg_match('|<error>(.+?)</error>|', $xml, $matches)) {
            $is_error = $matches[1];
            if ($is_error > 0) {
                if (preg_match('|<message>(.+)?</message>|', $xml, $matches)) {
                    $error_msg = mb_convert_encoding($matches[1], 'UTF-8', 'auto');
                } else {
                    $error_msg = 'UNKNOWN ERROR';
                }
            }
        } else {
            $is_error = 1;
            $error_msg = 'UNKNOWN ERROR';
        }

        if ($is_error > 0) {$result[] = $error_msg;}
    }
    return $result;

debuglog('Info', 'TrackBack(Send)');

}

function add_trackback_data($trackback_data) {
    $filename = $trackback_data['filename'];
    $fp = fopen(TRACKBACK_DATA_DIR.'/'.$filename, 'a');
    if (!$fp) {die(LIB_TBLIB_CANNOTOPEN);}
    if (!flock($fp, LOCK_EX)) {die(LIB_TBLIB_CANNOTLOCK);}

    $now = time();
    $deleted = 0;
    $line = $now."\t".
        $deleted."\t".
        $trackback_data['blog_name']."\t".
        $trackback_data['title']."\t".
        $trackback_data['url']."\t".
        $trackback_data['excerpt']."\n";

    fwrite($fp, $line);
    fclose($fp);

debuglog('Info', 'TrackBack(Receive)');
}

function is_valid_trackback_data($trackback_data) {
    if (!preg_match('/^[0-9A-Za-z\-_]+\.txt$/', $trackback_data['filename'])) {
        return LIB_TBLIB_ISVALID_ILLEGAL_FILENAME;
    }
    if (!file_exists(ENTRY_DATA_DIR.'/'.$trackback_data['filename'])) {
        return LIB_TBLIB_ISVALID_ILLEGAL_LOADFILENAME;
    }

    if (!preg_match('|^https?://|i', $trackback_data['url'])) {
        return LIB_TBLIB_ISVALID_ILLEGAL_URI;
    }
    return NULL;
}

function import_trackback_data() {
    $trackback_data = array();

    if (!isset($_SERVER['PATH_INFO'])) {return $trackback_data;}
    $trackback_data['filename'] = substr($_SERVER['PATH_INFO'], 1);

    foreach (array('blog_name', 'title', 'url', 'excerpt') as $key) {
        $value = isset($_POST[$key]) ? $_POST[$key] : NULL;
        $value = mb_convert_encoding($value, 'UTF-8', 'auto');
        $value = preg_replace('|[\r\n\0\t]|', ' ', $value);
        $trackback_data[$key] = $value;
    }

    return $trackback_data;
}

function load_trackback_data($filename) {
    if (!file_exists(TRACKBACK_DATA_DIR.'/'.$filename)) {return array();}
    $fp = fopen(TRACKBACK_DATA_DIR.'/'.$filename, 'r');
    if (!$fp) {die(LIB_TBLIB_CANNOTOPEN);};
    if (!flock($fp, LOCK_SH)) {die(LIB_TBLIB_CANNOTLOCK);}

    $trackbacks = array();
    while (!feof($fp)) {
        $line = fgets($fp);
        $line = rtrim($line);
        if ($line == '') {continue;}
        list($date, $deleted, $blogname, $title, $url, $excerpt) = explode("\t", $line, 6);

        $trackbacks[] = array(
            'date' => $date,
            'deleted' => $deleted,
            'blogname' => $blogname,
            'title' => $title,
            'url' => $url,
            'excerpt' => $excerpt,
        );
    }

     fclose($fp);
     return $trackbacks;
}

function trackback_auto_discovery($url) {
    $body = file_get_contents($url);

    if (preg_match_all('|<rdf:RDF.+?</rdf:RDF>|s', $body, $matches)) {
        if (count($matches[0]) == 1) {
            $rdf_data = parse_rdf($matches[0][0]);
            if (isset($rdf_data['trackback:ping'])) {
                return $rdf_data['trackback:ping'];
            }
        } else {
            foreach ($matches[0] as $rdf_text) {
                $rdf_data = parse_rdf($rdf_text);
                if (isset($rdf_data['dc:identifier']) &&
                    $rdf_data['dc:identifier'] == $url) {
                    if (isset($rdf_data['trackback:ping'])) {
                        return $rdf_data['trackback:ping'];
                    }
                }
            }
        }
    }
    return NULL;

debuglog('Info', 'TrackBackAutoDiscovery');

}

function parse_rdf($rdf) {
    $result = array();

    $pattern = '|dc:identifier="(.+?)"|';
    if (preg_match($pattern, $rdf, $matches)) {
        $result['dc:identifier'] = $matches[1];
    }

    $pattern = '|trackback:ping="(.+?)"|';
    if (preg_match($pattern, $rdf, $matches)) {
        $result['trackback:ping'] = $matches[1];
    }

    return $result;
}
