/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import weka.LocalString;
import weka.core.FastVector;
import weka.gui.ExtensionFileFilter;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.BIFParser;
import weka.gui.graphvisualizer.DotParser;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.HierarchicalBCEngine;
import weka.gui.graphvisualizer.LayoutCompleteEvent;
import weka.gui.graphvisualizer.LayoutCompleteEventListener;
import weka.gui.graphvisualizer.LayoutEngine;
import weka.gui.visualize.PrintablePanel;

public class GraphVisualizer
extends JPanel
implements GraphConstants,
LayoutCompleteEventListener {
    protected FastVector m_nodes = new FastVector();
    protected FastVector m_edges = new FastVector();
    protected LayoutEngine m_le;
    protected GraphPanel m_gp;
    protected String graphID;
    protected JButton m_jBtSave;
    private final String ICONPATH = "weka/gui/graphvisualizer/icons/";
    private FontMetrics fm = this.getFontMetrics(this.getFont());
    private double scale = 1.0;
    private int nodeHeight = 2 * this.fm.getHeight();
    private int nodeWidth = 24;
    private int paddedNodeWidth = 32;
    private final JTextField jTfNodeWidth = new JTextField(3);
    private final JTextField jTfNodeHeight = new JTextField(3);
    private final JButton jBtLayout;
    private int maxStringWidth = 0;
    private int[] zoomPercents = new int[]{10, 25, 50, 75, 100, 125, 150, 175, 200, 225, 250, 275, 300, 350, 400, 450, 500, 550, 600, 650, 700, 800, 900, 999};
    JScrollPane m_js;

    public GraphVisualizer() {
        this.m_gp = new GraphPanel();
        this.m_js = new JScrollPane(this.m_gp);
        this.m_le = new HierarchicalBCEngine(this.m_nodes, this.m_edges, this.paddedNodeWidth, this.nodeHeight);
        this.m_le.addLayoutCompleteEventListener(this);
        this.m_jBtSave = new JButton();
        URL uRL = ClassLoader.getSystemResource("weka/gui/graphvisualizer/icons/save.gif");
        if (uRL != null) {
            this.m_jBtSave.setIcon(new ImageIcon(uRL));
        } else {
            System.err.println("weka/gui/graphvisualizer/icons/" + LocalString.get("save.gif not found for weka.gui.graphvisualizer.Graph"));
        }
        this.m_jBtSave.setToolTipText(LocalString.get("Save Graph"));
        this.m_jBtSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(".dot", LocalString.get("DOT files"));
                ExtensionFileFilter extensionFileFilter2 = new ExtensionFileFilter(".xml", LocalString.get("XML BIF files"));
                jFileChooser.addChoosableFileFilter(extensionFileFilter);
                jFileChooser.addChoosableFileFilter(extensionFileFilter2);
                jFileChooser.setDialogTitle(LocalString.get("Save Graph As"));
                int n = jFileChooser.showSaveDialog(GraphVisualizer.this);
                if (n == 0) {
                    if (jFileChooser.getFileFilter() == extensionFileFilter2) {
                        String string = jFileChooser.getSelectedFile().toString();
                        if (!string.endsWith(".xml")) {
                            string = string.concat(".xml");
                        }
                        BIFParser.writeXMLBIF03(string, GraphVisualizer.this.graphID, GraphVisualizer.this.m_nodes, GraphVisualizer.this.m_edges);
                    } else {
                        String string = jFileChooser.getSelectedFile().toString();
                        if (!string.endsWith(".dot")) {
                            string = string.concat(".dot");
                        }
                        DotParser.writeDOT(string, GraphVisualizer.this.graphID, GraphVisualizer.this.m_nodes, GraphVisualizer.this.m_edges);
                    }
                }
            }
        });
        final JButton jButton = new JButton();
        uRL = ClassLoader.getSystemResource("weka/gui/graphvisualizer/icons/zoomin.gif");
        if (uRL != null) {
            jButton.setIcon(new ImageIcon(uRL));
        } else {
            System.err.println("weka/gui/graphvisualizer/icons/" + LocalString.get("zoomin.gif not found for weka.gui.graphvisualizer.Graph"));
        }
        jButton.setToolTipText(LocalString.get("Zoom In"));
        final JButton jButton2 = new JButton();
        uRL = ClassLoader.getSystemResource("weka/gui/graphvisualizer/icons/zoomout.gif");
        if (uRL != null) {
            jButton2.setIcon(new ImageIcon(uRL));
        } else {
            System.err.println("weka/gui/graphvisualizer/icons/" + LocalString.get("zoomout.gif not found for weka.gui.graphvisualizer.Graph"));
        }
        jButton2.setToolTipText(LocalString.get("Zoom Out"));
        final JTextField jTextField = new JTextField(LocalString.get("100%"));
        jTextField.setMinimumSize(jTextField.getPreferredSize());
        jTextField.setHorizontalAlignment(0);
        jTextField.setToolTipText(LocalString.get("Zoom"));
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                try {
                    int n = -1;
                    n = jTextField.getText().indexOf(37);
                    n = n == -1 ? Integer.parseInt(jTextField.getText()) : Integer.parseInt(jTextField.getText().substring(0, n));
                    if (n <= 999) {
                        GraphVisualizer.this.scale = (double)n / 100.0;
                    }
                    jTextField.setText((int)(GraphVisualizer.this.scale * 100.0) + "%");
                    if (GraphVisualizer.this.scale > 0.1) {
                        if (!jButton2.isEnabled()) {
                            jButton2.setEnabled(true);
                        }
                    } else {
                        jButton2.setEnabled(false);
                    }
                    if (GraphVisualizer.this.scale < 9.99) {
                        if (!jButton.isEnabled()) {
                            jButton.setEnabled(true);
                        }
                    } else {
                        jButton.setEnabled(false);
                    }
                    GraphVisualizer.this.setAppropriateSize();
                    GraphVisualizer.this.m_gp.repaint();
                    GraphVisualizer.this.m_gp.invalidate();
                    GraphVisualizer.this.m_js.revalidate();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(GraphVisualizer.this.getParent(), LocalString.get("Invalid integer entered for zoom."), LocalString.get("Error"), 0);
                    jTextField.setText(GraphVisualizer.this.scale * 100.0 + "%");
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                int n2 = (int)(GraphVisualizer.this.scale * 100.0);
                n = n2 < 300 ? n2 / 25 : (n2 < 700 ? 6 + n2 / 50 : 13 + n2 / 100);
                if (n2 >= 999) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    jButton.setEnabled(false);
                    return;
                }
                if (n2 >= 10) {
                    if (n >= 22) {
                        JButton jButton = (JButton)actionEvent.getSource();
                        jButton.setEnabled(false);
                    }
                    if (n2 == 10 && !jButton2.isEnabled()) {
                        jButton2.setEnabled(true);
                    }
                    jTextField.setText(GraphVisualizer.this.zoomPercents[n + 1] + "%");
                    GraphVisualizer.this.scale = (double)GraphVisualizer.this.zoomPercents[n + 1] / 100.0;
                } else {
                    if (!jButton2.isEnabled()) {
                        jButton2.setEnabled(true);
                    }
                    jTextField.setText(GraphVisualizer.this.zoomPercents[0] + "%");
                    GraphVisualizer.this.scale = (double)GraphVisualizer.this.zoomPercents[0] / 100.0;
                }
                GraphVisualizer.this.setAppropriateSize();
                GraphVisualizer.this.m_gp.repaint();
                GraphVisualizer.this.m_gp.invalidate();
                GraphVisualizer.this.m_js.revalidate();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                int n2 = (int)(GraphVisualizer.this.scale * 100.0);
                n = n2 < 300 ? (int)Math.ceil((double)n2 / 25.0) : (n2 < 700 ? 6 + (int)Math.ceil((double)n2 / 50.0) : 13 + (int)Math.ceil((double)n2 / 100.0));
                if (n2 <= 10) {
                    JButton jButton2 = (JButton)actionEvent.getSource();
                    jButton2.setEnabled(false);
                } else if (n2 < 999) {
                    if (n <= 1) {
                        JButton jButton3 = (JButton)actionEvent.getSource();
                        jButton3.setEnabled(false);
                    }
                    jTextField.setText(GraphVisualizer.this.zoomPercents[n - 1] + "%");
                    GraphVisualizer.this.scale = (double)GraphVisualizer.this.zoomPercents[n - 1] / 100.0;
                } else {
                    if (!jButton.isEnabled()) {
                        jButton.setEnabled(true);
                    }
                    jTextField.setText(GraphVisualizer.this.zoomPercents[22] + "%");
                    GraphVisualizer.this.scale = (double)GraphVisualizer.this.zoomPercents[22] / 100.0;
                }
                GraphVisualizer.this.setAppropriateSize();
                GraphVisualizer.this.m_gp.repaint();
                GraphVisualizer.this.m_gp.invalidate();
                GraphVisualizer.this.m_js.revalidate();
            }
        });
        JButton jButton3 = new JButton();
        uRL = ClassLoader.getSystemResource("weka/gui/graphvisualizer/icons/extra.gif");
        if (uRL != null) {
            jButton3.setIcon(new ImageIcon(uRL));
        } else {
            System.err.println("weka/gui/graphvisualizer/icons/" + LocalString.get("extra.gif not found for weka.gui.graphvisualizer.Graph"));
        }
        jButton3.setToolTipText(LocalString.get("Show/Hide extra controls"));
        final JCheckBox jCheckBox = new JCheckBox(LocalString.get("Custom Node Size"));
        final JLabel jLabel = new JLabel(LocalString.get("Width"));
        final JLabel jLabel2 = new JLabel(LocalString.get("Height"));
        this.jTfNodeWidth.setHorizontalAlignment(0);
        this.jTfNodeWidth.setText("" + this.nodeWidth);
        this.jTfNodeHeight.setHorizontalAlignment(0);
        this.jTfNodeHeight.setText("" + this.nodeHeight);
        jLabel.setEnabled(false);
        this.jTfNodeWidth.setEnabled(false);
        jLabel2.setEnabled(false);
        this.jTfNodeHeight.setEnabled(false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    jLabel.setEnabled(true);
                    GraphVisualizer.this.jTfNodeWidth.setEnabled(true);
                    jLabel2.setEnabled(true);
                    GraphVisualizer.this.jTfNodeHeight.setEnabled(true);
                } else {
                    jLabel.setEnabled(false);
                    GraphVisualizer.this.jTfNodeWidth.setEnabled(false);
                    jLabel2.setEnabled(false);
                    GraphVisualizer.this.jTfNodeHeight.setEnabled(false);
                    GraphVisualizer.this.setAppropriateNodeSize();
                }
            }
        });
        this.jBtLayout = new JButton(LocalString.get("Layout Graph"));
        this.jBtLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    int n;
                    int n2;
                    try {
                        n2 = Integer.parseInt(GraphVisualizer.this.jTfNodeWidth.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(GraphVisualizer.this.getParent(), LocalString.get("Invalid integer entered for node width."), LocalString.get("Error"), 0);
                        n2 = GraphVisualizer.this.nodeWidth;
                        GraphVisualizer.this.jTfNodeWidth.setText("" + GraphVisualizer.this.nodeWidth);
                    }
                    try {
                        n = Integer.parseInt(GraphVisualizer.this.jTfNodeHeight.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(GraphVisualizer.this.getParent(), LocalString.get("Invalid integer entered for node height."), LocalString.get("Error"), 0);
                        n = GraphVisualizer.this.nodeHeight;
                        GraphVisualizer.this.jTfNodeWidth.setText("" + GraphVisualizer.this.nodeHeight);
                    }
                    if (n2 != GraphVisualizer.this.nodeWidth || n != GraphVisualizer.this.nodeHeight) {
                        GraphVisualizer.this.nodeWidth = n2;
                        GraphVisualizer.this.paddedNodeWidth = GraphVisualizer.this.nodeWidth + 8;
                        GraphVisualizer.this.nodeHeight = n;
                    }
                }
                JButton jButton = (JButton)actionEvent.getSource();
                jButton.setEnabled(false);
                GraphVisualizer.this.m_le.setNodeSize(GraphVisualizer.this.paddedNodeWidth, GraphVisualizer.this.nodeHeight);
                GraphVisualizer.this.m_le.layoutGraph();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        final JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_le.getControlPanel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = -1;
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        container.add((Component)this.jTfNodeWidth, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        container.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        container.add((Component)this.jTfNodeHeight, gridBagConstraints);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)container, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.jBtLayout, gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(LocalString.get("ExtraControls")), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        jPanel.setPreferredSize(new Dimension(0, 0));
        final JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jToolBar.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jToolBar.add((Component)this.m_jBtSave, gridBagConstraints);
        jToolBar.addSeparator(new Dimension(2, 2));
        jToolBar.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(jTextField.getPreferredSize());
        jPanel2.setMinimumSize(jTextField.getPreferredSize());
        jPanel2.add((Component)jTextField, "Center");
        jToolBar.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jToolBar.add((Component)jButton2, gridBagConstraints);
        jToolBar.addSeparator(new Dimension(2, 2));
        jToolBar.add((Component)jButton3, gridBagConstraints);
        jToolBar.addSeparator(new Dimension(4, 2));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jToolBar.add((Component)this.m_le.getProgressBar(), gridBagConstraints);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dimension dimension = jPanel.getPreferredSize();
                if (dimension.width == 0 || dimension.height == 0) {
                    LayoutManager layoutManager = jPanel.getLayout();
                    Dimension dimension2 = layoutManager.preferredLayoutSize(jPanel);
                    jPanel.setPreferredSize(dimension2);
                    jToolBar.revalidate();
                } else {
                    jPanel.setPreferredSize(new Dimension(0, 0));
                    jToolBar.revalidate();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)jToolBar, "North");
        this.add((Component)this.m_js, "Center");
    }

    protected void setAppropriateNodeSize() {
        if (this.maxStringWidth == 0) {
            for (int i = 0; i < this.m_nodes.size(); ++i) {
                int n = this.fm.stringWidth(((GraphNode)this.m_nodes.elementAt((int)i)).lbl);
                if (n <= this.maxStringWidth) continue;
                this.maxStringWidth = n;
            }
        }
        this.nodeWidth = this.maxStringWidth + 4;
        this.paddedNodeWidth = this.nodeWidth + 8;
        this.jTfNodeWidth.setText("" + this.nodeWidth);
        this.nodeHeight = 2 * this.fm.getHeight();
        this.jTfNodeHeight.setText("" + this.nodeHeight);
    }

    protected void setAppropriateSize() {
        int n = 0;
        int n2 = 0;
        this.m_gp.setScale(this.scale, this.scale);
        for (int i = 0; i < this.m_nodes.size(); ++i) {
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(i);
            if (n < graphNode.x) {
                n = graphNode.x;
            }
            if (n2 >= graphNode.y) continue;
            n2 = graphNode.y;
        }
        this.m_gp.setPreferredSize(new Dimension((int)((double)(n + this.paddedNodeWidth + 2) * this.scale), (int)((double)(n2 + this.nodeHeight + 2) * this.scale)));
    }

    public void layoutCompleted(LayoutCompleteEvent layoutCompleteEvent) {
        this.setAppropriateSize();
        this.m_gp.invalidate();
        this.m_js.revalidate();
        this.m_gp.repaint();
        this.jBtLayout.setEnabled(true);
    }

    public void layoutGraph() {
        if (this.m_le != null) {
            this.m_le.layoutGraph();
        }
    }

    public void readBIF(String string) throws BIFFormatException {
        BIFParser bIFParser = new BIFParser(string, this.m_nodes, this.m_edges);
        try {
            this.graphID = bIFParser.parse();
        }
        catch (BIFFormatException bIFFormatException) {
            System.out.println(LocalString.get("BIF format error"));
            bIFFormatException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.setAppropriateNodeSize();
        if (this.m_le != null) {
            this.m_le.setNodeSize(this.paddedNodeWidth, this.nodeHeight);
        }
    }

    public void readBIF(InputStream inputStream) throws BIFFormatException {
        BIFParser bIFParser = new BIFParser(inputStream, this.m_nodes, this.m_edges);
        try {
            this.graphID = bIFParser.parse();
        }
        catch (BIFFormatException bIFFormatException) {
            System.out.println(LocalString.get("BIF format error"));
            bIFFormatException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.setAppropriateNodeSize();
        if (this.m_le != null) {
            this.m_le.setNodeSize(this.paddedNodeWidth, this.nodeHeight);
        }
        this.setAppropriateSize();
    }

    public void readDOT(Reader reader) {
        DotParser dotParser = new DotParser(reader, this.m_nodes, this.m_edges);
        this.graphID = dotParser.parse();
        this.setAppropriateNodeSize();
        if (this.m_le != null) {
            this.m_le.setNodeSize(this.paddedNodeWidth, this.nodeHeight);
            this.jBtLayout.setEnabled(false);
            this.layoutGraph();
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(LocalString.get("Graph Visualizer"));
        GraphVisualizer graphVisualizer = new GraphVisualizer();
        try {
            if (stringArray[0].endsWith(".xml")) {
                graphVisualizer.readBIF(new FileInputStream(stringArray[0]));
            } else {
                graphVisualizer.readDOT(new FileReader(stringArray[0]));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BIFFormatException bIFFormatException) {
            bIFFormatException.printStackTrace();
            System.exit(-1);
        }
        jFrame.getContentPane().add(graphVisualizer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
    }

    private class GraphVisualizerMouseMotionListener
    extends MouseMotionAdapter {
        int x;
        int y;
        int nx;
        int ny;
        Rectangle r;
        GraphNode lastNode;

        private GraphVisualizerMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            Dimension dimension = GraphVisualizer.this.m_gp.getPreferredSize();
            this.ny = 0;
            this.nx = 0;
            this.y = 0;
            this.x = 0;
            if (dimension.width < GraphVisualizer.this.m_gp.getWidth()) {
                this.nx = (int)((double)(this.nx + GraphVisualizer.this.m_gp.getWidth() / 2 - dimension.width / 2) / GraphVisualizer.this.scale);
            }
            if (dimension.height < GraphVisualizer.this.m_gp.getHeight()) {
                this.ny = (int)((double)(this.ny + GraphVisualizer.this.m_gp.getHeight() / 2 - dimension.height / 2) / GraphVisualizer.this.scale);
            }
            this.r = new Rectangle(0, 0, (int)((double)GraphVisualizer.this.paddedNodeWidth * GraphVisualizer.this.scale), (int)((double)GraphVisualizer.this.nodeHeight * GraphVisualizer.this.scale));
            this.x += mouseEvent.getX();
            this.y += mouseEvent.getY();
            for (n = 0; n < GraphVisualizer.this.m_nodes.size(); ++n) {
                GraphNode graphNode = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(n);
                this.r.x = (int)((double)(this.nx + graphNode.x) * GraphVisualizer.this.scale);
                this.r.y = (int)((double)(this.ny + graphNode.y) * GraphVisualizer.this.scale);
                if (!this.r.contains(this.x, this.y)) continue;
                if (graphNode == this.lastNode) break;
                GraphVisualizer.this.m_gp.highLight(graphNode);
                if (this.lastNode != null) {
                    GraphVisualizer.this.m_gp.highLight(this.lastNode);
                }
                this.lastNode = graphNode;
                break;
            }
            if (n == GraphVisualizer.this.m_nodes.size() && this.lastNode != null) {
                GraphVisualizer.this.m_gp.repaint();
                this.lastNode = null;
            }
        }
    }

    private class GraphVisualizerMouseListener
    extends MouseAdapter {
        int x;
        int y;
        int nx;
        int ny;
        Rectangle r;

        private GraphVisualizerMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Dimension dimension = GraphVisualizer.this.m_gp.getPreferredSize();
            this.ny = 0;
            this.nx = 0;
            this.y = 0;
            this.x = 0;
            if (dimension.width < GraphVisualizer.this.m_gp.getWidth()) {
                this.nx = (int)((double)(this.nx + GraphVisualizer.this.m_gp.getWidth() / 2 - dimension.width / 2) / GraphVisualizer.this.scale);
            }
            if (dimension.height < GraphVisualizer.this.m_gp.getHeight()) {
                this.ny = (int)((double)(this.ny + GraphVisualizer.this.m_gp.getHeight() / 2 - dimension.height / 2) / GraphVisualizer.this.scale);
            }
            this.r = new Rectangle(0, 0, (int)((double)GraphVisualizer.this.paddedNodeWidth * GraphVisualizer.this.scale), (int)((double)GraphVisualizer.this.nodeHeight * GraphVisualizer.this.scale));
            this.x += mouseEvent.getX();
            this.y += mouseEvent.getY();
            for (int i = 0; i < GraphVisualizer.this.m_nodes.size(); ++i) {
                Serializable serializable;
                Object object;
                GraphNode graphNode = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(i);
                this.r.x = (int)((double)(this.nx + graphNode.x) * GraphVisualizer.this.scale);
                this.r.y = (int)((double)(this.ny + graphNode.y) * GraphVisualizer.this.scale);
                if (!this.r.contains(this.x, this.y)) continue;
                if (graphNode.probs == null) {
                    return;
                }
                int n = 1;
                if (graphNode.prnts != null) {
                    for (int j = 0; j < graphNode.prnts.length; ++j) {
                        object = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode.prnts[j]);
                        n *= ((GraphNode)object).outcomes.length;
                    }
                    if (n > 511) {
                        System.err.println(LocalString.get("Too many outcomes of parents (") + n + LocalString.get(") can't display probabilities"));
                        return;
                    }
                }
                GraphVisualizerTableModel graphVisualizerTableModel = new GraphVisualizerTableModel(graphNode.probs, graphNode.outcomes);
                object = new JTable(graphVisualizerTableModel);
                JScrollPane jScrollPane = new JScrollPane((Component)object);
                if (graphNode.prnts != null) {
                    JLabel jLabel;
                    Object object2;
                    serializable = new GridBagConstraints();
                    JPanel jPanel = new JPanel(new GridBagLayout());
                    int[] nArray = new int[graphNode.prnts.length];
                    int[] nArray2 = new int[graphNode.prnts.length];
                    ((GridBagConstraints)serializable).anchor = 18;
                    ((GridBagConstraints)serializable).fill = 2;
                    ((GridBagConstraints)serializable).insets = new Insets(0, 1, 0, 0);
                    int n2 = 0;
                    int n3 = 0;
                    boolean bl = false;
                    do {
                        int n4;
                        ((GridBagConstraints)serializable).gridwidth = 1;
                        for (n4 = 0; n4 < graphNode.prnts.length; ++n4) {
                            object2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode.prnts[n4]);
                            jLabel = new JLabel(((GraphNode)object2).outcomes[nArray[n4]]);
                            jLabel.setFont(new Font(LocalString.get("Dialog"), 0, 12));
                            jLabel.setOpaque(true);
                            jLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
                            jLabel.setHorizontalAlignment(0);
                            if (bl) {
                                jLabel.setBackground(jLabel.getBackground().darker());
                                jLabel.setForeground(Color.white);
                            } else {
                                jLabel.setForeground(Color.black);
                            }
                            n3 = jLabel.getPreferredSize().width;
                            jLabel.setPreferredSize(new Dimension(n3, ((JTable)object).getRowHeight()));
                            if (nArray2[n4] < n3) {
                                nArray2[n4] = n3;
                            }
                            n3 = 0;
                            if (n4 == graphNode.prnts.length - 1) {
                                ((GridBagConstraints)serializable).gridwidth = 0;
                                bl = !bl;
                            }
                            jPanel.add((Component)jLabel, serializable);
                            ++n2;
                        }
                        for (n4 = graphNode.prnts.length - 1; n4 >= 0; --n4) {
                            object2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode.prnts[n4]);
                            if (nArray[n4] != ((GraphNode)object2).outcomes.length - 1 || n4 == 0) {
                                int n5 = n4;
                                nArray[n5] = nArray[n5] + 1;
                                break;
                            }
                            nArray[n4] = 0;
                        }
                        object2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode.prnts[0]);
                    } while (nArray[0] != ((GraphNode)object2).outcomes.length);
                    JLabel jLabel2 = (JLabel)jPanel.getComponent(n2 - 1);
                    jPanel.remove(n2 - 1);
                    jLabel2.setPreferredSize(new Dimension(jLabel2.getPreferredSize().width, ((JTable)object).getRowHeight()));
                    ((GridBagConstraints)serializable).gridwidth = 0;
                    ((GridBagConstraints)serializable).weighty = 1.0;
                    jPanel.add((Component)jLabel2, serializable);
                    ((GridBagConstraints)serializable).weighty = 0.0;
                    ((GridBagConstraints)serializable).gridwidth = 1;
                    object2 = new JPanel(new GridBagLayout());
                    for (int j = 0; j < graphNode.prnts.length; ++j) {
                        JLabel jLabel3 = new JLabel(((GraphNode)GraphVisualizer.this.m_nodes.elementAt((int)graphNode.prnts[j])).lbl);
                        jLabel3.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
                        Dimension dimension2 = jLabel3.getPreferredSize();
                        if (dimension2.width < nArray2[j]) {
                            jLabel3.setPreferredSize(new Dimension(nArray2[j], dimension2.height));
                            jLabel3.setHorizontalAlignment(0);
                            jLabel3.setMinimumSize(new Dimension(nArray2[j], dimension2.height));
                        } else if (dimension2.width > nArray2[j]) {
                            jLabel = (JLabel)jPanel.getComponent(j);
                            jLabel.setPreferredSize(new Dimension(dimension2.width, jLabel.getPreferredSize().height));
                        }
                        ((Container)object2).add((Component)jLabel3, serializable);
                    }
                    jScrollPane.setRowHeaderView(jPanel);
                    jScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)object2);
                }
                serializable = new JDialog((Frame)GraphVisualizer.this.getTopLevelAncestor(), LocalString.get("Probability Distribution Table For ") + graphNode.lbl, true);
                ((Window)serializable).setSize(500, 400);
                ((Window)serializable).setLocation(GraphVisualizer.this.getLocation().x + GraphVisualizer.this.getWidth() / 2 - 250, GraphVisualizer.this.getLocation().y + GraphVisualizer.this.getHeight() / 2 - 200);
                ((JDialog)serializable).getContentPane().setLayout(new BorderLayout());
                ((JDialog)serializable).getContentPane().add((Component)jScrollPane, "Center");
                ((Dialog)serializable).setVisible(true);
                return;
            }
        }
    }

    private class GraphVisualizerTableModel
    extends AbstractTableModel {
        final String[] columnNames;
        final double[][] data;

        public GraphVisualizerTableModel(double[][] dArray, String[] stringArray) {
            this.data = dArray;
            this.columnNames = stringArray;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return new Double(this.data[n][n2]);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class GraphPanel
    extends PrintablePanel {
        public GraphPanel() {
            this.addMouseListener(new GraphVisualizerMouseListener());
            this.addMouseMotionListener(new GraphVisualizerMouseMotionListener());
            this.setToolTipText("");
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Dimension dimension = GraphVisualizer.this.m_gp.getPreferredSize();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (dimension.width < GraphVisualizer.this.m_gp.getWidth()) {
                n2 = (int)((double)(n2 + GraphVisualizer.this.m_gp.getWidth() / 2 - dimension.width / 2) / GraphVisualizer.this.scale);
            }
            if (dimension.height < GraphVisualizer.this.m_gp.getHeight()) {
                n = (int)((double)(n + GraphVisualizer.this.m_gp.getHeight() / 2 - dimension.height / 2) / GraphVisualizer.this.scale);
            }
            Rectangle rectangle = new Rectangle(0, 0, (int)((double)GraphVisualizer.this.paddedNodeWidth * GraphVisualizer.this.scale), (int)((double)GraphVisualizer.this.nodeHeight * GraphVisualizer.this.scale));
            n4 += mouseEvent.getX();
            n3 += mouseEvent.getY();
            for (int i = 0; i < GraphVisualizer.this.m_nodes.size(); ++i) {
                GraphNode graphNode = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(i);
                if (graphNode.nodeType != 3) {
                    return null;
                }
                rectangle.x = (int)((double)(n2 + graphNode.x) * GraphVisualizer.this.scale);
                rectangle.y = (int)((double)(n + graphNode.y) * GraphVisualizer.this.scale);
                if (!rectangle.contains(n4, n3)) continue;
                if (graphNode.probs == null) {
                    return graphNode.lbl;
                }
                return graphNode.lbl + LocalString.get(" (click to view the probability dist. table)");
            }
            return null;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.scale(GraphVisualizer.this.scale, GraphVisualizer.this.scale);
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            int n = 0;
            int n2 = 0;
            Dimension dimension = this.getPreferredSize();
            if (dimension.width < this.getWidth()) {
                n = (int)((double)(n + this.getWidth() / 2 - dimension.width / 2) / GraphVisualizer.this.scale);
            }
            if (dimension.height < this.getHeight()) {
                n2 = (int)((double)(n2 + this.getHeight() / 2 - dimension.height / 2) / GraphVisualizer.this.scale);
            }
            for (int i = 0; i < GraphVisualizer.this.m_nodes.size(); ++i) {
                GraphNode graphNode = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(i);
                if (graphNode.nodeType == 3) {
                    graphics2D.setColor(this.getBackground().darker().darker());
                    graphics2D.fillOval(n + graphNode.x + GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth - (GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth) / 2, n2 + graphNode.y, GraphVisualizer.this.nodeWidth, GraphVisualizer.this.nodeHeight);
                    graphics2D.setColor(Color.white);
                    if (GraphVisualizer.this.fm.stringWidth(graphNode.lbl) <= GraphVisualizer.this.nodeWidth) {
                        graphics2D.drawString(graphNode.lbl, n + graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(graphNode.lbl) / 2, n2 + graphNode.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                    } else if (GraphVisualizer.this.fm.stringWidth(graphNode.ID) <= GraphVisualizer.this.nodeWidth) {
                        graphics2D.drawString(graphNode.ID, n + graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(graphNode.ID) / 2, n2 + graphNode.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                    } else if (GraphVisualizer.this.fm.stringWidth(Integer.toString(i)) <= GraphVisualizer.this.nodeWidth) {
                        graphics2D.drawString(Integer.toString(i), n + graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(Integer.toString(i)) / 2, n2 + graphNode.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
                    }
                    graphics2D.setColor(Color.black);
                } else {
                    graphics2D.drawLine(n + graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode.y, n + graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode.y + GraphVisualizer.this.nodeHeight);
                }
                if (graphNode.edges == null) continue;
                for (int j = 0; j < graphNode.edges.length; ++j) {
                    if (graphNode.edges[j][1] <= 0) continue;
                    GraphNode graphNode2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode.edges[j][0]);
                    int n3 = graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2;
                    int n4 = graphNode.y + GraphVisualizer.this.nodeHeight;
                    int n5 = graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                    int n6 = graphNode2.y;
                    graphics2D.drawLine(n + n3, n2 + n4, n + n5, n2 + n6);
                    if (graphNode.edges[j][1] == 1) {
                        if (graphNode2.nodeType != 3) continue;
                        this.drawArrow(graphics2D, n + n3, n2 + n4, n + n5, n2 + n6);
                        continue;
                    }
                    if (graphNode.edges[j][1] == 2) {
                        if (graphNode.nodeType != 3) continue;
                        this.drawArrow(graphics2D, n + n5, n2 + n6, n + n3, n2 + n4);
                        continue;
                    }
                    if (graphNode.edges[j][1] != 3) continue;
                    if (graphNode.nodeType == 3) {
                        this.drawArrow(graphics2D, n + n5, n2 + n6, n + n3, n2 + n4);
                    }
                    if (graphNode2.nodeType != 3) continue;
                    this.drawArrow(graphics2D, n + n3, n2 + n4, n + n5, n2 + n6);
                }
            }
        }

        protected void drawArrow(Graphics graphics, int n, int n2, int n3, int n4) {
            if (n == n3) {
                if (n2 < n4) {
                    graphics.drawLine(n3, n4, n3 + 4, n4 - 8);
                    graphics.drawLine(n3, n4, n3 - 4, n4 - 8);
                } else {
                    graphics.drawLine(n3, n4, n3 + 4, n4 + 8);
                    graphics.drawLine(n3, n4, n3 - 4, n4 + 8);
                }
            } else {
                double d;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                int n5 = 0;
                int n6 = 0;
                if (n3 < n) {
                    d3 = n - n3;
                    d2 = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
                    d = Math.acos(d3 / d2);
                } else {
                    d3 = n - n3;
                    d2 = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
                    d = Math.acos(d3 / d2);
                }
                double d5 = 0.5235987755982988;
                d2 = 8.0;
                d3 = Math.cos(d - d5) * d2;
                d4 = Math.sin(d - d5) * d2;
                n5 = (int)((double)n3 + d3);
                n6 = n2 < n4 ? (int)((double)n4 - d4) : (int)((double)n4 + d4);
                graphics.drawLine(n3, n4, n5, n6);
                d3 = Math.cos(d + d5) * d2;
                d4 = Math.sin(d + d5) * d2;
                n5 = (int)((double)n3 + d3);
                n6 = n2 < n4 ? (int)((double)n4 - d4) : (int)((double)n4 + d4);
                graphics.drawLine(n3, n4, n5, n6);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void highLight(GraphNode graphNode) {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.setPaintMode();
            graphics2D.scale(GraphVisualizer.this.scale, GraphVisualizer.this.scale);
            int n = 0;
            int n2 = 0;
            Dimension dimension = this.getPreferredSize();
            if (dimension.width < this.getWidth()) {
                n = (int)((double)(n + this.getWidth() / 2 - dimension.width / 2) / GraphVisualizer.this.scale);
            }
            if (dimension.height < this.getHeight()) {
                n2 = (int)((double)(n2 + this.getHeight() / 2 - dimension.height / 2) / GraphVisualizer.this.scale);
            }
            if (graphNode.nodeType != 3) return;
            graphics2D.setXORMode(Color.green);
            graphics2D.fillOval(n + graphNode.x + GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth - (GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth) / 2, n2 + graphNode.y, GraphVisualizer.this.nodeWidth, GraphVisualizer.this.nodeHeight);
            graphics2D.setXORMode(Color.red);
            if (GraphVisualizer.this.fm.stringWidth(graphNode.lbl) <= GraphVisualizer.this.nodeWidth) {
                graphics2D.drawString(graphNode.lbl, n + graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(graphNode.lbl) / 2, n2 + graphNode.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
            } else if (GraphVisualizer.this.fm.stringWidth(graphNode.ID) <= GraphVisualizer.this.nodeWidth) {
                graphics2D.drawString(graphNode.ID, n + graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(graphNode.ID) / 2, n2 + graphNode.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
            } else if (GraphVisualizer.this.fm.stringWidth(Integer.toString(GraphVisualizer.this.m_nodes.indexOf(graphNode))) <= GraphVisualizer.this.nodeWidth) {
                graphics2D.drawString(Integer.toString(GraphVisualizer.this.m_nodes.indexOf(graphNode)), n + graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2 - GraphVisualizer.this.fm.stringWidth(Integer.toString(GraphVisualizer.this.m_nodes.indexOf(graphNode))) / 2, n2 + graphNode.y + GraphVisualizer.this.nodeHeight / 2 + GraphVisualizer.this.fm.getHeight() / 2 - 2);
            }
            graphics2D.setXORMode(Color.green);
            if (graphNode.edges == null) return;
            for (int i = 0; i < graphNode.edges.length; ++i) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                GraphNode graphNode2;
                if (graphNode.edges[i][1] == 1 || graphNode.edges[i][1] == 3) {
                    graphNode2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode.edges[i][0]);
                    n7 = graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2;
                    n6 = graphNode.y + GraphVisualizer.this.nodeHeight;
                    n5 = graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                    n4 = graphNode2.y;
                    graphics2D.drawLine(n + n7, n2 + n6, n + n5, n2 + n4);
                    if (graphNode.edges[i][1] == 1) {
                        if (graphNode2.nodeType == 3) {
                            this.drawArrow(graphics2D, n + n7, n2 + n6, n + n5, n2 + n4);
                        }
                    } else if (graphNode.edges[i][1] == 3) {
                        if (graphNode.nodeType == 3) {
                            this.drawArrow(graphics2D, n + n5, n2 + n4, n + n7, n2 + n6);
                        }
                        if (graphNode2.nodeType == 3) {
                            this.drawArrow(graphics2D, n + n7, n2 + n6, n + n5, n2 + n4);
                        }
                    }
                    if (graphNode2.nodeType == 3) {
                        graphics2D.fillOval(n + graphNode2.x + GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth - (GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth) / 2, n2 + graphNode2.y, GraphVisualizer.this.nodeWidth, GraphVisualizer.this.nodeHeight);
                    }
                    Vector<GraphNode> vector = new Vector<GraphNode>();
                    while (graphNode2.nodeType != 3 || vector.size() > 0) {
                        if (vector.size() > 0) {
                            graphNode2 = (GraphNode)vector.elementAt(0);
                            vector.removeElementAt(0);
                        }
                        if (graphNode2.nodeType == 3) continue;
                        graphics2D.drawLine(n + graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode2.y, n + graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode2.y + GraphVisualizer.this.nodeHeight);
                        n7 = graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                        n6 = graphNode2.y + GraphVisualizer.this.nodeHeight;
                        for (n3 = 0; n3 < graphNode2.edges.length; ++n3) {
                            if (graphNode2.edges[n3][1] <= 0) continue;
                            GraphNode graphNode3 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode2.edges[n3][0]);
                            graphics2D.drawLine(n + n7, n2 + n6, n + graphNode3.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode3.y);
                            if (graphNode3.nodeType == 3) {
                                graphics2D.fillOval(n + graphNode3.x + GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth - (GraphVisualizer.this.paddedNodeWidth - GraphVisualizer.this.nodeWidth) / 2, n2 + graphNode3.y, GraphVisualizer.this.nodeWidth, GraphVisualizer.this.nodeHeight);
                                this.drawArrow(graphics2D, n + n7, n2 + n6, n + graphNode3.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode3.y);
                            }
                            vector.addElement(graphNode3);
                        }
                    }
                    continue;
                }
                if (graphNode.edges[i][1] != -2 && graphNode.edges[i][1] != -3) continue;
                graphNode2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode.edges[i][0]);
                n7 = graphNode.x + GraphVisualizer.this.paddedNodeWidth / 2;
                n6 = graphNode.y;
                n5 = graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                n4 = graphNode2.y + GraphVisualizer.this.nodeHeight;
                graphics2D.drawLine(n + n7, n2 + n6, n + n5, n2 + n4);
                if (graphNode.edges[i][1] == -3) {
                    this.drawArrow(graphics2D, n + n5, n2 + n4, n + n7, n2 + n6);
                    if (graphNode2.nodeType != 1) {
                        this.drawArrow(graphics2D, n + n7, n2 + n6, n + n5, n2 + n4);
                    }
                }
                int n8 = i;
                block3: while (graphNode2.nodeType != 3) {
                    graphics2D.drawLine(n + graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode2.y + GraphVisualizer.this.nodeHeight, n + graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode2.y);
                    n7 = graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2;
                    n6 = graphNode2.y;
                    for (n3 = 0; n3 < graphNode2.edges.length; ++n3) {
                        if (graphNode2.edges[n3][1] >= 0) continue;
                        graphNode2 = (GraphNode)GraphVisualizer.this.m_nodes.elementAt(graphNode2.edges[n3][0]);
                        graphics2D.drawLine(n + n7, n2 + n6, n + graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode2.y + GraphVisualizer.this.nodeHeight);
                        n8 = n3;
                        if (graphNode2.nodeType == 1) continue block3;
                        this.drawArrow(graphics2D, n + n7, n2 + n6, n + graphNode2.x + GraphVisualizer.this.paddedNodeWidth / 2, n2 + graphNode2.y + GraphVisualizer.this.nodeHeight);
                        continue block3;
                    }
                }
            }
        }
    }
}

