/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public abstract class IteratedSingleClassifierEnhancer
extends SingleClassifierEnhancer {
    protected Classifier[] m_Classifiers;
    protected int m_NumIterations = 10;

    public void buildClassifier(Instances instances) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception(LocalString.get("A base classifier has not been specified!"));
        }
        this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, this.m_NumIterations);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tNumber of iterations.\n") + LocalString.get("\t(default 10)"), "I", 1, LocalString.get("-I <num>")));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setNumIterations(Integer.parseInt(string));
        } else {
            this.setNumIterations(10);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 2];
        int n = 0;
        stringArray2[n++] = "-I";
        stringArray2[n++] = "" + this.getNumIterations();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String numIterationsTipText() {
        return LocalString.get("The number of iterations to be performed.");
    }

    public void setNumIterations(int n) {
        this.m_NumIterations = n;
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }
}

