/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeSelection;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class OneRAttributeEval
extends AttributeEvaluator
implements OptionHandler {
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private int m_randomSeed;
    private int m_folds;
    private boolean m_evalUsingTrainingData;
    private int m_minBucketSize;

    public String globalInfo() {
        return LocalString.get("OneRAttributeEval :\n\nEvaluates the worth of an attribute by ") + LocalString.get("using the OneR classifier.\n");
    }

    public String seedTipText() {
        return LocalString.get("Set the seed for use in cross validation.");
    }

    public void setSeed(int n) {
        this.m_randomSeed = n;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String foldsTipText() {
        return LocalString.get("Set the number of folds for cross validation.");
    }

    public void setFolds(int n) {
        this.m_folds = n;
        if (this.m_folds < 2) {
            this.m_folds = 2;
        }
    }

    public int getFolds() {
        return this.m_folds;
    }

    public String evalUsingTrainingDataTipText() {
        return LocalString.get("Use the training data to evaluate attributes rather than ") + LocalString.get("cross validation.");
    }

    public void setEvalUsingTrainingData(boolean bl) {
        this.m_evalUsingTrainingData = bl;
    }

    public String minimumBucketSizeTipText() {
        return LocalString.get("The minimum number of objects in a bucket ") + LocalString.get("(passed to OneR).");
    }

    public void setMinimumBucketSize(int n) {
        this.m_minBucketSize = n;
    }

    public int getMinimumBucketSize() {
        return this.m_minBucketSize;
    }

    public boolean getEvalUsingTrainingData() {
        return this.m_evalUsingTrainingData;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option(LocalString.get("\tRandom number seed for cross validation (default = 1)"), "S", 1, LocalString.get("-S <seed>")));
        vector.addElement(new Option(LocalString.get("\tNumber of folds for cross validation (default = 10)"), "F", 1, LocalString.get("-F <folds>")));
        vector.addElement(new Option(LocalString.get("\tUse training data for evaluation rather than cross validaton"), "D", 0, "-D"));
        vector.addElement(new Option(LocalString.get("\tMinimum number of objects in a bucket (passed on to ") + LocalString.get("OneR, default = 6)"), "B", 1, LocalString.get("-B <minimum bucket size>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('F', stringArray)).length() != 0) {
            this.setFolds(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('B', stringArray)).length() != 0) {
            this.setMinimumBucketSize(Integer.parseInt(string));
        }
        this.setEvalUsingTrainingData(Utils.getFlag('D', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[7];
        int n = 0;
        if (this.getEvalUsingTrainingData()) {
            stringArray[n++] = "-D";
        }
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.getFolds();
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getMinimumBucketSize();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public OneRAttributeEval() {
        this.resetOptions();
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.m_trainInstances = instances;
        if (this.m_trainInstances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Can't handle string attributes!"));
        }
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        if (this.m_trainInstances.attribute(this.m_classIndex).isNumeric()) {
            throw new Exception(LocalString.get("Class must be nominal!"));
        }
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_randomSeed = 1;
        this.m_folds = 10;
        this.m_evalUsingTrainingData = false;
        this.m_minBucketSize = 6;
    }

    public double evaluateAttribute(int n) throws Exception {
        int[] nArray = new int[2];
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        Instances instances = new Instances(this.m_trainInstances);
        nArray[0] = n;
        nArray[1] = instances.classIndex();
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances);
        instances = Filter.useFilter(instances, remove);
        Evaluation evaluation = new Evaluation(instances);
        String[] stringArray = new String[]{"-B", "" + this.getMinimumBucketSize()};
        Classifier classifier = Classifier.forName("weka.classifiers.rules.OneR", stringArray);
        if (this.m_evalUsingTrainingData) {
            classifier.buildClassifier(instances);
            evaluation.evaluateModel(classifier, instances);
        } else {
            evaluation.crossValidateModel(classifier, instances, this.m_folds, new Random(this.m_randomSeed));
        }
        double d = evaluation.errorRate();
        return (1.0 - d) * 100.0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainInstances == null) {
            stringBuffer.append(LocalString.get("\tOneR feature evaluator has not been built yet"));
        } else {
            stringBuffer.append(LocalString.get("\tOneR feature evaluator.\n\n"));
            stringBuffer.append(LocalString.get("\tUsing "));
            if (this.m_evalUsingTrainingData) {
                stringBuffer.append(LocalString.get("training data for evaluation of attributes."));
            } else {
                stringBuffer.append("" + this.getFolds() + LocalString.get(" fold cross validation for evaluating ") + LocalString.get("attributes."));
            }
            stringBuffer.append(LocalString.get("\n\tMinimum bucket size for OneR: ") + this.getMinimumBucketSize());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(AttributeSelection.SelectAttributes(new OneRAttributeEval(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

