/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;

public class ExhaustiveSearch
extends ASSearch
implements StartSetHandler,
OptionHandler {
    private int[] m_starting;
    private Range m_startRange;
    private BitSet m_bestGroup;
    private double m_bestMerit;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private boolean m_verbose;
    private boolean m_stopAfterFirst;
    private int m_evaluations;

    public String globalInfo() {
        return LocalString.get("ExhaustiveSearch : \n\nPerforms an exhaustive search through ") + LocalString.get("the space of attribute subsets starting from the empty set of ") + LocalString.get("attrubutes. Reports the best subset found. If a start set is ") + LocalString.get("supplied, the algorithm searches backward from the start point ") + LocalString.get("and reports the smallest subset with as good or better evaluation ") + LocalString.get("as the start point.\n");
    }

    public ExhaustiveSearch() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tSpecify a starting set of attributes.") + LocalString.get("\n\tEg. 1,3,5-7.") + LocalString.get("\n\tIf a start point is supplied,") + LocalString.get("\n\tExhaustive search stops after") + LocalString.get("\n\tfinding the smallest possible subset") + LocalString.get("\n\twith merit as good as or better than") + LocalString.get("\n\tthe start set."), "P", 1, LocalString.get("-P <start set>")));
        vector.addElement(new Option(LocalString.get("\tOutput subsets as the search progresses.") + LocalString.get("\n\t(default = false)."), "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setStartSet(string);
        }
        this.setVerbose(Utils.getFlag('V', stringArray));
    }

    public String startSetTipText() {
        return LocalString.get("Set the start point for the search. This is specified as a comma ") + LocalString.get("seperated list off attribute indexes starting at 1. It can include ") + LocalString.get("ranges. Eg. 1,2,5-9,17.");
    }

    public void setStartSet(String string) throws Exception {
        this.m_startRange.setRanges(string);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String verboseTipText() {
        return LocalString.get("Print progress information. Sends progress info to the terminal ") + LocalString.get("as the search progresses.");
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String[] getOptions() {
        String[] stringArray = new String[3];
        int n = 0;
        if (!this.getStartSet().equals("")) {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.startSetToString();
        }
        if (this.m_verbose) {
            stringArray[n++] = "-V";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    private String startSetToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean bl = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                stringBuffer.append(this.m_starting[i] + 1);
                bl = true;
            }
            if (i == this.m_starting.length - 1) {
                stringBuffer.append("");
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("\tExhaustive Search.\n\tStart set: "));
        if (this.m_starting == null) {
            stringBuffer.append(LocalString.get("no attributes\n"));
        } else {
            stringBuffer.append(this.startSetToString() + "\n");
        }
        stringBuffer.append(LocalString.get("\tNumber of evaluations: ") + this.m_evaluations + "\n");
        stringBuffer.append(LocalString.get("\tMerit of best subset found: ") + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int n;
        boolean bl = false;
        this.m_numAttribs = instances.numAttributes();
        this.m_bestGroup = new BitSet(this.m_numAttribs);
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + LocalString.get(" is not a ") + LocalString.get("Subset evaluator!"));
        }
        if (aSEvaluation instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = instances.classIndex();
        }
        SubsetEvaluator subsetEvaluator = (SubsetEvaluator)aSEvaluation;
        this.m_numAttribs = instances.numAttributes();
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_starting != null) {
            this.m_stopAfterFirst = true;
            for (int i = 0; i < this.m_starting.length; ++i) {
                if (this.m_starting[i] == this.m_classIndex) continue;
                this.m_bestGroup.set(this.m_starting[i]);
            }
        }
        double d = subsetEvaluator.evaluateSubset(this.m_bestGroup);
        ++this.m_evaluations;
        int n2 = this.countFeatures(this.m_bestGroup);
        if (this.m_verbose && this.m_stopAfterFirst) {
            System.out.println(LocalString.get("Initial subset (") + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
        }
        BitSet bitSet = new BitSet(this.m_numAttribs);
        double d2 = subsetEvaluator.evaluateSubset(bitSet);
        if (this.m_verbose) {
            System.out.println(LocalString.get("Zero feature subset (") + Utils.doubleToString(Math.abs(d2), 8, 5) + ")");
        }
        if (d2 >= d) {
            n = this.countFeatures(bitSet);
            if (d2 > d || n < n2) {
                d = d2;
                this.m_bestGroup = (BitSet)bitSet.clone();
                n2 = n;
            }
            if (this.m_stopAfterFirst) {
                bl = true;
            }
        }
        if (!bl) {
            block1: for (int i = 1; i <= this.m_numAttribs; ++i) {
                bitSet = new BitSet(this.m_numAttribs);
                for (int j = 0; j < i; ++j) {
                    bitSet.set(j);
                    if (!this.m_hasClass || j != this.m_classIndex) continue;
                    bitSet.clear(j);
                }
                d2 = subsetEvaluator.evaluateSubset(bitSet);
                ++this.m_evaluations;
                if (d2 >= d) {
                    n = this.countFeatures(bitSet);
                    if (d2 > d || n < n2) {
                        d = d2;
                        this.m_bestGroup = (BitSet)bitSet.clone();
                        n2 = n;
                        if (this.m_verbose) {
                            System.out.println(LocalString.get("New best subset (") + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
                        }
                    }
                    if (this.m_stopAfterFirst) {
                        bl = true;
                        break;
                    }
                }
                while (bitSet.cardinality() > 0) {
                    this.generateNextSubset(i, bitSet);
                    if (bitSet.cardinality() <= 0) continue;
                    d2 = subsetEvaluator.evaluateSubset(bitSet);
                    ++this.m_evaluations;
                    if (!(d2 >= d)) continue;
                    n = this.countFeatures(bitSet);
                    if (d2 > d || n < n2) {
                        d = d2;
                        this.m_bestGroup = (BitSet)bitSet.clone();
                        n2 = n;
                        if (this.m_verbose) {
                            System.out.println(LocalString.get("New best subset (") + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
                        }
                    }
                    if (!this.m_stopAfterFirst) continue;
                    bl = true;
                    break block1;
                }
            }
        }
        this.m_bestMerit = d;
        return this.attributeList(this.m_bestGroup);
    }

    private int countFeatures(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        return n;
    }

    private String printSubset(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            stringBuffer.append(i + 1 + " ");
        }
        return stringBuffer.toString();
    }

    private int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    private void generateNextSubset(int n, BitSet bitSet) {
        int n2;
        int n3 = 0;
        boolean bl = false;
        BitSet bitSet2 = (BitSet)bitSet.clone();
        for (n2 = 0; n2 < this.m_numAttribs; ++n2) {
            bitSet2.clear(n2);
        }
        block1: while (!bl && n3 < n) {
            for (n2 = this.m_numAttribs - 1 - n3; n2 >= 0; --n2) {
                if (!bitSet.get(n2)) continue;
                bitSet.clear(n2);
                if (n2 != this.m_numAttribs - 1 - n3) {
                    int n4 = n2 + 1;
                    if (n4 == this.m_classIndex) {
                        ++n4;
                    }
                    if (n4 < this.m_numAttribs) {
                        bitSet.set(n4);
                        for (int i = 0; i < n3; ++i) {
                            if (n4 + 1 + i == this.m_classIndex) {
                                ++n4;
                            }
                            if (n4 + 1 + i >= this.m_numAttribs) continue;
                            bitSet.set(n4 + 1 + i);
                        }
                        bl = true;
                        continue block1;
                    }
                    ++n3;
                    continue block1;
                }
                ++n3;
                continue block1;
            }
        }
        if (bitSet.cardinality() < n) {
            bitSet.clear();
        }
    }

    private void resetOptions() {
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_stopAfterFirst = false;
        this.m_verbose = false;
        this.m_evaluations = 0;
    }
}

