/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorManager;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.xml.XMLClassifier;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.experiment.Experiment;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;

public class AlgorithmListPanel
extends JPanel
implements ActionListener {
    protected Experiment m_Exp;
    protected JList m_List;
    protected JButton m_AddBut = new JButton(LocalString.get("Add new..."));
    protected JButton m_EditBut = new JButton(LocalString.get("Edit selected..."));
    protected JButton m_DeleteBut = new JButton(LocalString.get("Delete selected"));
    protected JButton m_LoadOptionsBut = new JButton(LocalString.get("Load options..."));
    protected JButton m_SaveOptionsBut = new JButton(LocalString.get("Save options..."));
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected FileFilter m_XMLFilter = new ExtensionFileFilter(".xml", LocalString.get("Experiment configuration files (*.xml)"));
    protected boolean m_Editing = false;
    protected GenericObjectEditor m_ClassifierEditor = new GenericObjectEditor(true);
    protected PropertyDialog m_PD;
    protected DefaultListModel m_AlgorithmListModel = new DefaultListModel();
    static /* synthetic */ Class class$weka$core$SelectedTag;
    static /* synthetic */ Class class$weka$gui$SelectedTagEditor;
    static /* synthetic */ Class class$weka$filters$Filter;
    static /* synthetic */ Class class$weka$gui$GenericObjectEditor;
    static /* synthetic */ Class array$Lweka$classifiers$Classifier;
    static /* synthetic */ Class class$weka$gui$GenericArrayEditor;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$weka$classifiers$Classifier;
    static /* synthetic */ Class class$weka$classifiers$CostMatrix;
    static /* synthetic */ Class class$weka$gui$CostMatrixEditor;

    public AlgorithmListPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public AlgorithmListPanel() {
        this.m_List = new JList();
        this.m_ClassifierEditor.setClassType(class$weka$classifiers$Classifier == null ? (class$weka$classifiers$Classifier = AlgorithmListPanel.class$("weka.classifiers.Classifier")) : class$weka$classifiers$Classifier);
        this.m_ClassifierEditor.setValue(new ZeroR());
        this.m_ClassifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AlgorithmListPanel.this.repaint();
            }
        });
        ((GenericObjectEditor.GOEPanel)this.m_ClassifierEditor.getCustomEditor()).addOkListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Classifier classifier = (Classifier)AlgorithmListPanel.this.copyObject(AlgorithmListPanel.this.m_ClassifierEditor.getValue());
                AlgorithmListPanel.this.addNewAlgorithm(classifier);
            }
        });
        this.m_DeleteBut.setEnabled(false);
        this.m_DeleteBut.addActionListener(this);
        this.m_AddBut.setEnabled(false);
        this.m_AddBut.addActionListener(this);
        this.m_EditBut.setEnabled(false);
        this.m_EditBut.addActionListener(this);
        this.m_LoadOptionsBut.setEnabled(false);
        this.m_LoadOptionsBut.addActionListener(this);
        this.m_SaveOptionsBut.setEnabled(false);
        this.m_SaveOptionsBut.addActionListener(this);
        this.m_List.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AlgorithmListPanel.this.setButtons(listSelectionEvent);
            }
        });
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(LocalString.get("Algorithms")));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_AddBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_EditBut, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_DeleteBut, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.m_LoadOptionsBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.m_SaveOptionsBut, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.m_List), "Center");
        this.add((Component)jPanel2, "South");
    }

    public void setExperiment(Experiment experiment) {
        this.m_Exp = experiment;
        this.m_AddBut.setEnabled(true);
        this.m_List.setModel(this.m_AlgorithmListModel);
        this.m_List.setCellRenderer(new ObjectCellRenderer());
        this.m_AlgorithmListModel.removeAllElements();
        if (this.m_Exp.getPropertyArray() instanceof Classifier[]) {
            Classifier[] classifierArray = (Classifier[])this.m_Exp.getPropertyArray();
            for (int i = 0; i < classifierArray.length; ++i) {
                this.m_AlgorithmListModel.addElement(classifierArray[i]);
            }
        }
        this.m_EditBut.setEnabled(this.m_AlgorithmListModel.size() > 0);
        this.m_DeleteBut.setEnabled(this.m_AlgorithmListModel.size() > 0);
        this.m_LoadOptionsBut.setEnabled(this.m_AlgorithmListModel.size() > 0);
        this.m_SaveOptionsBut.setEnabled(this.m_AlgorithmListModel.size() > 0);
    }

    private void addNewAlgorithm(Classifier classifier) {
        if (!this.m_Editing) {
            this.m_AlgorithmListModel.addElement(classifier);
        } else {
            this.m_AlgorithmListModel.setElementAt(classifier, this.m_List.getSelectedIndex());
        }
        Classifier[] classifierArray = new Classifier[this.m_AlgorithmListModel.size()];
        for (int i = 0; i < classifierArray.length; ++i) {
            classifierArray[i] = (Classifier)this.m_AlgorithmListModel.elementAt(i);
        }
        this.m_Exp.setPropertyArray(classifierArray);
        this.m_Editing = false;
    }

    private void setButtons(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.m_List) {
            this.m_DeleteBut.setEnabled(this.m_List.getSelectedIndex() > -1);
            this.m_AddBut.setEnabled(true);
            this.m_EditBut.setEnabled(this.m_List.getSelectedIndices().length == 1);
            this.m_LoadOptionsBut.setEnabled(this.m_List.getSelectedIndices().length == 1);
            this.m_SaveOptionsBut.setEnabled(this.m_List.getSelectedIndices().length == 1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.m_AddBut) {
            this.m_Editing = false;
            if (this.m_PD == null) {
                int n2 = this.getLocationOnScreen().x;
                int n3 = this.getLocationOnScreen().y;
                this.m_PD = new PropertyDialog(this.m_ClassifierEditor, n2, n3);
            } else {
                this.m_PD.setVisible(true);
            }
        } else if (actionEvent.getSource() == this.m_EditBut) {
            if (this.m_List.getSelectedValue() != null) {
                this.m_Editing = true;
                if (this.m_PD == null) {
                    int n4 = this.getLocationOnScreen().x;
                    int n5 = this.getLocationOnScreen().y;
                    this.m_PD = new PropertyDialog(this.m_ClassifierEditor, n4, n5);
                } else {
                    this.m_PD.setVisible(true);
                }
                this.m_PD.getEditor().setValue(this.m_List.getSelectedValue());
            }
        } else if (actionEvent.getSource() == this.m_DeleteBut) {
            int n6;
            int[] nArray = this.m_List.getSelectedIndices();
            if (nArray != null) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    n6 = nArray[i];
                    this.m_AlgorithmListModel.removeElementAt(n6);
                    if (this.m_Exp.getDatasets().size() > n6) {
                        this.m_List.setSelectedIndex(n6);
                        continue;
                    }
                    this.m_List.setSelectedIndex(n6 - 1);
                }
            }
            if (this.m_List.getSelectedIndex() == -1) {
                this.m_EditBut.setEnabled(false);
                this.m_DeleteBut.setEnabled(false);
                this.m_LoadOptionsBut.setEnabled(false);
                this.m_SaveOptionsBut.setEnabled(false);
            }
            Classifier[] classifierArray = new Classifier[this.m_AlgorithmListModel.size()];
            for (n6 = 0; n6 < classifierArray.length; ++n6) {
                classifierArray[n6] = (Classifier)this.m_AlgorithmListModel.elementAt(n6);
            }
            this.m_Exp.setPropertyArray(classifierArray);
        } else if (actionEvent.getSource() == this.m_LoadOptionsBut) {
            int n7;
            if (this.m_List.getSelectedValue() != null && (n7 = this.m_FileChooser.showOpenDialog(this)) == 0) {
                try {
                    File file = this.m_FileChooser.getSelectedFile();
                    if (!file.getAbsolutePath().toLowerCase().endsWith(".xml")) {
                        file = new File(file.getAbsolutePath() + ".xml");
                    }
                    XMLClassifier xMLClassifier = new XMLClassifier();
                    Classifier classifier = (Classifier)xMLClassifier.read(file);
                    this.m_AlgorithmListModel.setElementAt(classifier, this.m_List.getSelectedIndex());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (actionEvent.getSource() == this.m_SaveOptionsBut && this.m_List.getSelectedValue() != null && (n = this.m_FileChooser.showSaveDialog(this)) == 0) {
            try {
                File file = this.m_FileChooser.getSelectedFile();
                if (!file.getAbsolutePath().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
                XMLClassifier xMLClassifier = new XMLClassifier();
                xMLClassifier.write(file, this.m_List.getSelectedValue());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected Object copyObject(Object object) {
        Object object2 = null;
        try {
            SerializedObject serializedObject = new SerializedObject(object);
            object2 = serializedObject.getObject();
        }
        catch (Exception exception) {
            System.err.println(LocalString.get("AlgorithmListPanel: Problem copying object"));
            System.err.println(exception);
        }
        return object2;
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame(LocalString.get("Algorithm List Editor"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            AlgorithmListPanel algorithmListPanel = new AlgorithmListPanel();
            jFrame.getContentPane().add((Component)algorithmListPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            System.err.println(LocalString.get("Short nap"));
            Thread.currentThread();
            Thread.sleep(3000L);
            System.err.println(LocalString.get("Done"));
            algorithmListPanel.setExperiment(new Experiment());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PropertyEditorManager.registerEditor(class$weka$core$SelectedTag == null ? (class$weka$core$SelectedTag = AlgorithmListPanel.class$("weka.core.SelectedTag")) : class$weka$core$SelectedTag, class$weka$gui$SelectedTagEditor == null ? (class$weka$gui$SelectedTagEditor = AlgorithmListPanel.class$("weka.gui.SelectedTagEditor")) : class$weka$gui$SelectedTagEditor);
        PropertyEditorManager.registerEditor(class$weka$filters$Filter == null ? (class$weka$filters$Filter = AlgorithmListPanel.class$("weka.filters.Filter")) : class$weka$filters$Filter, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = AlgorithmListPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(array$Lweka$classifiers$Classifier == null ? (array$Lweka$classifiers$Classifier = AlgorithmListPanel.class$("[Lweka.classifiers.Classifier;")) : array$Lweka$classifiers$Classifier, class$weka$gui$GenericArrayEditor == null ? (class$weka$gui$GenericArrayEditor = AlgorithmListPanel.class$("weka.gui.GenericArrayEditor")) : class$weka$gui$GenericArrayEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AlgorithmListPanel.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, class$weka$gui$GenericArrayEditor == null ? (class$weka$gui$GenericArrayEditor = AlgorithmListPanel.class$("weka.gui.GenericArrayEditor")) : class$weka$gui$GenericArrayEditor);
        PropertyEditorManager.registerEditor(class$weka$classifiers$Classifier == null ? (class$weka$classifiers$Classifier = AlgorithmListPanel.class$("weka.classifiers.Classifier")) : class$weka$classifiers$Classifier, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = AlgorithmListPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$classifiers$CostMatrix == null ? (class$weka$classifiers$CostMatrix = AlgorithmListPanel.class$("weka.classifiers.CostMatrix")) : class$weka$classifiers$CostMatrix, class$weka$gui$CostMatrixEditor == null ? (class$weka$gui$CostMatrixEditor = AlgorithmListPanel.class$("weka.gui.CostMatrixEditor")) : class$weka$gui$CostMatrixEditor);
    }

    public class ObjectCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = object.getClass().getName();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if (object instanceof OptionHandler) {
                string = string + " " + Utils.joinOptions(((OptionHandler)object).getOptions());
            }
            this.setText(string);
            return component;
        }
    }
}

