/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Add
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    protected int m_AttributeType = 0;
    protected String m_Name = LocalString.get("unnamed");
    private SingleIndex m_Insert = new SingleIndex(LocalString.get("last"));
    protected FastVector m_Labels = new FastVector(5);

    public String globalInfo() {
        return LocalString.get("An instance filter that adds a new attribute to the dataset.") + LocalString.get(" The new attribute will contain all missing values.");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tSpecify where to insert the column. First and last\n") + LocalString.get("\tare valid indexes.(default last)"), "C", 1, LocalString.get("-C <index>")));
        vector.addElement(new Option(LocalString.get("\tCreate nominal attribute with given labels\n") + LocalString.get("\t(default numeric attribute)"), "L", 1, LocalString.get("-L <label1,label2,...>")));
        vector.addElement(new Option(LocalString.get("\tName of the new attribute.\n") + LocalString.get("\t(default = 'Unnamed')"), "N", 1, LocalString.get("-N <name>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setAttributeIndex(Utils.getOption('C', stringArray));
        this.setNominalLabels(Utils.getOption('L', stringArray));
        this.setAttributeName(Utils.getOption('N', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-N";
        stringArray[n++] = this.getAttributeName();
        if (this.m_AttributeType == 1) {
            stringArray[n++] = "-L";
            stringArray[n++] = this.getNominalLabels();
        }
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_Insert.setUpper(instances.numAttributes());
        Instances instances2 = new Instances(instances, 0);
        Attribute attribute = null;
        switch (this.m_AttributeType) {
            case 0: {
                attribute = new Attribute(this.m_Name);
                break;
            }
            case 1: {
                attribute = new Attribute(this.m_Name, this.m_Labels);
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalString.get("Unknown attribute type in Add"));
            }
        }
        if (this.m_Insert.getIndex() < 0 || this.m_Insert.getIndex() > this.getInputFormat().numAttributes()) {
            throw new IllegalArgumentException(LocalString.get("Index out of range"));
        }
        instances2.insertAttributeAt(attribute, this.m_Insert.getIndex());
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instance instance2 = (Instance)instance.copy();
        this.copyStringValues(instance2, true, instance2.dataset(), this.getOutputFormat());
        instance2.setDataset(null);
        instance2.insertAttributeAt(this.m_Insert.getIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String attributeNameTipText() {
        return LocalString.get("Set the new attribute's name.");
    }

    public String getAttributeName() {
        return this.m_Name;
    }

    public void setAttributeName(String string) {
        String string2 = string.trim();
        if (string2.indexOf(32) >= 0) {
            if (string2.indexOf(39) != 0) {
                string2 = string2.replace('\'', ' ');
            }
            string2 = '\'' + string2 + '\'';
        }
        if (string2.equals("")) {
            string2 = LocalString.get("unnamed");
        }
        this.m_Name = string2;
    }

    public String attributeIndexTipText() {
        return LocalString.get("The position (starting from 1) where the attribute will be inserted ") + LocalString.get("(first and last are valid indices).");
    }

    public String getAttributeIndex() {
        return this.m_Insert.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_Insert.setSingleIndex(string);
    }

    public String nominalLabelsTipText() {
        return LocalString.get("The list of value labels (nominal attribute creation only). ") + LocalString.get(" The list must be comma-separated, eg: \"red,green,blue\".") + LocalString.get(" If this is empty, the created attribute will be numeric.");
    }

    public String getNominalLabels() {
        String string = "";
        for (int i = 0; i < this.m_Labels.size(); ++i) {
            string = i == 0 ? (String)this.m_Labels.elementAt(i) : string + "," + (String)this.m_Labels.elementAt(i);
        }
        return string;
    }

    public void setNominalLabels(String string) {
        String string2;
        int n;
        FastVector fastVector = new FastVector(10);
        while ((n = string.indexOf(44)) >= 0) {
            string2 = string.substring(0, n).trim();
            if (string2.equals("")) {
                throw new IllegalArgumentException(LocalString.get("Invalid label list at ") + string.substring(n));
            }
            fastVector.addElement(string2);
            string = string.substring(n + 1);
        }
        string2 = string.trim();
        if (!string2.equals("")) {
            fastVector.addElement(string2);
        }
        this.m_Labels = fastVector;
        this.m_AttributeType = fastVector.size() == 0 ? 0 : 1;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Add(), stringArray);
            } else {
                Filter.filterFile(new Add(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

