/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.part.MakeDecList;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class PART
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
Summarizable,
AdditionalMeasureProducer {
    private MakeDecList m_root;
    private float m_CF = 0.25f;
    private int m_minNumObj = 2;
    private boolean m_reducedErrorPruning = false;
    private int m_numFolds = 3;
    private boolean m_binarySplits = false;
    private boolean m_unpruned = false;
    private int m_Seed = 1;

    public String globalInfo() {
        return LocalString.get("Class for generating a PART decision list. Uses ") + LocalString.get("separate-and-conquer. Builds a partial C4.5 decision tree ") + LocalString.get("in each iteration and makes the \"best\" leaf into a rule. ") + LocalString.get("For more information, see:\n\n") + LocalString.get("Eibe Frank and Ian H. Witten (1998). \"Generating ") + LocalString.get("Accurate Rule Sets Without Global Optimization.\"") + LocalString.get("In Shavlik, J., ed., Machine Learning: Proceedings of the ") + LocalString.get("Fifteenth International Conference, Morgan Kaufmann Publishers.");
    }

    public void buildClassifier(Instances instances) throws Exception {
        ModelSelection modelSelection = this.m_binarySplits ? new BinC45ModelSelection(this.m_minNumObj, instances) : new C45ModelSelection(this.m_minNumObj, instances);
        this.m_root = this.m_unpruned ? new MakeDecList(modelSelection, this.m_minNumObj) : (this.m_reducedErrorPruning ? new MakeDecList(modelSelection, this.m_numFolds, this.m_minNumObj, this.m_Seed) : new MakeDecList(modelSelection, this.m_CF, this.m_minNumObj));
        this.m_root.buildClassifier(instances);
        if (this.m_binarySplits) {
            ((BinC45ModelSelection)modelSelection).cleanup();
        } else {
            ((C45ModelSelection)modelSelection).cleanup();
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_root.classifyInstance(instance);
    }

    public final double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_root.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option(LocalString.get("\tSet confidence threshold for pruning.\n") + LocalString.get("\t(default 0.25)"), "C", 1, LocalString.get("-C <pruning confidence>")));
        vector.addElement(new Option(LocalString.get("\tSet minimum number of objects per leaf.\n") + LocalString.get("\t(default 2)"), "M", 1, LocalString.get("-M <minimum number of objects>")));
        vector.addElement(new Option(LocalString.get("\tUse reduced error pruning."), "R", 0, "-R"));
        vector.addElement(new Option(LocalString.get("\tSet number of folds for reduced error\n") + LocalString.get("\tpruning. One fold is used as pruning set.\n") + LocalString.get("\t(default 3)"), "N", 1, LocalString.get("-N <number of folds>")));
        vector.addElement(new Option(LocalString.get("\tUse binary splits only."), "B", 0, "-B"));
        vector.addElement(new Option(LocalString.get("\tGenerate unpruned decision list."), "U", 0, "-U"));
        vector.addElement(new Option(LocalString.get("\tSeed for random data shuffling (default 1)."), "Q", 1, LocalString.get("-Q <seed>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        this.m_unpruned = Utils.getFlag('U', stringArray);
        this.m_reducedErrorPruning = Utils.getFlag('R', stringArray);
        this.m_binarySplits = Utils.getFlag('B', stringArray);
        String string2 = Utils.getOption('C', stringArray);
        if (string2.length() != 0) {
            if (this.m_reducedErrorPruning) {
                throw new Exception(LocalString.get("Setting CF doesn't make sense ") + LocalString.get("for reduced error pruning."));
            }
            this.m_CF = new Float(string2).floatValue();
            if (this.m_CF <= 0.0f || this.m_CF >= 1.0f) {
                throw new Exception(LocalString.get("CF has to be greater than zero and smaller than one!"));
            }
        } else {
            this.m_CF = 0.25f;
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            if (!this.m_reducedErrorPruning) {
                throw new Exception(LocalString.get("Setting the number of folds") + LocalString.get(" does only make sense for") + LocalString.get(" reduced error pruning."));
            }
            this.m_numFolds = Integer.parseInt(string);
        } else {
            this.m_numFolds = 3;
        }
        String string3 = Utils.getOption('M', stringArray);
        this.m_minNumObj = string3.length() != 0 ? Integer.parseInt(string3) : 2;
        String string4 = Utils.getOption('Q', stringArray);
        this.m_Seed = string4.length() != 0 ? Integer.parseInt(string4) : 1;
    }

    public String[] getOptions() {
        String[] stringArray = new String[11];
        int n = 0;
        if (this.m_unpruned) {
            stringArray[n++] = "-U";
        }
        if (this.m_reducedErrorPruning) {
            stringArray[n++] = "-R";
        }
        if (this.m_binarySplits) {
            stringArray[n++] = "-B";
        }
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_minNumObj;
        if (!this.m_reducedErrorPruning) {
            stringArray[n++] = "-C";
            stringArray[n++] = "" + this.m_CF;
        }
        if (this.m_reducedErrorPruning) {
            stringArray[n++] = "-N";
            stringArray[n++] = "" + this.m_numFolds;
        }
        stringArray[n++] = "-Q";
        stringArray[n++] = "" + this.m_Seed;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        if (this.m_root == null) {
            return LocalString.get("No classifier built");
        }
        return LocalString.get("PART decision list\n------------------\n\n") + this.m_root.toString();
    }

    public String toSummaryString() {
        return LocalString.get("Number of rules: ") + this.m_root.numRules() + "\n";
    }

    public double measureNumRules() {
        return this.m_root.numRules();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(LocalString.get("measureNumRules"));
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase(LocalString.get("measureNumRules")) == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(string + LocalString.get(" not supported (PART)"));
    }

    public String confidenceFactorTipText() {
        return LocalString.get("The confidence factor used for pruning (smaller values incur ") + LocalString.get("more pruning).");
    }

    public float getConfidenceFactor() {
        return this.m_CF;
    }

    public void setConfidenceFactor(float f) {
        this.m_CF = f;
    }

    public String minNumObjTipText() {
        return LocalString.get("The minimum number of instances per rule.");
    }

    public int getMinNumObj() {
        return this.m_minNumObj;
    }

    public void setMinNumObj(int n) {
        this.m_minNumObj = n;
    }

    public String reducedErrorPruningTipText() {
        return LocalString.get("Whether reduced-error pruning is used instead of C.4.5 pruning.");
    }

    public boolean getReducedErrorPruning() {
        return this.m_reducedErrorPruning;
    }

    public void setReducedErrorPruning(boolean bl) {
        this.m_reducedErrorPruning = bl;
    }

    public String unprunedTipText() {
        return LocalString.get("Whether pruning is performed.");
    }

    public boolean getUnpruned() {
        return this.m_unpruned;
    }

    public void setUnpruned(boolean bl) {
        this.m_unpruned = bl;
    }

    public String numFoldsTipText() {
        return LocalString.get("Determines the amount of data used for reduced-error pruning. ") + LocalString.get(" One fold is used for pruning, the rest for growing the rules.");
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int n) {
        this.m_numFolds = n;
    }

    public String seedTipText() {
        return LocalString.get("The seed used for randomizing the data ") + LocalString.get("when reduced-error pruning is used.");
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public String binarySplitsTipText() {
        return LocalString.get("Whether to use binary splits on nominal attributes when ") + LocalString.get("building the partial trees.");
    }

    public boolean getBinarySplits() {
        return this.m_binarySplits;
    }

    public void setBinarySplits(boolean bl) {
        this.m_binarySplits = bl;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new PART(), stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

